/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.SimpleMerger;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class ModelImpl
implements Model {
    private static final long serialVersionUID = -2087521863213381434L;
    protected final Map<String, BioPAXElement> idMap = BPCollections.I.createMap();
    private final Map<String, String> nameSpacePrefixMap = new HashMap<String, String>();
    private BioPAXLevel level;
    private transient BioPAXFactory factory;
    private final transient Set<BioPAXElement> exposedObjectSet = new UnmodifiableImplicitSet(this.idMap.values());
    private boolean addDependencies = false;
    private String xmlBase;

    protected ModelImpl() {
    }

    protected ModelImpl(BioPAXLevel level) {
        this(level.getDefaultFactory());
    }

    public ModelImpl(BioPAXFactory factory) {
        this();
        this.factory = factory;
        this.level = factory.getLevel();
    }

    @Override
    public synchronized boolean containsID(String id) {
        return this.idMap.containsKey(id);
    }

    @Override
    public synchronized BioPAXElement getByID(String id) {
        BioPAXElement ret = this.idMap.get(id);
        if (ret != null) assert (ret.getUri().equals(id));
        return ret;
    }

    @Override
    public Map<String, String> getNameSpacePrefixMap() {
        return this.nameSpacePrefixMap;
    }

    private synchronized void setNameSpacePrefixMap(Map<String, String> nameSpacePrefixMap) {
        this.nameSpacePrefixMap.clear();
        this.nameSpacePrefixMap.putAll(nameSpacePrefixMap);
    }

    @Override
    public void setFactory(BioPAXFactory factory) {
        this.factory = factory;
        this.level = factory.getLevel();
    }

    @Override
    public synchronized Set<BioPAXElement> getObjects() {
        return this.exposedObjectSet;
    }

    @Override
    public synchronized <T extends BioPAXElement> Set<T> getObjects(Class<T> filterBy) {
        return new ClassFilterSet<BioPAXElement, T>(this.exposedObjectSet, filterBy);
    }

    synchronized void synchronizedsetObjects(Set<BioPAXElement> objects) {
        this.idMap.clear();
        for (BioPAXElement bpe : objects) {
            this.add(bpe);
        }
    }

    @Override
    public synchronized void remove(BioPAXElement aBioPAXElement) {
        if (this.contains(aBioPAXElement)) {
            this.idMap.remove(aBioPAXElement.getUri());
        }
    }

    @Override
    public synchronized <T extends BioPAXElement> T addNew(Class<T> c, String id) {
        T paxElement = this.factory.create(c, id);
        this.add((BioPAXElement)paxElement);
        return paxElement;
    }

    @Override
    public synchronized boolean contains(BioPAXElement aBioPAXElement) {
        return this.idMap.get(aBioPAXElement.getUri()) == aBioPAXElement;
    }

    @Override
    public synchronized void add(BioPAXElement aBioPAXElement) {
        String rdfId = aBioPAXElement.getUri();
        if (!this.level.hasElement(aBioPAXElement)) {
            throw new IllegalBioPAXArgumentException("Given object is of wrong level");
        }
        if (rdfId == null) {
            throw new IllegalBioPAXArgumentException("null ID: every object must have an RDF ID");
        }
        if (this.idMap.containsKey(rdfId)) {
            throw new IllegalBioPAXArgumentException("I already have an object with the same ID: " + rdfId + ". Try removing it first");
        }
        if (this.contains(aBioPAXElement)) {
            throw new IllegalBioPAXArgumentException("duplicate element:" + aBioPAXElement);
        }
        this.idMap.put(rdfId, aBioPAXElement);
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.level;
    }

    synchronized void setLevel(BioPAXLevel level) {
        this.level = level;
        this.factory = level.getDefaultFactory();
    }

    @Override
    public void setAddDependencies(boolean value) {
        this.addDependencies = value;
    }

    @Override
    public boolean isAddDependencies() {
        return this.addDependencies;
    }

    @Override
    public synchronized void replace(BioPAXElement existing, BioPAXElement replacement) {
        ModelUtils.replace(this, Collections.singletonMap(existing, replacement));
        this.remove(existing);
        if (replacement != null) {
            this.add(replacement);
        }
    }

    @Override
    public synchronized void merge(Model source) {
        SimpleMerger merger = new SimpleMerger(SimpleEditorMap.get(this.level));
        if (source == null) {
            merger.merge((Model)this, this);
        } else {
            merger.merge((Model)this, source);
        }
    }

    @Override
    public synchronized void repair() {
        this.merge(null);
    }

    @Override
    public void setXmlBase(String base) {
        this.xmlBase = base;
    }

    @Override
    public String getXmlBase() {
        return this.xmlBase;
    }

    private class UnmodifiableImplicitSet
    implements Set<BioPAXElement> {
        private final Collection<BioPAXElement> elements;

        public UnmodifiableImplicitSet(Collection<BioPAXElement> elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.elements.contains(o);
        }

        @Override
        public Iterator<BioPAXElement> iterator() {
            return this.elements.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.elements.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.elements.toArray(a);
        }

        @Override
        public boolean add(BioPAXElement bioPAXElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.elements.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends BioPAXElement> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

