/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Set;
import org.apache.commons.collections15.set.CompositeSet;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.controller.PropertyAccessorAdapter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class UnionPropertyAccessor<D extends BioPAXElement, R>
extends PropertyAccessorAdapter<D, R> {
    Set<PropertyAccessor<? extends D, ? extends R>> union;

    public UnionPropertyAccessor(Set<PropertyAccessor<? extends D, ? extends R>> union, Class<D> domain) {
        super(domain, union.iterator().next().getRange(), true);
        if (union == null || union.isEmpty()) {
            throw new IllegalBioPAXArgumentException("Empty set of editors. Can't create a union");
        }
        this.union = union;
        this.multipleCardinality = union.iterator().next().isMultipleCardinality();
    }

    @Override
    public Set getValueFromBean(D bean) throws IllegalBioPAXArgumentException {
        CompositeSet valueFromBean = new CompositeSet();
        for (PropertyAccessor<D, R> atomicAccessor : this.union) {
            if (!atomicAccessor.getDomain().isAssignableFrom(bean.getModelInterface())) continue;
            valueFromBean.addComposited(atomicAccessor.getValueFromBean(bean));
        }
        return valueFromBean;
    }

    @Override
    public boolean isUnknown(Object value) {
        return this.union.iterator().next().isUnknown(value);
    }
}

