/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.DecoratingPropertyAccessor;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitivePropertyAccessor<R extends BioPAXElement, D extends R>
extends DecoratingPropertyAccessor<D, R> {
    private static final Logger log = LoggerFactory.getLogger(TransitivePropertyAccessor.class);

    private TransitivePropertyAccessor(PropertyAccessor<D, R> accessor) {
        super(accessor);
    }

    @Override
    public Set<? extends R> getValueFromBean(D bean) throws IllegalBioPAXArgumentException {
        HashSet values = new HashSet();
        this.transitiveGet(bean, values);
        return values;
    }

    private void transitiveGet(D bean, Set<R> values) {
        Set valuesFromBean = this.impl.getValueFromBean(bean);
        for (BioPAXElement value : valuesFromBean) {
            if (values.add(value)) {
                this.transitiveGet(value, values);
                continue;
            }
            log.debug("Escaped an inf. loop (" + this.impl + ") at " + value.getUri());
        }
    }

    public static <R extends BioPAXElement, D extends R> TransitivePropertyAccessor<R, D> create(PropertyAccessor<D, R> pa) {
        return new TransitivePropertyAccessor<R, D>(pa);
    }
}

