/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.converter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ModelFilter;
import org.biopax.paxtools.controller.PrimitivePropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.dna;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.pathwayStep;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.rna;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RnaRegion;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LevelUpgrader
extends AbstractTraverser
implements ModelFilter {
    private static final Logger log = LoggerFactory.getLogger(LevelUpgrader.class);
    private static final String l3PackageName = "org.biopax.paxtools.model.level3.";
    private BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
    private Properties classesmap = new Properties();
    private Properties propsmap;
    private Map<Object, Object> enumMap;
    private Map<String, String> pep2PE;

    public LevelUpgrader() {
        super((EditorMap)SimpleEditorMap.L2, new Filter<PropertyEditor>(){

            @Override
            public boolean filter(PropertyEditor editor) {
                return !editor.getProperty().equals("STOICHIOMETRIC-COEFFICIENT");
            }
        }, new Filter<PropertyEditor>(){

            @Override
            public boolean filter(PropertyEditor editor) {
                return !editor.getProperty().equals("ORGANISM") || !complex.class.isAssignableFrom(editor.getDomain());
            }
        });
        try {
            this.classesmap.load(this.getClass().getResourceAsStream("classesmap.properties"));
            this.propsmap = new Properties();
            this.propsmap.load(this.getClass().getResourceAsStream("propsmap.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.enumMap = new HashMap<Object, Object>();
    }

    public LevelUpgrader(BioPAXFactory factory) {
        this();
        this.factory = factory;
    }

    @Override
    public Model filter(Model model) {
        if (model == null || model.getLevel() != BioPAXLevel.L2) {
            return model;
        }
        this.preparePep2PEIDMap(model);
        Model newModel = this.factory.createModel();
        newModel.getNameSpacePrefixMap().putAll(model.getNameSpacePrefixMap());
        newModel.setXmlBase(model.getXmlBase());
        this.normalize(model);
        for (BioPAXElement bpe : model.getObjects()) {
            Level3Element l3element = this.mapClass(bpe);
            if (l3element != null) {
                newModel.add(l3element);
                continue;
            }
            log.debug("Skipping " + bpe + " " + bpe.getModelInterface().getSimpleName());
        }
        for (BioPAXElement e : model.getObjects()) {
            if (e instanceof physicalEntityParticipant || e instanceof openControlledVocabulary) continue;
            this.traverse((Level2Element)e, newModel);
        }
        log.info("Done: new L3 model contains " + newModel.getObjects().size() + " BioPAX individuals.");
        this.normalize(newModel);
        return newModel;
    }

    private void normalize(Model model) {
        for (interaction itr : model.getObjects(interaction.class)) {
            if (itr instanceof conversion || itr instanceof control) continue;
            for (InteractionParticipant ip : itr.getPARTICIPANTS()) {
                if (!(ip instanceof physicalEntity)) continue;
                physicalEntity pe = (physicalEntity)ip;
                String newId = itr.getUri() + "_" + LevelUpgrader.getLocalId(pe);
                physicalEntityParticipant pep = model.addNew(physicalEntityParticipant.class, newId);
                pep.setPHYSICAL_ENTITY(pe);
                itr.removePARTICIPANTS(pe);
                itr.addPARTICIPANTS(pep);
            }
        }
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                if (spe.getName().isEmpty()) {
                    spe.getName().addAll(er.getName());
                }
                if (spe.getDisplayName() != null && spe.getDisplayName().trim().length() != 0) continue;
                spe.setDisplayName(er.getDisplayName());
            }
        }
    }

    private Level3Element mapClass(BioPAXElement bpe) {
        Level3Element newElement = null;
        if (bpe instanceof physicalEntityParticipant) {
            String id = this.pep2PE.get(bpe.getUri());
            if (id == null) {
                log.warn("No mapping possible for " + bpe.getUri());
                return null;
            }
            if (id.equals(bpe.getUri())) {
                newElement = this.createSimplePhysicalEntity((physicalEntityParticipant)bpe);
            }
        } else if (!(bpe instanceof openControlledVocabulary)) {
            String type = bpe.getModelInterface().getSimpleName();
            String newType = this.classesmap.getProperty(type).trim();
            if (newType != null && this.factory.canInstantiate(this.factory.getLevel().getInterfaceForName(newType))) {
                newElement = (Level3Element)this.factory.create(newType, bpe.getUri());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("No mapping found for " + type);
                }
                return null;
            }
        }
        return newElement;
    }

    private SimplePhysicalEntity createSimplePhysicalEntity(physicalEntityParticipant pep) {
        physicalEntity pe2 = pep.getPHYSICAL_ENTITY();
        return this.createSimplePhysicalEntity(pe2, pep.getUri());
    }

    private SimplePhysicalEntity createSimplePhysicalEntity(physicalEntity pe2, String id) {
        SimplePhysicalEntity e = null;
        if (pe2 instanceof protein) {
            e = this.factory.create(Protein.class, id);
        } else if (pe2 instanceof dna) {
            e = this.factory.create(DnaRegion.class, id);
        } else if (pe2 instanceof rna) {
            e = this.factory.create(RnaRegion.class, id);
        } else if (pe2 instanceof smallMolecule) {
            e = this.factory.create(SmallMolecule.class, id);
        }
        return e;
    }

    private ControlledVocabulary convertAndAddVocabulary(openControlledVocabulary value, Level2Element parent, Model newModel, PropertyEditor newEditor) {
        String id = value.getUri();
        if (!newModel.containsID(id)) {
            if (newEditor != null) {
                newModel.addNew(newEditor.getRange(), id);
                this.traverse(value, newModel);
            } else {
                log.warn("Cannot Convert CV: " + value + " (for prop.: " + newEditor + ")");
            }
        }
        return (ControlledVocabulary)newModel.getByID(id);
    }

    protected void visit(Object value, BioPAXElement parent, Model newModel, PropertyEditor editor) {
        String id;
        if (editor != null && editor.isUnknown(value)) {
            return;
        }
        String parentType = parent.getModelInterface().getSimpleName();
        BioPAXElement newParent = null;
        Object newValue = value;
        String newProp = this.propsmap.getProperty(editor.getProperty());
        if (parent instanceof pathway && value instanceof pathwayStep && editor.getProperty().equals("PATHWAY-COMPONENTS")) {
            newProp = "pathwayOrder";
        }
        if ((newParent = parent instanceof physicalEntityParticipant ? this.getMappedPE((physicalEntityParticipant)parent, newModel) : newModel.getByID(parent.getUri())) == null) {
            throw new IllegalAccessError("Of " + value + ", parent " + parentType + " : " + parent + " is not yet in the new model: ");
        }
        PropertyEditor<BioPAXElement, ?> newEditor = SimpleEditorMap.L3.getEditorForProperty(newProp, newParent.getModelInterface());
        if (value instanceof Level2Element) {
            if (value instanceof physicalEntityParticipant) {
                physicalEntityParticipant pep = (physicalEntityParticipant)value;
                newValue = this.getMappedPE(pep, newModel);
                float coeff = (float)pep.getSTOICHIOMETRIC_COEFFICIENT();
                if (coeff > 1.0f) {
                    if (parent instanceof conversion || parent instanceof complex) {
                        PhysicalEntity pe3 = (PhysicalEntity)newValue;
                        Stoichiometry stoichiometry = this.factory.create(Stoichiometry.class, pe3.getUri() + "-stoichiometry" + Math.random());
                        stoichiometry.setStoichiometricCoefficient(coeff);
                        stoichiometry.setPhysicalEntity(pe3);
                        if (parent instanceof conversion) {
                            Conversion conv = (Conversion)newModel.getByID(parent.getUri());
                            conv.addParticipantStoichiometry(stoichiometry);
                        } else {
                            Complex cplx = (Complex)newModel.getByID(parent.getUri());
                            cplx.addComponentStoichiometry(stoichiometry);
                        }
                        newModel.add(stoichiometry);
                    } else if (log.isDebugEnabled()) {
                        log.debug(pep + " STOICHIOMETRIC_COEFFICIENT is " + coeff + ", but the pEP's parent is not a conversion or complex - " + parent);
                    }
                }
                this.traverse(pep, newModel);
            } else if (value instanceof openControlledVocabulary) {
                newValue = this.convertAndAddVocabulary((openControlledVocabulary)value, (Level2Element)parent, newModel, newEditor);
            } else {
                id = ((Level2Element)value).getUri();
                newValue = newModel.getByID(id);
            }
        } else if (value.getClass().isEnum()) {
            newValue = this.getMatchingEnum(value);
        } else if (parent instanceof relationshipXref && editor.getProperty().equals("RELATIONSHIP-TYPE")) {
            id = URLEncoder.encode(value.toString());
            if (!newModel.containsID(id)) {
                RelationshipTypeVocabulary cv = (RelationshipTypeVocabulary)newModel.addNew(newEditor.getRange(), id);
                cv.addTerm(value.toString().toLowerCase());
                newValue = cv;
            } else {
                newValue = newModel.getByID(id);
            }
        }
        if (newValue == null) {
            log.debug("Skipped for  " + parent + "." + editor.getProperty() + "=" + value + " ==> " + newParent.getUri() + "." + newProp + " = NULL");
            return;
        }
        if (newProp != null) {
            if (newEditor != null) {
                this.setNewProperty(newParent, newValue, newEditor);
            } else if (parent instanceof physicalEntity) {
                Set<physicalEntityParticipant> ppeps = ((physicalEntity)parent).isPHYSICAL_ENTITYof();
                for (physicalEntityParticipant pep : ppeps) {
                    newParent = this.getMappedPE(pep, newModel);
                    if (newParent != null) {
                        newEditor = SimpleEditorMap.L3.getEditorForProperty(newProp, newParent.getModelInterface());
                        this.setNewProperty(newParent, newValue, newEditor);
                        continue;
                    }
                    log.error("Cannot find converted PE to map the property " + editor.getProperty() + " of physicalEntity " + parent + " (" + parentType + ")");
                }
            } else {
                log.debug("Skipped property " + editor.getProperty() + " in " + parentType + " to " + newParent.getModelInterface().getSimpleName() + " conversion (" + parent + ")");
            }
        } else {
            log.warn("No mapping defined for property: " + parentType + "." + editor.getProperty());
        }
    }

    private void setNewProperty(BioPAXElement newParent, Object newValue, PropertyEditor newEditor) {
        if (newEditor != null) {
            if (newEditor instanceof PrimitivePropertyEditor) {
                newValue = newValue.toString();
            }
            newEditor.setValueToBean(newValue, newParent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PhysicalEntity getMappedPE(physicalEntityParticipant pep, Model newModel) {
        String id = this.pep2PE.get(pep.getUri());
        physicalEntity pe2er = pep.getPHYSICAL_ENTITY();
        if (id == null || pe2er == null) {
            throw new IllegalAccessError("Illegal pEP (cannot convert): " + pep.getUri());
        }
        BioPAXElement pe = newModel.getByID(id);
        String inf = "pEP " + pep + " that contains " + pe2er.getModelInterface().getSimpleName();
        if (!this.isSimplePhysicalEntity(pe2er)) {
            if (pe != null) throw new IllegalAccessError("Illegal conversion of pEP: " + inf);
            if (log.isDebugEnabled()) {
                log.debug(inf + " gets new ID: " + pe2er.getUri());
            }
            pe = newModel.getByID(pe2er.getUri());
            return (PhysicalEntity)pe;
        } else {
            if (pe != null) return (PhysicalEntity)pe;
            throw new IllegalAccessError("No PE for: " + inf + " found in the new Model");
        }
    }

    private boolean isSimplePhysicalEntity(Level2Element pe2) {
        return pe2 instanceof protein || pe2 instanceof dna || pe2 instanceof rna || pe2 instanceof smallMolecule;
    }

    public static String getLocalId(BioPAXElement bpe) {
        String id = bpe.getUri();
        return id != null ? id.replaceFirst("^.+[#/]", "") : null;
    }

    protected Object getMatchingEnum(Object o) {
        assert (o.getClass().isEnum());
        if (this.enumMap.containsKey(o)) {
            return this.enumMap.get(o);
        }
        if (!this.propsmap.containsKey(o.toString())) {
            this.enumMap.put(o, null);
            return null;
        }
        String l2Name = o.getClass().getName();
        if (!this.classesmap.containsKey(l2Name = l2Name.substring(l2Name.lastIndexOf(".") + 1))) {
            log.error("There is no class mapping for enum " + o.getClass() + " in classesmap");
            return null;
        }
        String l3Name = this.classesmap.getProperty(l2Name);
        assert (l3Name != null);
        String l3value = this.propsmap.getProperty(o.toString());
        assert (l3value != null);
        Class<?> cls = null;
        try {
            cls = Class.forName(l3PackageName + l3Name);
        }
        catch (ClassNotFoundException e) {
            log.error("Cannot find class org.biopax.paxtools.model.level3." + l3Name);
        }
        assert (cls != null);
        Method meth = null;
        try {
            meth = cls.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            log.error("No valueOf method here. Is this possible ?!");
            e.printStackTrace();
        }
        assert (meth != null);
        Object l3enum = null;
        try {
            l3enum = meth.invoke(null, l3value);
        }
        catch (IllegalAccessException e) {
            log.error("Cannot invoke method " + meth + " - " + e);
        }
        catch (InvocationTargetException e) {
            log.error("Cannot invoke method " + meth + " - " + e);
        }
        this.enumMap.put(o, l3enum);
        return l3enum;
    }

    private List<Set<physicalEntityParticipant>> getPepsGrouped(physicalEntity pe) {
        ArrayList<Set<physicalEntityParticipant>> list = new ArrayList<Set<physicalEntityParticipant>>();
        for (physicalEntityParticipant pep : pe.isPHYSICAL_ENTITYof()) {
            boolean added = false;
            for (Set set : list) {
                physicalEntityParticipant first = (physicalEntityParticipant)set.iterator().next();
                if (!first.isInEquivalentState(pep)) continue;
                set.add(pep);
                added = true;
                break;
            }
            if (added) continue;
            HashSet<physicalEntityParticipant> group = new HashSet<physicalEntityParticipant>();
            group.add(pep);
            list.add(group);
        }
        return list;
    }

    private Map<String, String> getPep2StateIDMapping(physicalEntity pe) {
        List<Set<physicalEntityParticipant>> sets = this.getPepsGrouped(pe);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Set<physicalEntityParticipant> set : sets) {
            physicalEntityParticipant first = set.iterator().next();
            for (physicalEntityParticipant pep : set) {
                map.put(pep.getUri(), first.getUri());
            }
        }
        return map;
    }

    protected void preparePep2PEIDMap(Model model) {
        assert (model.getLevel() == BioPAXLevel.L2);
        this.pep2PE = new HashMap<String, String>();
        for (physicalEntity pe : model.getObjects(physicalEntity.class)) {
            Map<String, String> map = this.getPep2StateIDMapping(pe);
            this.pep2PE.putAll(map);
        }
    }
}

