package org.biopax.paxtools.model.level3;


/**
 * <b>Definition:</b> A term that describes the form of the physical entity in the context of the experiment. This is a
 * reference to the PSI Molecular Interaction ontology (MI) participant identification method (e.g. mass spectrometry),
 * experimental role (e.g. bait, prey) or experimental preparation (e.g. expression level) type.
 *
 * @see <a href="http://www.psidev.info">PSI-DEV</a>
 * @see <a href="http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=MI&termId=MI%3A0002&termName=participant%20identification%20method">
 *     PSI-MI: Participant Identification Method</a>
 * @see <a href="http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=MI&termId=MI%3A0495&termName=experimental%20role">
 *     PSI-MI:Experimental Role</a>
 * @see <a href="http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=MI&termId=MI%3A0346&termName=experimental%20preparation">
 *     PSI-MI: Experimental Preparation</a>
 */
public interface ExperimentalFormVocabulary extends ControlledVocabulary
{

}
