/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.BiopaxSafeSet;

public enum BPCollections {
    I;

    private CollectionProvider cProvider;
    private final Log log = LogFactory.getLog(BPCollections.class);

    private BPCollections() {
        String prop = System.getProperty("paxtools.CollectionProvider");
        this.log.info((Object)("System property: paxtools.CollectionProvider=" + prop));
        if (prop != null) {
            try {
                Class<?> cProviderClass = Class.forName(prop);
                this.cProvider = (CollectionProvider)cProviderClass.newInstance();
                this.log.info((Object)("CollectionProvider " + prop + " was successfully activated."));
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not initialize the specified collector provider:" + prop + " . Falling back to default " + "Hash based implementation. Underlying exception is " + e));
            }
        }
        if (this.cProvider == null) {
            this.cProvider = new CollectionProvider(){

                @Override
                public <R> Set<R> createSet() {
                    return new HashSet();
                }

                @Override
                public <D, R> Map<D, R> createMap() {
                    return new HashMap();
                }
            };
            this.log.info((Object)"Using the default CollectionProvider (creates HashMap, HashSet).");
        }
    }

    public void setProvider(CollectionProvider newProvider) {
        if (newProvider == null) {
            throw new IllegalArgumentException();
        }
        this.cProvider = newProvider;
        this.log.info((Object)("Using CollectionProvider: " + newProvider.getClass().getSimpleName()));
    }

    public <R> Set<R> createSet() {
        return this.cProvider.createSet();
    }

    public <R extends BioPAXElement> Set<R> createSafeSet() {
        return new BiopaxSafeSet();
    }

    public <D, R> Map<D, R> createMap() {
        return this.cProvider.createMap();
    }

    public static interface CollectionProvider {
        public <R> Set<R> createSet();

        public <D, R> Map<D, R> createMap();
    }
}

