/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biins.objectbuilder.types.wrapper.WrapperTypeRegistry;

public class ClassUtils {
    public static <T> boolean isPrimitive(Class<T> cls) {
        return cls.isPrimitive();
    }

    public static <T> boolean isWrapperClass(Class<T> cls) {
        return WrapperTypeRegistry.WRAPPER_CLASSES.contains(cls);
    }

    public static <T> boolean isArray(Class<T> cls) {
        return cls.isArray();
    }

    public static <T> boolean isString(Class<T> cls) {
        return String.class.isAssignableFrom(cls);
    }

    public static <T> boolean isCollection(Class<T> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    public static <T> boolean isEnum(Class<T> type) {
        return type.isEnum();
    }

    public static <T> boolean isMap(Class<T> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static <T> boolean isObject(Class<T> type) {
        return Object.class.equals(type);
    }

    public static boolean isComposite(Class<?> cls) {
        return ClassUtils.isArray(cls) || ClassUtils.isCollection(cls);
    }

    public static boolean isSameCompositeType(Class<?> type1, Class<?> type2) {
        return ClassUtils.isArray(type1) && ClassUtils.isArray(type2) || ClassUtils.isCollection(type1) && ClassUtils.isCollection(type2);
    }

    public static List<Field> getFields(Class<?> type) {
        if (type.getSuperclass() != null) {
            ArrayList<Field> list = new ArrayList<Field>();
            list.addAll(ClassUtils.getFields(type.getSuperclass()));
            list.addAll(ClassUtils.getInstanceFields(type.getDeclaredFields()));
            return list;
        }
        if (Object.class.equals(type)) {
            return Collections.emptyList();
        }
        return Arrays.asList(type.getDeclaredFields());
    }

    private static Collection<? extends Field> getInstanceFields(Field[] fields) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getGenericType() instanceof TypeVariable) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (type.getEnclosingClass() != null && constructor == null) {
                throw new IllegalArgumentException("Inner class is not supported");
            }
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> type, Constructor<?> constructor, Object ... parameters) {
        try {
            return (T)constructor.newInstance(parameters);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static void setProperty(Object o, Field field, Object fieldValue) {
        try {
            if (Modifier.isFinal(field.getModifiers())) {
                return;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(o, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

