/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.types.wrapper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.types.wrapper.BooleanWrapperType;
import org.biins.objectbuilder.types.wrapper.ByteWrapperType;
import org.biins.objectbuilder.types.wrapper.CharacterWrapperType;
import org.biins.objectbuilder.types.wrapper.DoubleWrapperType;
import org.biins.objectbuilder.types.wrapper.FloatWrapperType;
import org.biins.objectbuilder.types.wrapper.IntegerWrapperType;
import org.biins.objectbuilder.types.wrapper.LongWrapperType;
import org.biins.objectbuilder.types.wrapper.ShortWrapperType;
import org.biins.objectbuilder.types.wrapper.VoidWrapperType;
import org.biins.objectbuilder.types.wrapper.WrapperType;

public class WrapperTypeRegistry {
    private static final Map<Class<?>, WrapperType<?>> REGISTRY = new HashMap();
    private static final WrapperType<?>[] PRIMITIVE_TYPES = new WrapperType[]{new BooleanWrapperType(), new ByteWrapperType(), new CharacterWrapperType(), new DoubleWrapperType(), new FloatWrapperType(), new IntegerWrapperType(), new LongWrapperType(), new ShortWrapperType(), new VoidWrapperType()};
    public static final Set<Class<?>> WRAPPER_CLASSES = new HashSet<Class>(Arrays.asList(Boolean.class, Integer.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class));

    public static <T> WrapperType<T> get(Class<T> cls) {
        WrapperType<?> value = REGISTRY.get(cls);
        Validate.notNull(value, (String)("Unknown type " + cls));
        return value;
    }

    static {
        for (WrapperType<?> primitiveType : PRIMITIVE_TYPES) {
            REGISTRY.put(primitiveType.getType(), primitiveType);
        }
    }
}

