/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.types.primitive;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.types.primitive.BooleanType;
import org.biins.objectbuilder.types.primitive.ByteType;
import org.biins.objectbuilder.types.primitive.CharType;
import org.biins.objectbuilder.types.primitive.DoubleType;
import org.biins.objectbuilder.types.primitive.FloatType;
import org.biins.objectbuilder.types.primitive.IntType;
import org.biins.objectbuilder.types.primitive.LongType;
import org.biins.objectbuilder.types.primitive.PrimitiveType;
import org.biins.objectbuilder.types.primitive.ShortType;

public class PrimitiveTypeRegistry {
    private static final Map<Class<?>, PrimitiveType<?>> REGISTRY = new HashMap();
    private static final PrimitiveType<?>[] PRIMITIVE_TYPES;

    public static <T> PrimitiveType<T> get(Class<T> cls) {
        PrimitiveType<?> value = REGISTRY.get(cls);
        Validate.notNull(value, (String)("Unknown type " + cls));
        return value;
    }

    static {
        for (PrimitiveType<?> primitiveType : PRIMITIVE_TYPES = new PrimitiveType[]{new BooleanType(), new ByteType(), new CharType(), new DoubleType(), new FloatType(), new IntType(), new LongType(), new ShortType()}) {
            REGISTRY.put(primitiveType.getType(), primitiveType);
        }
    }
}

