/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.types.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.biins.objectbuilder.types.map.MapType;

public class MapTypeRegistry {
    private static final Map<Class<? extends Map>, Class<? extends Map>> MAP_IMPL_TYPES = new LinkedHashMap<Class<? extends Map>, Class<? extends Map>>();
    private static final Map<Class<? extends Map>, Map> MAP_DEFAULT;

    public static MapType get(Class<Map> type) {
        return new MapType<Map>(type);
    }

    public static Map getDefault(Class<? extends Map> type) {
        for (Class<? extends Map> collectionType : MAP_DEFAULT.keySet()) {
            if (!type.isAssignableFrom(collectionType)) continue;
            return MAP_DEFAULT.get(collectionType);
        }
        throw new IllegalStateException("Unknown collection type " + type);
    }

    public static Class<? extends Map> getDefaultImpl(Class<? extends Map> type) {
        for (Class<? extends Map> collectionType : MAP_IMPL_TYPES.keySet()) {
            if (!type.equals(collectionType)) continue;
            return MAP_IMPL_TYPES.get(collectionType);
        }
        if (Map.class.isAssignableFrom(type)) {
            return HashMap.class;
        }
        throw new IllegalStateException("Unknown collection type " + type);
    }

    public static Map getNewMap(Class<? extends Map> collectionType, Map map) {
        if (HashMap.class.isAssignableFrom(collectionType)) {
            return new HashMap(map);
        }
        if (TreeMap.class.isAssignableFrom(collectionType)) {
            return new TreeMap(map);
        }
        throw new IllegalArgumentException("Not supported collection impl class");
    }

    static {
        MAP_IMPL_TYPES.put(SortedMap.class, TreeMap.class);
        MAP_IMPL_TYPES.put(Map.class, HashMap.class);
        MAP_DEFAULT = new LinkedHashMap<Class<? extends Map>, Map>();
        MAP_DEFAULT.put(SortedMap.class, Collections.emptyMap());
        MAP_DEFAULT.put(Map.class, Collections.emptyMap());
    }
}

