/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.types.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.biins.objectbuilder.types.collection.CollectionType;

public class CollectionTypeRegistry {
    private static final Map<Class<? extends Collection>, Class<? extends Collection>> COLLECTION_IMPL_TYPES = new LinkedHashMap<Class<? extends Collection>, Class<? extends Collection>>();
    private static final Map<Class<? extends Collection>, Collection> COLLECTION_DEFAULT;

    public static <T> CollectionType<T> get(Class<T> type) {
        return new CollectionType<T>(type);
    }

    public static Collection getDefault(Class<? extends Collection> type) {
        for (Class<? extends Collection> collectionType : COLLECTION_DEFAULT.keySet()) {
            if (!type.isAssignableFrom(collectionType)) continue;
            return COLLECTION_DEFAULT.get(collectionType);
        }
        throw new IllegalStateException("Unknown collection type " + type);
    }

    public static Class<? extends Collection> getDefaultImpl(Class<? extends Collection> type) {
        for (Class<? extends Collection> collectionType : COLLECTION_IMPL_TYPES.keySet()) {
            if (!type.isAssignableFrom(collectionType)) continue;
            return COLLECTION_IMPL_TYPES.get(collectionType);
        }
        throw new IllegalStateException("Unknown collection type " + type);
    }

    public static Collection<?> getNewCollection(Class<? extends Collection> collectionType, Collection values) {
        int size = values.size();
        if (ArrayList.class.isAssignableFrom(collectionType)) {
            ArrayList list = new ArrayList(size);
            list.addAll(values);
            return list;
        }
        if (LinkedList.class.isAssignableFrom(collectionType)) {
            ArrayList list = new ArrayList(size);
            list.addAll(values);
            return new LinkedList(list);
        }
        if (LinkedHashSet.class.isAssignableFrom(collectionType)) {
            ArrayList list = new ArrayList(size);
            list.addAll(values);
            return new LinkedHashSet(list);
        }
        throw new IllegalArgumentException("Not supported collection impl class");
    }

    static {
        COLLECTION_IMPL_TYPES.put(List.class, ArrayList.class);
        COLLECTION_IMPL_TYPES.put(Set.class, LinkedHashSet.class);
        COLLECTION_IMPL_TYPES.put(Queue.class, LinkedList.class);
        COLLECTION_IMPL_TYPES.put(Deque.class, LinkedList.class);
        COLLECTION_IMPL_TYPES.put(Collection.class, ArrayList.class);
        COLLECTION_DEFAULT = new LinkedHashMap<Class<? extends Collection>, Collection>();
        COLLECTION_DEFAULT.put(List.class, Collections.emptyList());
        COLLECTION_DEFAULT.put(Set.class, Collections.emptySet());
        COLLECTION_DEFAULT.put(Queue.class, new LinkedList());
        COLLECTION_DEFAULT.put(Deque.class, new LinkedList());
        COLLECTION_DEFAULT.put(Collection.class, Collections.emptyList());
    }
}

