/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class Types {
    private final Class<?> type;
    private Types next;
    private Types last;

    private Types(Class<?> type) {
        this.type = type;
        this.last = this;
    }

    public Types of(Class<?> type) {
        this.last = this.last.next = new Types(type);
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Types next() {
        return this.next;
    }

    public static Types typeOf(Class<?> type) {
        return new Types(type);
    }

    public static Types typeOf(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Types types = Types.typeOf(type.getRawType());
            return Types.typeOf(type, types);
        }
        if (genericType instanceof Class) {
            return Types.typeOf((Class)genericType);
        }
        return null;
    }

    public static Types typeOf(ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length > 0) {
            Types types = Types.typeOf(Types.resolveClass(actualTypeArguments[0]));
            types = Types.typeOf(actualTypeArguments[0], types);
            return types;
        }
        return null;
    }

    private static Types typeOf(Type genericType, Types types) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            types.of(Types.resolveClass(actualTypeArguments[0]));
            types = Types.typeOf(actualTypeArguments[0], types);
            return types;
        }
        return types;
    }

    private static Class resolveClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new IllegalArgumentException();
    }
}

