/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder.generator;

import org.biins.objectbuilder.builder.generator.Generator;

public class NumberSequenceGenerator
implements Generator<Number> {
    private final long min;
    private final long max;
    private long number;

    public NumberSequenceGenerator() {
        this(0, Integer.MAX_VALUE);
    }

    public NumberSequenceGenerator(long max) {
        this(0, max);
    }

    public NumberSequenceGenerator(Number min, Number max) {
        this.min = min.longValue();
        this.max = max.longValue();
        this.number = min.longValue();
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    @Override
    public void reset() {
        this.number = this.min;
    }

    @Override
    public boolean hasNext() {
        return this.number < this.max;
    }

    @Override
    public Number next() {
        if (this.number < this.max) {
            return this.number++;
        }
        throw new IllegalStateException();
    }
}

