/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder.generator;

import org.biins.objectbuilder.builder.generator.Generator;

public class AlphabetGenerator
implements Generator<String> {
    private final boolean isUpperCase;
    private StringBuilder builder = new StringBuilder();

    public AlphabetGenerator() {
        this(false);
    }

    public AlphabetGenerator(boolean isUpperCase) {
        this.isUpperCase = isUpperCase;
    }

    private char format(char ch) {
        return this.isUpperCase ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    @Override
    public void reset() {
        this.builder = new StringBuilder();
    }

    @Override
    public boolean hasNext() {
        return this.builder.length() > 0 && this.builder.charAt(this.builder.length() - 1) != 'z';
    }

    @Override
    public String next() {
        if (this.builder.length() > 0) {
            int last = this.builder.length() - 1;
            char c = this.builder.charAt(last);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c + '\u0001');
                this.builder.setCharAt(last, c);
            } else {
                this.builder.append(this.format('a'));
            }
        } else {
            this.builder.append(this.format('a'));
        }
        return this.builder.toString();
    }
}

