/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.strategy.WrapperGeneratorStrategy;
import org.biins.objectbuilder.types.wrapper.WrapperType;
import org.biins.objectbuilder.types.wrapper.WrapperTypeRegistry;

public class WrapperObjectBuilder
extends AbstractBuilder
implements Builder {
    protected WrapperGeneratorStrategy wrapperStrategy = WrapperGeneratorStrategy.DEFAULT;

    public WrapperObjectBuilder setGeneratorStrategy(WrapperGeneratorStrategy wrapper) {
        this.wrapperStrategy = wrapper;
        return this;
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildPrimitiveWrapper(type);
    }

    public <T> T buildPrimitiveWrapper(Class<T> type) {
        WrapperType<T> wrapperType = WrapperTypeRegistry.get(type);
        switch (this.wrapperStrategy) {
            case NULL: {
                return null;
            }
            case MIN: {
                return wrapperType.getMinValue();
            }
            case MAX: {
                return wrapperType.getMaxValue();
            }
            case RANDOM: {
                return wrapperType.getRandomValue();
            }
        }
        return wrapperType.getDefaultValue();
    }
}

