/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.strategy.StringGeneratorStrategy;
import org.biins.objectbuilder.types.string.StringType;
import org.biins.objectbuilder.types.string.StringTypeRegistry;

public class StringObjectBuilder
extends AbstractBuilder
implements Builder {
    protected StringGeneratorStrategy stringStrategy = StringGeneratorStrategy.DEFAULT;
    private int size = 10;
    private Boolean lower = null;
    private Boolean alpha = null;
    private Boolean numeric = null;

    public StringObjectBuilder setGeneratorStrategy(StringGeneratorStrategy stringStrategy) {
        this.stringStrategy = stringStrategy;
        return this;
    }

    public StringObjectBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public StringObjectBuilder setLower(boolean lower) {
        this.lower = lower;
        return this;
    }

    public StringObjectBuilder setAlpha(boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    public StringObjectBuilder setNumeric(boolean numeric) {
        this.numeric = numeric;
        return this;
    }

    public StringObjectBuilder setAttributes(boolean lower, boolean alpha, boolean numeric) {
        this.lower = lower;
        this.alpha = alpha;
        this.numeric = numeric;
        return this;
    }

    public String build() {
        return this.build(String.class);
    }

    @Override
    public <T> T build(Class<T> type) {
        Validate.isTrue((boolean)String.class.isAssignableFrom(type));
        return this.buildString();
    }

    public <T> T buildString() {
        StringType stringType = StringTypeRegistry.get();
        switch (this.stringStrategy) {
            case EMPTY: {
                return (T)"";
            }
            case NULL: {
                return null;
            }
            case UUID: {
                return (T)stringType.generateUUID();
            }
            case VALUE: {
                return (T)stringType.generate(this.size, this.valueOrElse(this.lower, false), this.valueOrElse(this.alpha, !this.isAttributesSet()), this.valueOrElse(this.numeric, !this.isAttributesSet()));
            }
        }
        return stringType.getDefaultValue();
    }

    private boolean valueOrElse(Boolean b, boolean val) {
        if (b != null) {
            return b;
        }
        return val;
    }

    public boolean isAttributesSet() {
        return this.alpha != null || this.numeric != null;
    }
}

