/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.strategy.PrimitiveGeneratorStrategy;
import org.biins.objectbuilder.types.primitive.PrimitiveType;
import org.biins.objectbuilder.types.primitive.PrimitiveTypeRegistry;

public class PrimitiveObjectBuilder
extends AbstractBuilder
implements Builder {
    protected PrimitiveGeneratorStrategy primitiveStrategy = PrimitiveGeneratorStrategy.DEFAULT;

    public PrimitiveObjectBuilder setGeneratorStrategy(PrimitiveGeneratorStrategy primitiveStrategy) {
        this.primitiveStrategy = primitiveStrategy;
        return this;
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildPrimitive(type);
    }

    public <T> T buildPrimitive(Class<T> type) {
        PrimitiveType<T> primitiveType = PrimitiveTypeRegistry.get(type);
        switch (this.primitiveStrategy) {
            case MIN: {
                return primitiveType.getMinValue();
            }
            case MAX: {
                return primitiveType.getMaxValue();
            }
            case RANDOM: {
                return primitiveType.getRandomValue();
            }
        }
        return primitiveType.getDefaultValue();
    }
}

