/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.generator.Generator;
import org.biins.objectbuilder.builder.strategy.ArrayGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.CollectionGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.CommonObjectGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.EnumGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.MapGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.PrimitiveGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.StringGeneratorStrategy;
import org.biins.objectbuilder.builder.strategy.WrapperGeneratorStrategy;
import org.biins.objectbuilder.resolver.TypeGeneratorResolver;
import org.biins.objectbuilder.resolver.def.EnumerationGeneratorResolver;
import org.biins.objectbuilder.resolver.def.IterableGeneratorResolver;
import org.biins.objectbuilder.resolver.def.IteratorGeneratorResolver;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.util.ClassUtils;

public class ObjectBuilder
extends AbstractBuilder
implements Builder {
    private final PrimitiveObjectBuilder primitiveObjectBuilder;
    private final WrapperObjectBuilder wrapperObjectBuilder;
    private final ArrayObjectBuilder arrayObjectBuilder;
    private final StringObjectBuilder stringObjectBuilder;
    private final CollectionObjectBuilder collectionObjectBuilder;
    private final CommonObjectBuilder commonObjectBuilder;
    private final EnumObjectBuilder enumObjectBuilder;
    private final MapObjectBuilder mapObjectBuilder;
    private final List<TypeGeneratorResolver<?>> generatorResolvers = new ArrayList();
    private final Set<Class> ignoredTypes = new HashSet<Class>();

    public ObjectBuilder() {
        this.primitiveObjectBuilder = new PrimitiveObjectBuilder(this.createPrimitiveBuilder());
        this.wrapperObjectBuilder = new WrapperObjectBuilder(this.createWrapperBuilder());
        this.arrayObjectBuilder = new ArrayObjectBuilder(this.createArrayBuilder());
        this.stringObjectBuilder = new StringObjectBuilder(this.createStringBuilder());
        this.collectionObjectBuilder = new CollectionObjectBuilder(this.createCollectionBuilder());
        this.commonObjectBuilder = new CommonObjectBuilder(this.createCommonBuilder());
        this.enumObjectBuilder = new EnumObjectBuilder(this.createEnumBuilder());
        this.mapObjectBuilder = new MapObjectBuilder(this.createMapBuilder());
    }

    @Override
    protected void reset() {
        this.primitiveObjectBuilder.reset();
        this.wrapperObjectBuilder.reset();
        this.arrayObjectBuilder.reset();
        this.stringObjectBuilder.reset();
        this.collectionObjectBuilder.reset();
        this.commonObjectBuilder.reset();
        this.enumObjectBuilder.reset();
        this.mapObjectBuilder.reset();
    }

    protected org.biins.objectbuilder.builder.ArrayObjectBuilder createArrayBuilder() {
        return new org.biins.objectbuilder.builder.ArrayObjectBuilder(this);
    }

    protected org.biins.objectbuilder.builder.StringObjectBuilder createStringBuilder() {
        return new org.biins.objectbuilder.builder.StringObjectBuilder();
    }

    protected org.biins.objectbuilder.builder.CollectionObjectBuilder createCollectionBuilder() {
        return new org.biins.objectbuilder.builder.CollectionObjectBuilder(this);
    }

    protected org.biins.objectbuilder.builder.CommonObjectBuilder createCommonBuilder() {
        return new org.biins.objectbuilder.builder.CommonObjectBuilder(this);
    }

    protected org.biins.objectbuilder.builder.EnumObjectBuilder createEnumBuilder() {
        return new org.biins.objectbuilder.builder.EnumObjectBuilder();
    }

    protected org.biins.objectbuilder.builder.MapObjectBuilder createMapBuilder() {
        return new org.biins.objectbuilder.builder.MapObjectBuilder(this);
    }

    protected org.biins.objectbuilder.builder.PrimitiveObjectBuilder createPrimitiveBuilder() {
        return new org.biins.objectbuilder.builder.PrimitiveObjectBuilder();
    }

    protected org.biins.objectbuilder.builder.WrapperObjectBuilder createWrapperBuilder() {
        return new org.biins.objectbuilder.builder.WrapperObjectBuilder();
    }

    public ObjectBuilder addGeneratorResolver(TypeGeneratorResolver resolver) {
        this.generatorResolvers.add(resolver);
        return this;
    }

    public ObjectBuilder addIgnoredType(Class ... types) {
        this.ignoredTypes.addAll(Arrays.asList(types));
        return this;
    }

    public ObjectBuilder setStrategyForAll(String strategy) {
        if (StringUtils.isEmpty((String)strategy)) {
            return this;
        }
        switch (strategy.toUpperCase()) {
            case "DEFAULT": {
                this.primitiveObjectBuilder.setGeneratorStrategy(PrimitiveGeneratorStrategy.DEFAULT);
                this.wrapperObjectBuilder.setGeneratorStrategy(WrapperGeneratorStrategy.DEFAULT);
                this.arrayObjectBuilder.setGeneratorStrategy(ArrayGeneratorStrategy.DEFAULT);
                this.stringObjectBuilder.setGeneratorStrategy(StringGeneratorStrategy.DEFAULT);
                this.collectionObjectBuilder.setGeneratorStrategy(CollectionGeneratorStrategy.DEFAULT);
                this.commonObjectBuilder.setGeneratorStrategy(CommonObjectGeneratorStrategy.DEFAULT);
                this.enumObjectBuilder.setGeneratorStrategy(EnumGeneratorStrategy.DEFAULT);
                this.mapObjectBuilder.setGeneratorStrategy(MapGeneratorStrategy.DEFAULT);
                break;
            }
            case "NULL": {
                this.wrapperObjectBuilder.setGeneratorStrategy(WrapperGeneratorStrategy.NULL);
                this.arrayObjectBuilder.setGeneratorStrategy(ArrayGeneratorStrategy.NULL);
                this.stringObjectBuilder.setGeneratorStrategy(StringGeneratorStrategy.NULL);
                this.collectionObjectBuilder.setGeneratorStrategy(CollectionGeneratorStrategy.NULL);
                this.commonObjectBuilder.setGeneratorStrategy(CommonObjectGeneratorStrategy.NULL);
                this.enumObjectBuilder.setGeneratorStrategy(EnumGeneratorStrategy.NULL);
                this.mapObjectBuilder.setGeneratorStrategy(MapGeneratorStrategy.NULL);
                break;
            }
            case "MIN": {
                this.primitiveObjectBuilder.setGeneratorStrategy(PrimitiveGeneratorStrategy.MIN);
                this.wrapperObjectBuilder.setGeneratorStrategy(WrapperGeneratorStrategy.MIN);
                break;
            }
            case "MAX": {
                this.primitiveObjectBuilder.setGeneratorStrategy(PrimitiveGeneratorStrategy.MAX);
                this.wrapperObjectBuilder.setGeneratorStrategy(WrapperGeneratorStrategy.MAX);
                break;
            }
            case "VALUE": {
                this.arrayObjectBuilder.setGeneratorStrategy(ArrayGeneratorStrategy.VALUE);
                this.stringObjectBuilder.setGeneratorStrategy(StringGeneratorStrategy.VALUE);
                this.collectionObjectBuilder.setGeneratorStrategy(CollectionGeneratorStrategy.VALUE);
                this.commonObjectBuilder.setGeneratorStrategy(CommonObjectGeneratorStrategy.VALUE);
                this.mapObjectBuilder.setGeneratorStrategy(MapGeneratorStrategy.VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public PrimitiveObjectBuilder onPrimitive() {
        return this.primitiveObjectBuilder;
    }

    public PrimitiveObjectBuilder onPrimitive(PrimitiveGeneratorStrategy strategy) {
        return this.onPrimitive().setGeneratorStrategy(strategy);
    }

    public WrapperObjectBuilder onWrapper() {
        return this.wrapperObjectBuilder;
    }

    public WrapperObjectBuilder onWrapper(WrapperGeneratorStrategy strategy) {
        return this.onWrapper().setGeneratorStrategy(strategy);
    }

    public ArrayObjectBuilder onArray() {
        return this.arrayObjectBuilder;
    }

    public ArrayObjectBuilder onArray(ArrayGeneratorStrategy strategy) {
        return this.onArray().setGeneratorStrategy(strategy);
    }

    public StringObjectBuilder onString() {
        return this.stringObjectBuilder;
    }

    public StringObjectBuilder onString(StringGeneratorStrategy strategy) {
        return this.onString().setGeneratorStrategy(strategy);
    }

    public CollectionObjectBuilder onCollection() {
        return this.collectionObjectBuilder;
    }

    public CollectionObjectBuilder onCollection(CollectionGeneratorStrategy strategy) {
        return this.onCollection().setGeneratorStrategy(strategy);
    }

    public EnumObjectBuilder onEnum() {
        return this.enumObjectBuilder;
    }

    public EnumObjectBuilder onEnum(EnumGeneratorStrategy strategy) {
        return this.onEnum().setGeneratorStrategy(strategy);
    }

    public MapObjectBuilder onMap() {
        return this.mapObjectBuilder;
    }

    public MapObjectBuilder onMap(MapGeneratorStrategy strategy) {
        return this.onMap().setGeneratorStrategy(strategy);
    }

    public CommonObjectBuilder onObject() {
        return this.commonObjectBuilder;
    }

    public CommonObjectBuilder onObject(CommonObjectGeneratorStrategy strategy) {
        return this.onObject().setGeneratorStrategy(strategy);
    }

    @Override
    public <T> T build(Class<T> type) {
        TypeGeneratorResolver<T> resolver = this.getResolver(type);
        if (resolver != null) {
            return resolver.resolve(type, this);
        }
        if (this.ignoredTypes.contains(type)) {
            return null;
        }
        if (ClassUtils.isPrimitive(type)) {
            return this.primitiveObjectBuilder.buildPrimitive(type);
        }
        if (ClassUtils.isWrapperClass(type)) {
            return this.wrapperObjectBuilder.buildPrimitiveWrapper(type);
        }
        if (ClassUtils.isArray(type)) {
            return this.arrayObjectBuilder.buildArray(type);
        }
        if (ClassUtils.isString(type)) {
            return this.stringObjectBuilder.buildString();
        }
        if (ClassUtils.isCollection(type)) {
            Class<?> elementType = this.collectionObjectBuilder.getElementType();
            if (elementType != null && this.ignoredTypes.contains(elementType)) {
                return (T)Collections.emptyList();
            }
            return this.collectionObjectBuilder.buildCollection(type);
        }
        if (ClassUtils.isMap(type)) {
            return this.mapObjectBuilder.buildMap(type);
        }
        if (ClassUtils.isEnum(type)) {
            return this.enumObjectBuilder.buildEnum(type);
        }
        if (ClassUtils.isObject(type)) {
            return (T)new Object();
        }
        return this.commonObjectBuilder.buildObject(type);
    }

    private <T> TypeGeneratorResolver<T> getResolver(Class<T> type) {
        for (TypeGeneratorResolver<?> resolver : this.getAllResolvers()) {
            if (!resolver.canResolve(type)) continue;
            return resolver;
        }
        return null;
    }

    private <T> List<TypeGeneratorResolver<?>> getAllResolvers() {
        ArrayList resolvers = new ArrayList();
        resolvers.addAll(this.generatorResolvers);
        resolvers.addAll(Arrays.asList(new EnumerationGeneratorResolver(), new IteratorGeneratorResolver(), new IterableGeneratorResolver()));
        return resolvers;
    }

    public class MapObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.MapObjectBuilder builder;

        public MapObjectBuilder(org.biins.objectbuilder.builder.MapObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public MapObjectBuilder setGeneratorStrategy(MapGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public <T> T buildMap(Class<T> type) {
            return this.builder.buildMap(type);
        }

        public MapObjectBuilder setSize(int size) {
            this.builder.setSize(size);
            return this;
        }

        public MapObjectBuilder ofKey(Types keyType) {
            this.builder.ofKey(keyType);
            return this;
        }

        public MapObjectBuilder ofValue(Types valueType) {
            this.builder.ofValue(valueType);
            return this;
        }
    }

    public class CommonObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.CommonObjectBuilder builder;

        public CommonObjectBuilder(org.biins.objectbuilder.builder.CommonObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        void reset() {
            this.builder.reset();
        }

        public CommonObjectBuilder setGeneratorStrategy(CommonObjectGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        CommonObjectBuilder setBaseName(String fieldFullName) {
            this.builder.setBaseName(fieldFullName);
            return this;
        }

        public CommonObjectBuilder onProperty(String property, Object value) {
            this.builder.onProperty(property, value);
            return this;
        }

        public CommonObjectBuilder onProperty(String property, Object ... values) {
            this.builder.onProperty(property, values);
            return this;
        }

        public <T> CommonObjectBuilder onProperty(String property, Generator<T> generator) {
            this.builder.onProperty(property, generator);
            return this;
        }

        public CommonObjectBuilder ignoreProperty(String ... property) {
            this.builder.ignoreProperty(property);
            return this;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public <T> T buildObject(Class<T> type) {
            return this.builder.buildObject(type);
        }
    }

    public class StringObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.StringObjectBuilder builder;

        public StringObjectBuilder(org.biins.objectbuilder.builder.StringObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public StringObjectBuilder setSize(int size) {
            this.builder.setSize(size);
            return this;
        }

        public StringObjectBuilder setGeneratorStrategy(StringGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public StringObjectBuilder setLower(boolean lower) {
            this.builder.setLower(lower);
            return this;
        }

        public StringObjectBuilder setAlpha(boolean alpha) {
            this.builder.setAlpha(alpha);
            return this;
        }

        public StringObjectBuilder setNumeric(boolean numeric) {
            this.builder.setNumeric(numeric);
            return this;
        }

        public StringObjectBuilder setAttributes(boolean lower, boolean alpha, boolean numeric) {
            this.builder.setAttributes(lower, alpha, numeric);
            return this;
        }

        public <T> T buildString() {
            return this.builder.buildString();
        }
    }

    public class CollectionObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.CollectionObjectBuilder builder;

        public CollectionObjectBuilder(org.biins.objectbuilder.builder.CollectionObjectBuilder builder) {
            this.builder = builder;
        }

        public CollectionObjectBuilder of(Types types) {
            this.builder.of(types);
            return this;
        }

        public CollectionObjectBuilder setSize(int ... size) {
            this.builder.setSize(size);
            return this;
        }

        public CollectionObjectBuilder setGeneratorStrategy(CollectionGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        <T> T buildCollection(Class<T> type) {
            return this.builder.buildCollection(type);
        }

        <T> T buildCollection(Class<T> type, Types elementType) {
            return this.builder.buildCollection(type, elementType);
        }

        <T> T buildCollection(Class<T> type, Types elementType, int ... size) {
            return this.builder.buildCollection(type, elementType, size);
        }

        public Class<?> getElementType() {
            return this.builder.getElementType();
        }
    }

    public class ArrayObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.ArrayObjectBuilder builder;

        public ArrayObjectBuilder(org.biins.objectbuilder.builder.ArrayObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public ArrayObjectBuilder setGeneratorStrategy(ArrayGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public ArrayObjectBuilder setSize(int ... size) {
            this.builder.setSize(size);
            return this;
        }

        <T> T buildArray(Class<T> type) {
            return this.builder.buildArray(type);
        }

        <T> T buildArray(Class<T> type, int ... size) {
            return this.builder.buildArray(type, size);
        }
    }

    public class EnumObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.EnumObjectBuilder builder;

        public EnumObjectBuilder(org.biins.objectbuilder.builder.EnumObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public EnumObjectBuilder setGeneratorStrategy(EnumGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public <T> T buildEnum(Class<T> type) {
            return this.builder.buildEnum(type);
        }
    }

    public class WrapperObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.WrapperObjectBuilder builder;

        public WrapperObjectBuilder(org.biins.objectbuilder.builder.WrapperObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public WrapperObjectBuilder setGeneratorStrategy(WrapperGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public <T> T buildPrimitiveWrapper(Class<T> type) {
            return this.builder.buildPrimitiveWrapper(type);
        }
    }

    public class PrimitiveObjectBuilder
    extends AbstractTransitionsBuilder {
        private final org.biins.objectbuilder.builder.PrimitiveObjectBuilder builder;

        public PrimitiveObjectBuilder(org.biins.objectbuilder.builder.PrimitiveObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T build(Class<T> type) {
            return ObjectBuilder.this.build(type);
        }

        public PrimitiveObjectBuilder setGeneratorStrategy(PrimitiveGeneratorStrategy strategy) {
            this.builder.setGeneratorStrategy(strategy);
            return this;
        }

        public <T> T buildPrimitive(Class<T> type) {
            return this.builder.buildPrimitive(type);
        }
    }

    public abstract class AbstractTransitionsBuilder
    extends AbstractBuilder {
        public ObjectBuilder and() {
            return ObjectBuilder.this;
        }

        public PrimitiveObjectBuilder onPrimitive() {
            return ObjectBuilder.this.primitiveObjectBuilder;
        }

        public PrimitiveObjectBuilder onPrimitive(PrimitiveGeneratorStrategy strategy) {
            return this.onPrimitive().setGeneratorStrategy(strategy);
        }

        public WrapperObjectBuilder onWrapper() {
            return ObjectBuilder.this.wrapperObjectBuilder;
        }

        public WrapperObjectBuilder onWrapper(WrapperGeneratorStrategy strategy) {
            return this.onWrapper().setGeneratorStrategy(strategy);
        }

        public ArrayObjectBuilder onArray() {
            return ObjectBuilder.this.arrayObjectBuilder;
        }

        public ArrayObjectBuilder onArray(ArrayGeneratorStrategy strategy) {
            return this.onArray().setGeneratorStrategy(strategy);
        }

        public StringObjectBuilder onString() {
            return ObjectBuilder.this.stringObjectBuilder;
        }

        public StringObjectBuilder onString(StringGeneratorStrategy strategy) {
            return this.onString().setGeneratorStrategy(strategy);
        }

        public CollectionObjectBuilder onCollection() {
            return ObjectBuilder.this.collectionObjectBuilder;
        }

        public CollectionObjectBuilder onCollection(CollectionGeneratorStrategy strategy) {
            return this.onCollection().setGeneratorStrategy(strategy);
        }

        public EnumObjectBuilder onEnum() {
            return ObjectBuilder.this.enumObjectBuilder;
        }

        public EnumObjectBuilder onEnum(EnumGeneratorStrategy strategy) {
            return this.onEnum().setGeneratorStrategy(strategy);
        }

        public MapObjectBuilder onMap() {
            return ObjectBuilder.this.mapObjectBuilder;
        }

        public MapObjectBuilder onMap(MapGeneratorStrategy strategy) {
            return this.onMap().setGeneratorStrategy(strategy);
        }

        public CommonObjectBuilder onObject() {
            return ObjectBuilder.this.commonObjectBuilder;
        }

        public CommonObjectBuilder onObject(CommonObjectGeneratorStrategy strategy) {
            return this.onObject().setGeneratorStrategy(strategy);
        }
    }
}

