/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.ObjectBuilder;
import org.biins.objectbuilder.builder.strategy.MapGeneratorStrategy;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.types.map.MapType;
import org.biins.objectbuilder.types.map.MapTypeRegistry;
import org.biins.objectbuilder.util.ClassUtils;

public class MapObjectBuilder
extends AbstractBuilder
implements Builder {
    private final ObjectBuilder objectBuilder;
    private MapGeneratorStrategy mapGeneratorStrategy = MapGeneratorStrategy.DEFAULT;
    private int size = 0;
    private Types keyType;
    private Types valueType;

    public MapObjectBuilder(ObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
    }

    public MapObjectBuilder setSize(int size) {
        this.size = size;
        this.validateSize();
        return this;
    }

    private void validateSize() {
        if (this.size < 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
    }

    public MapObjectBuilder setGeneratorStrategy(MapGeneratorStrategy mapGeneratorStrategy) {
        this.mapGeneratorStrategy = mapGeneratorStrategy;
        return this;
    }

    public MapObjectBuilder ofKey(Types keyType) {
        this.keyType = keyType;
        return this;
    }

    public MapObjectBuilder ofValue(Types valueType) {
        this.valueType = valueType;
        return this;
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildMap(type);
    }

    public <T> T buildMap(Class<T> type) {
        return this.buildMap(type, this.keyType, this.valueType, this.size);
    }

    private <T> T buildMap(Class<T> type, Types keyType, Types valueType, int size) {
        Validate.isTrue((boolean)Map.class.isAssignableFrom(type), (String)"Map is required");
        MapType mapType = MapTypeRegistry.get(type);
        return this.buildMap(mapType, keyType, valueType, size);
    }

    private <T> T buildMap(MapType mapType, Types keyType, Types valueType, int size) {
        switch (this.mapGeneratorStrategy) {
            case NULL: {
                return null;
            }
            case VALUE: {
                return (T)this.buildMapInternal(mapType.getType(), keyType, valueType, size);
            }
            case SINGLETON: {
                return (T)this.buildMapInternal(mapType.getType(), keyType, valueType, 1);
            }
        }
        return mapType.getDefaultValue();
    }

    private Map buildMapInternal(Class<?> mapType, Types keyType, Types valueType, int size) {
        return this.createMap(mapType, keyType, valueType, size);
    }

    private Map createMap(Class<?> mapType, Types keyType, Types valueType, int size) {
        int mapSize = this.countSize(size);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (keyType != null) {
            for (int i = 0; i < mapSize; ++i) {
                Object key = this.createObject(keyType);
                Object value = this.createObject(valueType);
                map.put(key, value);
            }
        }
        return this.createMapOfType(mapType, map);
    }

    private Object createObject(Types type) {
        if (type == null) {
            return null;
        }
        if (ClassUtils.isCollection(type.getType())) {
            return this.objectBuilder.onCollection().buildCollection(type.getType(), type.next());
        }
        return this.objectBuilder.build(type.getType());
    }

    private int countSize(int size) {
        return this.mapGeneratorStrategy.equals((Object)MapGeneratorStrategy.SINGLETON) ? 1 : size;
    }

    private Map createMapOfType(Class mapType, Map values) {
        Class<? extends Map> mapCls = MapTypeRegistry.getDefaultImpl(mapType);
        return MapTypeRegistry.getNewMap(mapCls, values);
    }
}

