/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.strategy.EnumGeneratorStrategy;
import org.biins.objectbuilder.types.enums.EnumType;
import org.biins.objectbuilder.types.enums.EnumTypeRegistry;

public class EnumObjectBuilder
extends AbstractBuilder
implements Builder {
    protected EnumGeneratorStrategy enumStrategy = EnumGeneratorStrategy.DEFAULT;

    public EnumObjectBuilder setGeneratorStrategy(EnumGeneratorStrategy enumStrategy) {
        this.enumStrategy = enumStrategy;
        return this;
    }

    public String build() {
        return this.build(String.class);
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildEnum(type);
    }

    public <T> T buildEnum(Class<T> type) {
        Validate.isTrue((boolean)Enum.class.isAssignableFrom(type));
        EnumType enumType = EnumTypeRegistry.get(type);
        switch (this.enumStrategy) {
            case FIRST: {
                return (T)enumType.generate(0);
            }
            case LAST: {
                return (T)enumType.generate(enumType.size() - 1);
            }
            case RANDOM: {
                return (T)enumType.generate();
            }
        }
        return enumType.getDefaultValue();
    }
}

