/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.ObjectBuilder;
import org.biins.objectbuilder.builder.generator.CyclicValuesGenerator;
import org.biins.objectbuilder.builder.generator.Generator;
import org.biins.objectbuilder.builder.generator.ValuesGenerator;
import org.biins.objectbuilder.builder.strategy.CommonObjectGeneratorStrategy;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.util.ClassUtils;

public class CommonObjectBuilder
extends AbstractBuilder
implements Builder {
    private final Logger logger = Logger.getLogger(CommonObjectBuilder.class.getName());
    private final ObjectBuilder objectBuilder;
    private final Stack<Class<?>> typeStack;
    private final Set<String> ignoredProperties;
    private final Map<String, Generator> propertyValues;
    private CommonObjectGeneratorStrategy objectStrategy = CommonObjectGeneratorStrategy.DEFAULT;
    private String baseName;

    public CommonObjectBuilder(ObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
        this.typeStack = new Stack();
        this.ignoredProperties = new HashSet<String>();
        this.propertyValues = new HashMap<String, Generator>();
    }

    public CommonObjectBuilder setGeneratorStrategy(CommonObjectGeneratorStrategy objectStrategy) {
        this.objectStrategy = objectStrategy;
        return this;
    }

    public CommonObjectBuilder setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public void onProperty(String property, Object value) {
        Validate.notNull((Object)property);
        this.propertyValues.put(property, new CyclicValuesGenerator<Object>(value));
    }

    public void onProperty(String property, Object ... values) {
        Validate.notNull((Object)property);
        Validate.notNull((Object)values);
        this.propertyValues.put(property, new ValuesGenerator<Object>(values));
    }

    public <T> void onProperty(String property, Generator<T> generator) {
        Validate.notNull((Object)property);
        Validate.notNull(generator);
        this.propertyValues.put(property, generator);
    }

    public void ignoreProperty(String ... property) {
        this.ignoredProperties.addAll(Arrays.asList(property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T build(Class<T> type) {
        CommonObjectGeneratorStrategy strategy = !this.typeStack.empty() ? this.objectStrategy : CommonObjectGeneratorStrategy.DEFAULT;
        switch (strategy) {
            case NULL: {
                return null;
            }
        }
        if (this.typeStack.contains(type)) {
            this.logger.warning("Detect cyclic reference of " + type + ". Return null");
            return null;
        }
        this.typeStack.push(type);
        try {
            T t = this.buildObjectInternal(type);
            return t;
        }
        finally {
            this.typeStack.pop();
        }
    }

    public <T> T buildObject(Class<T> type) {
        return this.build(type);
    }

    public <T> T buildObjectInternal(Class<T> type) {
        Object o = this.newInstance(type);
        this.fillObject(o, type, this.baseName);
        return (T)o;
    }

    private <T> void fillObject(Object o, Class<T> type, String baseName) {
        List<Field> fields = ClassUtils.getFields(type);
        for (Field field : fields) {
            Object fieldValue;
            String fieldFullName;
            String string = fieldFullName = baseName != null ? baseName + "." + field.getName() : field.getName();
            if (this.ignoredProperties.contains(fieldFullName)) continue;
            Class<?> fieldType = field.getType();
            if (this.propertyValues.containsKey(fieldFullName)) {
                fieldValue = this.getValue(this.propertyValues.get(fieldFullName));
            } else if (ClassUtils.isCollection(fieldType)) {
                Type genericType = field.getGenericType();
                Types types = genericType instanceof ParameterizedType ? Types.typeOf(((ParameterizedType)genericType).getActualTypeArguments()[0]) : null;
                fieldValue = this.objectBuilder.onCollection().of(types).build(fieldType);
            } else if (ClassUtils.isMap(fieldType)) {
                Type[] types = this.getGenericType(field);
                fieldValue = this.objectBuilder.onMap().ofKey(Types.typeOf(types[0])).ofValue(Types.typeOf(types[1])).build(fieldType);
            } else {
                fieldValue = this.objectBuilder.onObject().setBaseName(fieldFullName).build(fieldType);
                this.objectBuilder.onObject().setBaseName(null);
            }
            ClassUtils.setProperty(o, field, fieldValue);
        }
    }

    private Object getValue(Generator generator) {
        if (!generator.hasNext() && generator.isCyclic()) {
            generator.reset();
        }
        return generator.hasNext() ? generator.next() : null;
    }

    private Type[] getGenericType(Field field) {
        Type[] types = new Type[2];
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (types.length > 0) {
                types[0] = actualTypeArguments[0];
            }
            if (types.length > 1) {
                types[1] = actualTypeArguments[1];
            }
        }
        return types;
    }

    private <T> Object newInstance(Class<T> type) {
        Constructor<?>[] constructors;
        T object = ClassUtils.newInstance(type);
        if (object != null) {
            return object;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            object = ClassUtils.newInstance(type, constructor, this.newInstances(constructor.getParameterTypes()));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private Object[] newInstances(Class<?> ... types) {
        Object[] objects = new Object[types.length];
        for (int i = 0; i < objects.length; ++i) {
            Class<?> type = types[i];
            Object build = this.objectBuilder.build(type);
            objects[i] = build;
        }
        return objects;
    }
}

