/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.biins.objectbuilder.builder.AbstractCompositeBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.ObjectBuilder;
import org.biins.objectbuilder.builder.strategy.CollectionGeneratorStrategy;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.types.collection.CollectionType;
import org.biins.objectbuilder.types.collection.CollectionTypeRegistry;
import org.biins.objectbuilder.util.ClassUtils;

public class CollectionObjectBuilder
extends AbstractCompositeBuilder
implements Builder {
    private CollectionGeneratorStrategy collectionGeneratorStrategy = CollectionGeneratorStrategy.DEFAULT;
    private int[] size = new int[]{0};
    private Types elementType;

    public CollectionObjectBuilder(ObjectBuilder objectBuilder) {
        super(objectBuilder);
    }

    public CollectionObjectBuilder setSize(int ... size) {
        this.size = size;
        this.validateSize();
        return this;
    }

    private void validateSize() {
        for (int s : this.size) {
            if (s >= 0) continue;
            throw new IllegalArgumentException("Size must be positive");
        }
    }

    public CollectionObjectBuilder setGeneratorStrategy(CollectionGeneratorStrategy collectionStrategy) {
        this.collectionGeneratorStrategy = collectionStrategy;
        return this;
    }

    public CollectionObjectBuilder of(Types elementType) {
        this.elementType = elementType;
        return this;
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildCollection(type);
    }

    public <T> T buildCollection(Class<T> type) {
        CollectionType<T> collectionType = CollectionTypeRegistry.get(type);
        return this.buildCollection(collectionType, this.elementType, this.size);
    }

    public <T> T buildCollection(Class<T> type, Types elementType) {
        CollectionType<T> collectionType = CollectionTypeRegistry.get(type);
        return this.buildCollection(collectionType, elementType, this.size);
    }

    public <T> T buildCollection(Class<T> type, Types elementType, int ... size) {
        CollectionType<T> collectionType = CollectionTypeRegistry.get(type);
        return this.buildCollection(collectionType, elementType, size);
    }

    private <T> T buildCollection(CollectionType<T> collectionType, Types elementType, int ... size) {
        switch (this.collectionGeneratorStrategy) {
            case NULL: {
                return null;
            }
            case VALUE: {
                return this.buildCollectionInternal(collectionType.getType(), elementType, size);
            }
            case SINGLETON: {
                this.size = new int[]{1};
                return this.buildCollectionInternal(collectionType.getType(), elementType);
            }
        }
        return collectionType.getDefaultValue();
    }

    private <T> T buildCollectionInternal(Class<T> collectionType, Types elementType) {
        return this.buildCollectionInternal(collectionType, elementType, this.size);
    }

    private <T> T buildCollectionInternal(Class<T> collectionType, Types elementType, int ... size) {
        Collection collection = this.createCollection(collectionType, elementType, size);
        return (T)collection;
    }

    private Collection createCollection(Class<?> collectionType, Types elementType, int ... size) {
        int collectionSize = this.countSize(size, 0);
        ArrayList<Object> list = new ArrayList<Object>(collectionSize);
        if (elementType != null) {
            for (int i = 0; i < collectionSize; ++i) {
                Object value = ClassUtils.isSameCompositeType(collectionType, elementType.getType()) ? this.createCompositeObject(elementType, this.decreaseDimension(size)) : this.createCompositeObject(elementType);
                list.add(i, value);
            }
        }
        return this.createCollectionOfType(collectionType, list);
    }

    private int countSize(int[] sizes, int at) {
        return sizes.length > at ? sizes[at] : (this.collectionGeneratorStrategy.equals((Object)CollectionGeneratorStrategy.SINGLETON) ? 1 : 0);
    }

    private Collection createCollectionOfType(Class<?> collectionType, List values) {
        Class<? extends Collection> collectionCls = CollectionTypeRegistry.getDefaultImpl(collectionType);
        return CollectionTypeRegistry.getNewCollection(collectionCls, values);
    }

    public Class<?> getElementType() {
        return this.elementType != null ? this.elementType.getType() : null;
    }
}

