/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.lang.reflect.Array;
import org.biins.objectbuilder.builder.AbstractCompositeBuilder;
import org.biins.objectbuilder.builder.Builder;
import org.biins.objectbuilder.builder.ObjectBuilder;
import org.biins.objectbuilder.builder.strategy.ArrayGeneratorStrategy;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.types.array.ArrayType;
import org.biins.objectbuilder.types.array.ArrayTypeRegistry;
import org.biins.objectbuilder.util.ClassUtils;

public class ArrayObjectBuilder
extends AbstractCompositeBuilder
implements Builder {
    private ArrayGeneratorStrategy arrayStrategy = ArrayGeneratorStrategy.DEFAULT;
    private int[] size = new int[]{0};

    public ArrayObjectBuilder(ObjectBuilder objectBuilder) {
        super(objectBuilder);
    }

    public ArrayObjectBuilder setSize(int ... size) {
        this.size = size;
        this.validateSize();
        return this;
    }

    public ArrayObjectBuilder setGeneratorStrategy(ArrayGeneratorStrategy arrayStrategy) {
        this.arrayStrategy = arrayStrategy;
        return this;
    }

    private void validateSize() {
        for (int s : this.size) {
            if (s >= 0) continue;
            throw new IllegalArgumentException("Size must be positive");
        }
    }

    @Override
    public <T> T build(Class<T> type) {
        return this.buildArray(type);
    }

    public <T> T buildArray(Class<T> type) {
        return this.buildArray(type, this.size);
    }

    public <T> T buildArray(Class<T> type, int ... size) {
        ArrayType<T> arrayType = ArrayTypeRegistry.get(type);
        return this.buildArray(arrayType, size);
    }

    public <T> T buildArray(ArrayType<T> arrayType, int ... size) {
        switch (this.arrayStrategy) {
            case NULL: {
                return null;
            }
            case VALUE: {
                return this.buildArrayInternal(arrayType, size);
            }
        }
        return arrayType.getDefaultValue();
    }

    private <T> T buildArrayInternal(ArrayType<T> arrayType, int ... size) {
        int arraySize = this.countSize(size, 0);
        Class<?> componentType = arrayType.getComponentType();
        Object array = this.createArray(componentType, arraySize);
        array = this.fillArray(array, componentType, size);
        return (T)array;
    }

    private Object fillArray(Object array, Class<?> componentType, int ... size) {
        int maxIndex = this.countSize(size, 0);
        for (int i = 0; i < maxIndex; ++i) {
            Object value = ClassUtils.isSameCompositeType(array.getClass(), componentType) ? this.createCompositeObject(Types.typeOf(componentType), this.decreaseDimension(size)) : this.createCompositeObject(Types.typeOf(componentType));
            Array.set(array, i, value);
        }
        return array;
    }

    private int countSize(int[] sizes, int at) {
        return sizes.length > at ? sizes[at] : 0;
    }

    private Object createArray(Class<?> type, int size) {
        return Array.newInstance(type, size);
    }
}

