/*
 * Decompiled with CFR 0.152.
 */
package org.biins.objectbuilder.builder;

import java.util.Arrays;
import org.biins.objectbuilder.builder.AbstractBuilder;
import org.biins.objectbuilder.builder.ObjectBuilder;
import org.biins.objectbuilder.types.Types;
import org.biins.objectbuilder.util.ClassUtils;

public abstract class AbstractCompositeBuilder
extends AbstractBuilder {
    private ObjectBuilder objectBuilder;

    public AbstractCompositeBuilder(ObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
    }

    protected Object createCompositeObject(Types types) {
        Class<?> type = types.getType();
        if (ClassUtils.isArray(type)) {
            return this.objectBuilder.onArray().buildArray(type);
        }
        if (ClassUtils.isCollection(type)) {
            return this.objectBuilder.onCollection().buildCollection(type);
        }
        return this.objectBuilder.build(type);
    }

    protected Object createCompositeObject(Types types, int ... size) {
        Class<?> type = types.getType();
        if (ClassUtils.isArray(type)) {
            return this.objectBuilder.onArray().buildArray(type, size);
        }
        if (ClassUtils.isCollection(type)) {
            return this.objectBuilder.onCollection().buildCollection(type, types.next(), size);
        }
        return this.objectBuilder.build(type);
    }

    protected int[] decreaseDimension(int[] size) {
        int[] nArray;
        if (size.length > 1) {
            nArray = Arrays.copyOfRange(size, 1, size.length);
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }
}

