/*
 * Decompiled with CFR 0.152.
 */
package org.biacode.escommons.api.rest.setup;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.biacode.escommons.api.model.common.EsCommonsRequest;
import org.biacode.escommons.api.model.common.EsCommonsResponse;
import org.biacode.escommons.api.model.common.EsCommonsResultResponse;
import org.biacode.escommons.api.model.setup.request.ChangeIndexAliasRequest;
import org.biacode.escommons.api.model.setup.request.PrepareIndexRequest;
import org.biacode.escommons.api.model.setup.request.RemoveIndexByNameRequest;
import org.biacode.escommons.api.model.setup.response.PrepareIndexResponse;
import org.biacode.escommons.core.component.IndexingComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Path(value="escommons")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EsCommonsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsCommonsResource.class);
    @Autowired
    private IndexingComponent indexingComponent;

    public EsCommonsResource() {
        LOGGER.debug("Initializing");
    }

    @POST
    @Path(value="prepare-index")
    public Response prepareIndex(PrepareIndexRequest request) {
        this.assertPrepareIndexRequest(request);
        String newIndexName = this.indexingComponent.createIndexAndSetupMappings(request.getAlias(), request.getTypes(), request.getSettings());
        return Response.ok((Object)new EsCommonsResultResponse((EsCommonsResponse)new PrepareIndexResponse(newIndexName))).build();
    }

    @POST
    @Path(value="change-alias")
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    public Response changeAlias(ChangeIndexAliasRequest request) {
        this.assertChangeIndexAliasRequest(request);
        this.indexingComponent.addAlias(request.getAlias(), request.getIndexName());
        return Response.ok((Object)new EsCommonsResultResponse()).build();
    }

    @POST
    @Path(value="remove-index-by-name")
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    public Response removeIndexByName(RemoveIndexByNameRequest request) {
        this.assertRemoveIndexByNameRequest(request);
        this.indexingComponent.removeIndexByName(request.getIndexName());
        return Response.ok((Object)new EsCommonsResultResponse()).build();
    }

    @GET
    @Path(value="heartbeat")
    public Response heartbeat() {
        return Response.ok((Object)"OK").build();
    }

    private void assertPrepareIndexRequest(PrepareIndexRequest request) {
        this.assertRequest((EsCommonsRequest)request);
        this.assertAliasNotNull(request.getAlias());
        Assert.notNull((Object)request.getTypes(), (String)"The list of document types should not be null");
    }

    private void assertChangeIndexAliasRequest(ChangeIndexAliasRequest request) {
        this.assertRequest((EsCommonsRequest)request);
        this.assertAliasNotNull(request.getAlias());
        this.assertIndexNameNotNull(request.getIndexName());
    }

    private void assertRemoveIndexByNameRequest(RemoveIndexByNameRequest request) {
        this.assertRequest((EsCommonsRequest)request);
        this.assertIndexNameNotNull(request.getIndexName());
    }

    private void assertRequest(EsCommonsRequest request) {
        Assert.notNull((Object)request, (String)"The request should not be null");
    }

    private void assertIndexNameNotNull(String indexName) {
        Assert.notNull((Object)indexName, (String)"The index name should not be null");
    }

    private void assertAliasNotNull(String alias) {
        Assert.notNull((Object)alias, (String)"The alias should not be null");
    }
}

