/*
 * Decompiled with CFR 0.152.
 */
package org.biacode.escommons.core.test;

import java.util.UUID;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.biacode.escommons.core.test.configuration.EsCommonsTestAnnotationDrivenConfiguration;
import org.biacode.escommons.toolkit.component.EsCommonsClientWrapper;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={EsCommonsTestAnnotationDrivenConfiguration.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0006H&J\b\u0010\u0015\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/biacode/escommons/core/test/AbstractEsCommonsIntegrationTest;", "", "()V", "esCommonsClientWrapper", "Lorg/biacode/escommons/toolkit/component/EsCommonsClientWrapper;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "setIndexName", "(Ljava/lang/String;)V", "settings", "Lorg/elasticsearch/common/settings/Settings;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "setSettings", "(Lorg/elasticsearch/common/settings/Settings;)V", "beforeEsCommonsTests", "", "cleanUpIndices", "mappings", "refreshIndex", "escommons-test"})
public abstract class AbstractEsCommonsIntegrationTest {
    @NotNull
    private String indexName;
    @NotNull
    private Settings settings;
    @Autowired
    private EsCommonsClientWrapper esCommonsClientWrapper;

    @NotNull
    protected final String getIndexName() {
        return this.indexName;
    }

    protected final void setIndexName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.indexName = string;
    }

    @NotNull
    protected final Settings getSettings() {
        return this.settings;
    }

    protected final void setSettings(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    @Before
    public final void beforeEsCommonsTests() {
        this.cleanUpIndices();
        EsCommonsClientWrapper esCommonsClientWrapper = this.esCommonsClientWrapper;
        if (esCommonsClientWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"esCommonsClientWrapper");
        }
        boolean bl = esCommonsClientWrapper.createIndex(this.indexName, this.mappings(), this.settings());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.refreshIndex();
    }

    @NotNull
    public abstract String mappings();

    protected void refreshIndex(@NotNull String indexName) {
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        EsCommonsClientWrapper esCommonsClientWrapper = this.esCommonsClientWrapper;
        if (esCommonsClientWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"esCommonsClientWrapper");
        }
        esCommonsClientWrapper.refreshIndex(indexName);
    }

    protected void refreshIndex() {
        EsCommonsClientWrapper esCommonsClientWrapper = this.esCommonsClientWrapper;
        if (esCommonsClientWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"esCommonsClientWrapper");
        }
        esCommonsClientWrapper.refreshIndex(this.indexName);
    }

    @NotNull
    protected Settings settings() {
        return this.settings;
    }

    protected void settings(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.settings = settings;
    }

    protected void cleanUpIndices() {
        EsCommonsClientWrapper esCommonsClientWrapper = this.esCommonsClientWrapper;
        if (esCommonsClientWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"esCommonsClientWrapper");
        }
        esCommonsClientWrapper.deleteIndices(new String[]{"*"});
    }

    public AbstractEsCommonsIntegrationTest() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.indexName = string;
        Settings settings = Settings.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)settings, (String)"Settings.EMPTY");
        this.settings = settings;
    }
}

