/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import net.sf.log4jdbc.Properties;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.SpyLogFactory;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.ConnectionSpy;
import net.sf.log4jdbc.sql.rdbmsspecifics.MySqlRdbmsSpecifics;
import net.sf.log4jdbc.sql.rdbmsspecifics.OracleRdbmsSpecifics;
import net.sf.log4jdbc.sql.rdbmsspecifics.RdbmsSpecifics;
import net.sf.log4jdbc.sql.rdbmsspecifics.SqlServerRdbmsSpecifics;

public class DriverSpy
implements Driver {
    private Driver lastUnderlyingDriverRequested;
    private static final Map<String, RdbmsSpecifics> rdbmsSpecifics;
    static final RdbmsSpecifics defaultRdbmsSpecifics;
    static final SpyLogDelegator log;
    private static final String log4jdbcUrlPrefix = "jdbc:log4";

    static RdbmsSpecifics getRdbmsSpecifics(Connection conn) {
        String driverName = "";
        try {
            DatabaseMetaData dbm = conn.getMetaData();
            driverName = dbm.getDriverName();
        }
        catch (SQLException s) {
            // empty catch block
        }
        log.debug("driver name is " + driverName);
        RdbmsSpecifics r = rdbmsSpecifics.get(driverName);
        if (r == null) {
            return defaultRdbmsSpecifics;
        }
        return r;
    }

    @Override
    public int getMajorVersion() {
        if (this.lastUnderlyingDriverRequested == null) {
            return 1;
        }
        return this.lastUnderlyingDriverRequested.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        if (this.lastUnderlyingDriverRequested == null) {
            return 0;
        }
        return this.lastUnderlyingDriverRequested.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.lastUnderlyingDriverRequested != null && this.lastUnderlyingDriverRequested.jdbcCompliant();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d != null) {
            this.lastUnderlyingDriverRequested = d;
            return true;
        }
        return false;
    }

    private Driver getUnderlyingDriver(String url) throws SQLException {
        if (url.startsWith(log4jdbcUrlPrefix)) {
            url = this.getRealUrl(url);
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver d = e.nextElement();
                if (!d.acceptsURL(url)) continue;
                return d;
            }
        }
        return null;
    }

    private String getRealUrl(String url) {
        return url.substring(log4jdbcUrlPrefix.length());
    }

    @Override
    public Connection connect(String url, java.util.Properties info) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d == null) {
            return null;
        }
        url = this.getRealUrl(url);
        this.lastUnderlyingDriverRequested = d;
        long tstart = System.currentTimeMillis();
        Connection c = d.connect(url, info);
        if (c == null) {
            throw new SQLException("invalid or unknown driver url: " + url);
        }
        if (log.isJdbcLoggingEnabled()) {
            ConnectionSpy cspy = new ConnectionSpy(c, System.currentTimeMillis() - tstart);
            RdbmsSpecifics r = null;
            String dclass = d.getClass().getName();
            if (dclass != null && dclass.length() > 0) {
                r = rdbmsSpecifics.get(dclass);
            }
            if (r == null) {
                r = defaultRdbmsSpecifics;
            }
            cspy.setRdbmsSpecifics(r);
            return cspy;
        }
        return c;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, java.util.Properties info) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d == null) {
            return new DriverPropertyInfo[0];
        }
        this.lastUnderlyingDriverRequested = d;
        return d.getPropertyInfo(url, info);
    }

    protected void reportException(String methodCall, SQLException exception) {
        log.exceptionOccured((Spy)((Object)this), methodCall, exception, null, -1L);
    }

    static {
        defaultRdbmsSpecifics = new RdbmsSpecifics();
        log = SpyLogFactory.getSpyLogDelegator();
        log.debug("DriverSpy intialization...");
        TreeSet<String> subDrivers = new TreeSet<String>();
        if (Properties.isAutoLoadPopularDrivers()) {
            subDrivers.add("oracle.jdbc.driver.OracleDriver");
            subDrivers.add("oracle.jdbc.OracleDriver");
            subDrivers.add("com.sybase.jdbc2.jdbc.SybDriver");
            subDrivers.add("net.sourceforge.jtds.jdbc.Driver");
            subDrivers.add("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            subDrivers.add("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            subDrivers.add("weblogic.jdbc.sqlserver.SQLServerDriver");
            subDrivers.add("com.informix.jdbc.IfxDriver");
            subDrivers.add("org.apache.derby.jdbc.ClientDriver");
            subDrivers.add("org.apache.derby.jdbc.EmbeddedDriver");
            subDrivers.add("com.mysql.jdbc.Driver");
            subDrivers.add("org.postgresql.Driver");
            subDrivers.add("org.hsqldb.jdbcDriver");
            subDrivers.add("org.h2.Driver");
        }
        subDrivers.addAll(Properties.getAdditionalDrivers());
        try {
            DriverManager.registerDriver(new DriverSpy());
        }
        catch (SQLException s) {
            throw (RuntimeException)new RuntimeException("could not register log4jdbc driver!").initCause(s);
        }
        Iterator i = subDrivers.iterator();
        while (i.hasNext()) {
            String driverClass = (String)i.next();
            try {
                Class.forName(driverClass);
                log.debug("  FOUND DRIVER " + driverClass);
            }
            catch (Throwable c) {
                i.remove();
            }
        }
        if (subDrivers.size() == 0) {
            log.debug("WARNING!  log4jdbc couldn't find any underlying jdbc drivers.");
        }
        SqlServerRdbmsSpecifics sqlServer = new SqlServerRdbmsSpecifics();
        OracleRdbmsSpecifics oracle = new OracleRdbmsSpecifics();
        MySqlRdbmsSpecifics mySql = new MySqlRdbmsSpecifics();
        rdbmsSpecifics = new HashMap<String, RdbmsSpecifics>();
        rdbmsSpecifics.put("oracle.jdbc.driver.OracleDriver", oracle);
        rdbmsSpecifics.put("oracle.jdbc.OracleDriver", oracle);
        rdbmsSpecifics.put("net.sourceforge.jtds.jdbc.Driver", sqlServer);
        rdbmsSpecifics.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", sqlServer);
        rdbmsSpecifics.put("weblogic.jdbc.sqlserver.SQLServerDriver", sqlServer);
        rdbmsSpecifics.put("com.mysql.jdbc.Driver", mySql);
        log.debug("DriverSpy intialization done.");
    }
}

