/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.sql.jdbcapi.ConnectionSpy;
import net.sf.log4jdbc.sql.jdbcapi.ResultSetSpy;
import net.sf.log4jdbc.sql.jdbcapi.StatementSpy;
import net.sf.log4jdbc.sql.rdbmsspecifics.RdbmsSpecifics;

public class PreparedStatementSpy
extends StatementSpy
implements PreparedStatement {
    protected final List<String> argTrace = new ArrayList<String>();
    private static final boolean showTypeHelp = false;
    protected PreparedStatement realPreparedStatement;
    protected RdbmsSpecifics rdbmsSpecifics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void argTraceSet(int i, String typeHelper, Object arg) {
        String tracedArg;
        try {
            tracedArg = this.rdbmsSpecifics.formatParameterObject(arg);
        }
        catch (Throwable t) {
            this.log.debug("rdbmsSpecifics threw an exception while trying to format a parameter object [" + arg + "] this is very bad!!! (" + t.getMessage() + ")");
            tracedArg = arg == null ? "null" : arg.toString();
        }
        --i;
        List<String> list = this.argTrace;
        synchronized (list) {
            while (i >= this.argTrace.size()) {
                this.argTrace.add(this.argTrace.size(), null);
            }
            this.argTrace.set(i, tracedArg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dumpedSql() {
        StringBuffer dumpSql = new StringBuffer();
        int lastPos = 0;
        int Qpos = this.sql.indexOf(63, lastPos);
        int argIdx = 0;
        while (Qpos != -1) {
            String arg;
            List<String> list = this.argTrace;
            synchronized (list) {
                try {
                    arg = this.argTrace.get(argIdx);
                }
                catch (IndexOutOfBoundsException e) {
                    arg = "?";
                }
            }
            if (arg == null) {
                arg = "?";
            }
            ++argIdx;
            dumpSql.append(this.sql.substring(lastPos, Qpos));
            lastPos = Qpos + 1;
            Qpos = this.sql.indexOf(63, lastPos);
            dumpSql.append(arg);
        }
        if (lastPos < this.sql.length()) {
            dumpSql.append(this.sql.substring(lastPos, this.sql.length()));
        }
        return dumpSql.toString();
    }

    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    public PreparedStatement getRealPreparedStatement() {
        return this.realPreparedStatement;
    }

    public PreparedStatementSpy(String sql, ConnectionSpy connectionSpy, PreparedStatement realPreparedStatement, SpyLogDelegator logDelegator) {
        super(connectionSpy, realPreparedStatement, logDelegator);
        this.sql = sql;
        this.realPreparedStatement = realPreparedStatement;
        this.rdbmsSpecifics = connectionSpy.getRdbmsSpecifics();
    }

    public String getClassType() {
        return "PreparedStatement";
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Time)", x);
        try {
            this.realPreparedStatement.setTime(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Time)", x);
        try {
            this.realPreparedStatement.setTime(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String methodCall = "setNull(" + parameterIndex + ", " + sqlType + ")";
        this.argTraceSet(parameterIndex, null, null);
        try {
            this.realPreparedStatement.setNull(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        String methodCall = "setNull(" + paramIndex + ", " + sqlType + ", " + typeName + ")";
        this.argTraceSet(paramIndex, null, null);
        try {
            this.realPreparedStatement.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setRef(int i, Ref x) throws SQLException {
        String methodCall = "setRef(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Ref)", x);
        try {
            this.realPreparedStatement.setRef(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        String methodCall = "setBoolean(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(boolean)", x ? Boolean.TRUE : Boolean.FALSE);
        try {
            this.realPreparedStatement.setBoolean(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        String methodCall = "setBlob(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Blob)", x == null ? null : "<Blob of size " + x.length() + ">");
        try {
            this.realPreparedStatement.setBlob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setClob(int i, Clob x) throws SQLException {
        String methodCall = "setClob(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Clob)", x == null ? null : "<Clob of size " + x.length() + ">");
        try {
            this.realPreparedStatement.setClob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setArray(int i, Array x) throws SQLException {
        String methodCall = "setArray(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Array)", "<Array>");
        try {
            this.realPreparedStatement.setArray(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        String methodCall = "setByte(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(byte)", new Byte(x));
        try {
            this.realPreparedStatement.setByte(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setUnicodeStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Unicode InputStream)", "<Unicode InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        String methodCall = "setShort(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(short)", new Short(x));
        try {
            this.realPreparedStatement.setShort(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean execute() throws SQLException {
        String methodCall = "execute()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realPreparedStatement.execute();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        String methodCall = "setInt(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(int)", new Integer(x));
        try {
            this.realPreparedStatement.setInt(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        String methodCall = "setLong(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(long)", new Long(x));
        try {
            this.realPreparedStatement.setLong(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        String methodCall = "setFloat(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(float)", new Float(x));
        try {
            this.realPreparedStatement.setFloat(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        String methodCall = "setDouble(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(double)", new Double(x));
        try {
            this.realPreparedStatement.setDouble(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String methodCall = "setBigDecimal(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(BigDecimal)", x);
        try {
            this.realPreparedStatement.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        String methodCall = "setURL(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(URL)", x);
        try {
            this.realPreparedStatement.setURL(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        String methodCall = "setString(" + parameterIndex + ", \"" + x + "\")";
        this.argTraceSet(parameterIndex, "(String)", x);
        try {
            this.realPreparedStatement.setString(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        String methodCall = "setBytes(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(byte[])", "<byte[]>");
        try {
            this.realPreparedStatement.setBytes(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Date)", x);
        try {
            this.realPreparedStatement.setDate(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        String methodCall = "getParameterMetaData()";
        try {
            return (ParameterMetaData)this.reportReturn(methodCall, this.realPreparedStatement.getParameterMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Date)", x);
        try {
            this.realPreparedStatement.setDate(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public ResultSet executeQuery() throws SQLException {
        String methodCall = "executeQuery()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            ResultSet r = this.realPreparedStatement.executeQuery();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            ResultSetSpy rsp = new ResultSetSpy(this, r, this.log);
            return (ResultSet)this.reportReturn(methodCall, rsp);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    private String getTypeHelp(Object x) {
        if (x == null) {
            return "(null)";
        }
        return "(" + x.getClass().getName() + ")";
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ", " + scale + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            this.realPreparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            this.realPreparedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            this.realPreparedStatement.setObject(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Date)", x);
        try {
            this.realPreparedStatement.setTimestamp(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Timestamp)", x);
        try {
            this.realPreparedStatement.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public int executeUpdate() throws SQLException {
        String methodCall = "executeUpdate()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realPreparedStatement.executeUpdate();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedKeys(this.dumpedSql());
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Ascii InputStream)", "<Ascii InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Binary InputStream)", "<Binary InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        String methodCall = "clearParameters()";
        List<String> list = this.argTrace;
        synchronized (list) {
            this.argTrace.clear();
        }
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return (ResultSetMetaData)this.reportReturn(methodCall, this.realPreparedStatement.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void addBatch() throws SQLException {
        String methodCall = "addBatch()";
        this.currentBatch.add(this.dumpedSql());
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }
}

