/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.log.log4j2.message;

import net.sf.log4jdbc.log.log4j2.message.SqlMessage;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.ConnectionSpy;
import org.apache.logging.log4j.message.Message;

public class ConnectionMessage
extends SqlMessage
implements Message {
    private static final long serialVersionUID = 6278727380958233518L;
    private Spy spy;
    private Operation operation;
    private long execTime;

    public ConnectionMessage() {
        this(null, -1L, null, false);
    }

    public ConnectionMessage(Spy spy, long execTime, Operation operation, boolean isDebugEnabled) {
        super(isDebugEnabled);
        this.spy = spy;
        this.execTime = execTime;
        this.operation = operation == Operation.OPENING || operation == Operation.CLOSING || operation == Operation.ABORTING ? operation : null;
    }

    protected void buildMessage() {
        StringBuffer buildMsg = new StringBuffer();
        if (this.isDebugEnabled()) {
            buildMsg.append(SqlMessage.getDebugInfo());
            buildMsg.append(SqlMessage.nl);
        }
        buildMsg.append(this.spy.getConnectionNumber()).append(". Connection ");
        if (this.operation == Operation.OPENING) {
            buildMsg.append("opened.");
        } else if (this.operation == Operation.CLOSING) {
            buildMsg.append("closed.");
        } else if (this.operation == Operation.ABORTING) {
            buildMsg.append("aborted.");
        } else {
            buildMsg.append("opened, closed or aborted.");
        }
        if (this.execTime != -1L) {
            buildMsg.append(" {executed in ").append(this.execTime).append("ms} ");
        }
        if (this.isDebugEnabled()) {
            buildMsg.append(SqlMessage.nl);
            buildMsg.append(ConnectionSpy.getOpenConnectionsDump());
        }
        this.setMessage(buildMsg.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        OPENING,
        CLOSING,
        ABORTING;

    }
}

