/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.resultsetcollector;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.log4jdbc.sql.jdbcapi.ResultSetSpy;
import net.sf.log4jdbc.sql.resultsetcollector.JdbcUtils;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultSetCollector
implements ResultSetCollector {
    private static final String NULL_RESULT_SET_VAL = "[null]";
    private static final String UNREAD = "[unread]";
    private static final String UNREAD_ERROR = "[unread!]";
    private boolean fillInUnreadValues = false;
    private ResultSetMetaData metaData = null;
    private List<Object> row = null;
    private List<List<Object>> rows = null;
    private Map<String, Integer> colNameToColIndex;
    private int colIndex = -1;
    private static final List<String> GETTERS = Arrays.asList("getString", "getLong", "getInt", "getDate", "getTimestamp", "getTime", "getBigDecimal", "getFloat", "getDouble", "getByte", "getShort", "getObject", "getBoolean");

    public DefaultResultSetCollector(boolean fillInUnreadValues) {
        this.fillInUnreadValues = fillInUnreadValues;
    }

    @Override
    public List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.metaData.getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.rows = null;
        this.row = null;
        this.metaData = null;
        this.colNameToColIndex = null;
        this.colIndex = -1;
    }

    private void getMetaDataIfNeeded(Object object) {
        if (this.metaData == null) {
            ResultSet rs = (ResultSet)object;
            try {
                this.metaData = rs.getMetaData();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.setupColNameToColIndexMap();
        }
    }

    private void setupColNameToColIndexMap() {
        int columnCount = this.getColumnCount();
        this.colNameToColIndex = new HashMap<String, Integer>(columnCount);
        for (int column = 1; column <= columnCount; ++column) {
            this.colNameToColIndex.put(this.getColumnName(column).toLowerCase(), column);
            this.colNameToColIndex.put(this.getColumnLabel(column).toLowerCase(), column);
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.metaData.getColumnName(column);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getColumnLabel(int column) {
        try {
            return this.metaData.getColumnLabel(column);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean methodReturned(ResultSetSpy resultSetSpy, String methodCall, Object returnValue, Object targetObject, Object ... methodParams) {
        String methodName;
        if (methodCall.startsWith("get") && methodParams != null && methodParams.length == 1 && GETTERS.contains(methodName = methodCall.substring(0, methodCall.indexOf(40)))) {
            this.setColIndexFromGetXXXMethodParams(methodParams);
            this.makeRowIfNeeded();
            this.row.set(this.colIndex - 1, returnValue);
        }
        if (methodCall.equals("wasNull()") && Boolean.TRUE.equals(returnValue)) {
            this.row.set(this.colIndex - 1, NULL_RESULT_SET_VAL);
        }
        if ("next()".equals(methodCall) || "close()".equals(methodCall)) {
            boolean isEndOfResultSet;
            this.getMetaDataIfNeeded(resultSetSpy.getRealResultSet());
            boolean bl = isEndOfResultSet = Boolean.FALSE.equals(returnValue) || "close()".equals(methodCall);
            if (this.row != null) {
                if (this.rows == null) {
                    this.rows = new ArrayList<List<Object>>();
                }
                this.rows.add(this.row);
                this.row = null;
            }
            if (isEndOfResultSet) {
                return true;
            }
        }
        if ("getMetaData()".equals(methodCall)) {
            this.metaData = (ResultSetMetaData)returnValue;
            this.setupColNameToColIndexMap();
        }
        return false;
    }

    private void makeRowIfNeeded() {
        if (this.row == null) {
            this.row = new ArrayList<Object>(this.getColumnCount());
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.row.add(UNREAD);
            }
        }
    }

    private void setColIndexFromGetXXXMethodParams(Object ... methodParams) {
        Object param1 = methodParams[0];
        if (param1 == null) {
            throw new RuntimeException("ResultSet.getXXX() first param null? ");
        }
        if (param1 instanceof Integer) {
            this.colIndex = (Integer)param1;
        } else if (param1 instanceof String) {
            if (this.colNameToColIndex == null) {
                throw new RuntimeException("ResultSet.getXXX(colName): colNameToColIndex null");
            }
            Integer idx = this.colNameToColIndex.get(((String)param1).toLowerCase());
            if (idx == null) {
                throw new RuntimeException("ResultSet.getXXX(colName): could not look up name");
            }
            this.colIndex = idx;
        } else {
            throw new RuntimeException("ResultSet.getXXX called with: " + param1.getClass().getName());
        }
    }

    @Override
    public void preMethod(ResultSetSpy resultSetSpy, String methodCall, Object ... methodParams) {
        if (methodCall.equals("next()") && this.fillInUnreadValues && this.row != null) {
            int colIndex = 0;
            for (Object v : this.row) {
                if (v != null && v.toString().equals(UNREAD)) {
                    Object resultSetValue = null;
                    try {
                        resultSetValue = JdbcUtils.getResultSetValue(resultSetSpy.getRealResultSet(), colIndex + 1);
                    }
                    catch (SQLException e) {
                        resultSetValue = UNREAD_ERROR;
                    }
                    if (resultSetValue != null) {
                        this.row.set(colIndex, resultSetValue);
                    } else {
                        this.row.set(colIndex, NULL_RESULT_SET_VAL);
                    }
                }
                ++colIndex;
            }
        }
    }
}

