/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.SpyLogFactory;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.CallableStatementSpy;
import net.sf.log4jdbc.sql.jdbcapi.DriverSpy;
import net.sf.log4jdbc.sql.jdbcapi.PreparedStatementSpy;
import net.sf.log4jdbc.sql.jdbcapi.StatementSpy;
import net.sf.log4jdbc.sql.rdbmsspecifics.RdbmsSpecifics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionSpy
implements Connection,
Spy {
    private Connection realConnection;
    private SpyLogDelegator log;
    private final Integer connectionNumber;
    private static int lastConnectionNumber = 0;
    private static final Map<Integer, ConnectionSpy> connectionTracker = new HashMap<Integer, ConnectionSpy>();
    private RdbmsSpecifics rdbmsSpecifics;

    public Connection getRealConnection() {
        return this.realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenConnectionsDump() {
        Object[] keysArr;
        int size;
        StringBuffer dump = new StringBuffer();
        Map<Integer, ConnectionSpy> map = connectionTracker;
        synchronized (map) {
            size = connectionTracker.size();
            if (size == 0) {
                return "open connections:  none";
            }
            Set<Integer> keys = connectionTracker.keySet();
            keysArr = keys.toArray(new Integer[keys.size()]);
        }
        Arrays.sort(keysArr);
        dump.append("open connections:  ");
        for (int i = 0; i < keysArr.length; ++i) {
            dump.append(keysArr[i]);
            dump.append(" ");
        }
        dump.append("(");
        dump.append(size);
        dump.append(")");
        return dump.toString();
    }

    public ConnectionSpy(Connection realConnection) {
        this(realConnection, DriverSpy.defaultRdbmsSpecifics);
    }

    public ConnectionSpy(Connection realConnection, long execTime) {
        this(realConnection, null, execTime);
    }

    public ConnectionSpy(Connection realConnection, RdbmsSpecifics rdbmsSpecifics) {
        this(realConnection, rdbmsSpecifics, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionSpy(Connection realConnection, RdbmsSpecifics rdbmsSpecifics, long execTime) {
        if (rdbmsSpecifics == null) {
            rdbmsSpecifics = DriverSpy.defaultRdbmsSpecifics;
        }
        this.setRdbmsSpecifics(rdbmsSpecifics);
        if (realConnection == null) {
            throw new IllegalArgumentException("Must pass in a non null real Connection");
        }
        this.realConnection = realConnection;
        this.log = SpyLogFactory.getSpyLogDelegator();
        Map<Integer, ConnectionSpy> map = connectionTracker;
        synchronized (map) {
            this.connectionNumber = new Integer(++lastConnectionNumber);
            connectionTracker.put(this.connectionNumber, this);
        }
        this.log.connectionOpened(this, execTime);
        this.reportReturn("new Connection");
    }

    void setRdbmsSpecifics(RdbmsSpecifics rdbmsSpecifics) {
        this.rdbmsSpecifics = rdbmsSpecifics;
    }

    RdbmsSpecifics getRdbmsSpecifics() {
        return this.rdbmsSpecifics;
    }

    @Override
    public Integer getConnectionNumber() {
        return this.connectionNumber;
    }

    @Override
    public String getClassType() {
        return "Connection";
    }

    protected void reportException(String methodCall, SQLException exception, String sql) {
        this.log.exceptionOccured(this, methodCall, exception, sql, -1L);
    }

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportException(String methodCall, SQLException exception, long execTime) {
        this.log.exceptionOccured(this, methodCall, exception, null, execTime);
    }

    protected void reportAllReturns(String methodCall, String returnValue) {
        this.log.methodReturned(this, methodCall, returnValue);
    }

    private boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private <T> T reportReturn(String methodCall, T value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    private void reportClosed(long execTime) {
        this.log.connectionClosed(this, execTime);
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.realConnection.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String methodCall = "setSavepoint()";
        try {
            return this.reportReturn(methodCall, this.realConnection.setSavepoint());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodCall = "releaseSavepoint(" + savepoint + ")";
        try {
            this.realConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodCall = "rollback(" + savepoint + ")";
        try {
            this.realConnection.rollback(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.realConnection.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Statement createStatement() throws SQLException {
        String methodCall = "createStatement()";
        try {
            Statement statement = this.realConnection.createStatement();
            return this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            Statement statement = this.realConnection.createStatement(resultSetType, resultSetConcurrency);
            return this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            Statement statement = this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String methodCall = "setReadOnly(" + readOnly + ")";
        try {
            this.realConnection.setReadOnly(readOnly);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + autoGeneratedKeys + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, autoGeneratedKeys);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnIndexes + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, columnIndexes);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String methodCall = "setSavepoint(" + name + ")";
        try {
            return this.reportReturn(methodCall, this.realConnection.setSavepoint(name));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnNames + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, columnNames);
            return this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String methodCall = "isReadOnly()";
        try {
            return this.reportReturn(methodCall, this.realConnection.isReadOnly());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String methodCall = "setHoldability(" + holdability + ")";
        try {
            this.realConnection.setHoldability(holdability);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String methodCall = "prepareCall(" + sql + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql);
            return this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
            return this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String methodCall = "setCatalog(" + catalog + ")";
        try {
            this.realConnection.setCatalog(catalog);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String methodCall = "nativeSQL(" + sql + ")";
        try {
            return this.reportReturn(methodCall, this.realConnection.nativeSQL(sql));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        String methodCall = "getTypeMap()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getTypeMap());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String methodCall = "setAutoCommit(" + autoCommit + ")";
        try {
            this.realConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getCatalog() throws SQLException {
        String methodCall = "getCatalog()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getCatalog());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        String methodCall = "setTypeMap(" + map + ")";
        try {
            this.realConnection.setTypeMap(map);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String methodCall = "setTransactionIsolation(" + level + ")";
        try {
            this.realConnection.setTransactionIsolation(level);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        String methodCall = "getAutoCommit()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getAutoCommit());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodCall = "getHoldability()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String methodCall = "getTransactionIsolation()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getTransactionIsolation());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void commit() throws SQLException {
        String methodCall = "commit()";
        try {
            this.realConnection.commit();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback() throws SQLException {
        String methodCall = "rollback()";
        try {
            this.realConnection.rollback();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        long tstart = System.currentTimeMillis();
        try {
            this.realConnection.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, System.currentTimeMillis() - tstart);
            throw s;
        }
        finally {
            Map<Integer, ConnectionSpy> map = connectionTracker;
            synchronized (map) {
                connectionTracker.remove(this.connectionNumber);
            }
            this.reportClosed(System.currentTimeMillis() - tstart);
        }
        this.reportReturn(methodCall);
    }
}

