/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.benf.cfr.reader.bytecode.AnonymousClassUsage;
import org.benf.cfr.reader.bytecode.analysis.opgraph.GraphConversionHelper;
import org.benf.cfr.reader.bytecode.analysis.opgraph.IndexedStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.InstrIndex;
import org.benf.cfr.reader.bytecode.analysis.opgraph.MutableGraph;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LinearScannedBlock;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.NarrowingTypeRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.StatementEquivalenceConstraint;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TypeFilter;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.Statement;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractAssignmentExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMutatingAssignmentExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithOp;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticPostMutationOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.BoolOp;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConditionalExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.Literal;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.StackValue;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.FieldVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StackSSALabel;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.CloneHelper;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ConditionalSimplifyingRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterFlags;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StackVarToLocalRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AbstractAssignment;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentPreMutation;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.CaseStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.CatchStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.CommentStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.DoStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.FinallyStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.IfExitingStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.JumpingStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.MonitorExitStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.MonitorStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.Nop;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.SwitchStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.ThrowStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.TryStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.WhileStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifierFactory;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockType;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.CreationCollector;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.JumpType;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueAssignmentAndAliasCondenser;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueAssignmentExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueUsageCollectorSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifierFactory;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifierUtils;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifiers;
import org.benf.cfr.reader.bytecode.analysis.parse.wildcard.WildcardMatch;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.entities.exceptions.ExceptionCheckImpl;
import org.benf.cfr.reader.entities.exceptions.ExceptionGroup;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.collections.Functional;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.collections.MapFactory;
import org.benf.cfr.reader.util.collections.SetFactory;
import org.benf.cfr.reader.util.collections.SetUtil;
import org.benf.cfr.reader.util.functors.BinaryProcedure;
import org.benf.cfr.reader.util.functors.Predicate;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.graph.GraphVisitor;
import org.benf.cfr.reader.util.graph.GraphVisitorDFS;
import org.benf.cfr.reader.util.output.Dumpable;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.LoggerFactory;

public class Op03SimpleStatement
implements MutableGraph<Op03SimpleStatement>,
Dumpable,
StatementContainer<Statement>,
IndexedStatement {
    private static final Logger logger = LoggerFactory.create(Op03SimpleStatement.class);
    private final List<Op03SimpleStatement> sources = ListFactory.newList();
    private final List<Op03SimpleStatement> targets = ListFactory.newList();
    private Op03SimpleStatement linearlyPrevious;
    private Op03SimpleStatement linearlyNext;
    private boolean isNop;
    private InstrIndex index;
    private Statement containedStatement;
    private SSAIdentifiers<LValue> ssaIdentifiers;
    private BlockIdentifier thisComparisonBlock;
    private BlockIdentifier firstStatementInThisBlock;
    private final Set<BlockIdentifier> containedInBlocks = SetFactory.newSet();
    private Set<BlockIdentifier> possibleExitsFor = null;

    public Op03SimpleStatement(Op02WithProcessedDataAndRefs original, Statement statement) {
        this.containedStatement = statement;
        this.isNop = false;
        this.index = original.getIndex();
        this.ssaIdentifiers = new SSAIdentifiers();
        this.containedInBlocks.addAll(original.getContainedInTheseBlocks());
        statement.setContainer(this);
    }

    public Op03SimpleStatement(Set<BlockIdentifier> containedIn, Statement statement, InstrIndex index) {
        this.containedStatement = statement;
        this.isNop = false;
        this.index = index;
        this.ssaIdentifiers = new SSAIdentifiers();
        this.containedInBlocks.addAll(containedIn);
        statement.setContainer(this);
    }

    public Op03SimpleStatement(Set<BlockIdentifier> containedIn, Statement statement, SSAIdentifiers<LValue> ssaIdentifiers, InstrIndex index) {
        this.containedStatement = statement;
        this.isNop = false;
        this.index = index;
        this.ssaIdentifiers = new SSAIdentifiers<LValue>(ssaIdentifiers);
        this.containedInBlocks.addAll(containedIn);
        statement.setContainer(this);
    }

    @Override
    public List<Op03SimpleStatement> getSources() {
        return this.sources;
    }

    @Override
    public List<Op03SimpleStatement> getTargets() {
        return this.targets;
    }

    public void setLinearlyNext(Op03SimpleStatement linearlyNext) {
        this.linearlyNext = linearlyNext;
    }

    public Op03SimpleStatement getLinearlyPrevious() {
        return this.linearlyPrevious;
    }

    public void setLinearlyPrevious(Op03SimpleStatement linearlyPrevious) {
        this.linearlyPrevious = linearlyPrevious;
    }

    public BlockIdentifier getFirstStatementInThisBlock() {
        return this.firstStatementInThisBlock;
    }

    public void setFirstStatementInThisBlock(BlockIdentifier firstStatementInThisBlock) {
        this.firstStatementInThisBlock = firstStatementInThisBlock;
    }

    @Override
    public void addSource(Op03SimpleStatement source) {
        if (source == null) {
            throw new ConfusedCFRException("Null source being added.");
        }
        this.sources.add(source);
    }

    @Override
    public void addTarget(Op03SimpleStatement target) {
        this.targets.add(target);
    }

    @Override
    public Statement getStatement() {
        return this.containedStatement;
    }

    @Override
    public Statement getTargetStatement(int idx) {
        if (this.targets.size() <= idx) {
            throw new ConfusedCFRException("Trying to get invalid target " + idx);
        }
        Op03SimpleStatement target = this.targets.get(idx);
        Statement statement = target.getStatement();
        if (statement == null) {
            throw new ConfusedCFRException("Invalid target statement");
        }
        return statement;
    }

    @Override
    public void replaceStatement(Statement newStatement) {
        newStatement.setContainer(this);
        this.containedStatement = newStatement;
    }

    private void markAgreedNop() {
        this.isNop = true;
    }

    @Override
    public void nopOut() {
        if (this.isNop) {
            return;
        }
        if (this.targets.isEmpty()) {
            for (Op03SimpleStatement source : this.sources) {
                source.removeTarget(this);
            }
            this.sources.clear();
            this.containedStatement = new Nop();
            this.containedStatement.setContainer(this);
            this.markAgreedNop();
            return;
        }
        if (this.targets.size() != 1) {
            throw new ConfusedCFRException("Trying to nopOut a node with multiple targets");
        }
        this.containedStatement = new Nop();
        this.containedStatement.setContainer(this);
        Op03SimpleStatement target = this.targets.get(0);
        for (Op03SimpleStatement source : this.sources) {
            source.replaceTarget(this, target);
        }
        target.replaceSingleSourceWith(this, this.sources);
        this.sources.clear();
        this.targets.clear();
        this.markAgreedNop();
    }

    @Override
    public void nopOutConditional() {
        this.containedStatement = new Nop();
        this.containedStatement.setContainer(this);
        for (int i = 1; i < this.targets.size(); ++i) {
            Op03SimpleStatement dropTarget = this.targets.get(i);
            dropTarget.removeSource(this);
        }
        Op03SimpleStatement target = this.targets.get(0);
        this.targets.clear();
        this.targets.add(target);
        for (Op03SimpleStatement source : this.sources) {
            source.replaceTarget(this, target);
        }
        target.replaceSingleSourceWith(this, this.sources);
        this.sources.clear();
        this.targets.clear();
        this.markAgreedNop();
    }

    public void clear() {
        for (Op03SimpleStatement source : this.sources) {
            if (!source.getTargets().contains(this)) continue;
            source.removeTarget(this);
        }
        this.sources.clear();
        for (Op03SimpleStatement target : this.targets) {
            if (!target.getSources().contains(this)) continue;
            target.removeSource(this);
        }
        this.targets.clear();
        this.nopOut();
    }

    @Override
    public SSAIdentifiers<LValue> getSSAIdentifiers() {
        return this.ssaIdentifiers;
    }

    @Override
    public Set<BlockIdentifier> getBlockIdentifiers() {
        return this.containedInBlocks;
    }

    @Override
    public BlockIdentifier getBlockStarted() {
        return this.firstStatementInThisBlock;
    }

    @Override
    public Set<BlockIdentifier> getBlocksEnded() {
        if (this.linearlyPrevious == null) {
            return SetFactory.newSet();
        }
        Set<BlockIdentifier> in = SetFactory.newSet(this.linearlyPrevious.getBlockIdentifiers());
        in.removeAll(this.getBlockIdentifiers());
        Iterator<BlockIdentifier> iterator = in.iterator();
        while (iterator.hasNext()) {
            BlockIdentifier blockIdentifier = iterator.next();
            if (blockIdentifier.getBlockType().isBreakable()) continue;
            iterator.remove();
        }
        return in;
    }

    public Op03SimpleStatement getLinearlyNext() {
        return this.linearlyNext;
    }

    @Override
    public void copyBlockInformationFrom(StatementContainer other) {
        Op03SimpleStatement other3 = (Op03SimpleStatement)other;
        this.containedInBlocks.addAll(other.getBlockIdentifiers());
        if (this.firstStatementInThisBlock == null) {
            this.firstStatementInThisBlock = other3.firstStatementInThisBlock;
        }
    }

    public boolean isAgreedNop() {
        return this.isNop;
    }

    void replaceBlockIfIn(BlockIdentifier oldB, BlockIdentifier newB) {
        if (this.containedInBlocks.remove(oldB)) {
            this.containedInBlocks.add(newB);
        }
    }

    public void replaceTarget(Op03SimpleStatement oldTarget, Op03SimpleStatement newTarget) {
        int index = this.targets.indexOf(oldTarget);
        if (index == -1) {
            throw new ConfusedCFRException("Invalid target");
        }
        this.targets.set(index, newTarget);
    }

    private void replaceSingleSourceWith(Op03SimpleStatement oldSource, List<Op03SimpleStatement> newSources) {
        if (!this.sources.remove(oldSource)) {
            throw new ConfusedCFRException("Invalid source");
        }
        this.sources.addAll(newSources);
    }

    public void replaceSource(Op03SimpleStatement oldSource, Op03SimpleStatement newSource) {
        int index = this.sources.indexOf(oldSource);
        if (index == -1) {
            throw new ConfusedCFRException("Invalid source");
        }
        this.sources.set(index, newSource);
    }

    public void removeSource(Op03SimpleStatement oldSource) {
        if (!this.sources.remove(oldSource)) {
            throw new ConfusedCFRException("Invalid source, tried to remove " + oldSource + "\nfrom " + this + "\nbut was not a source.");
        }
    }

    public void removeTarget(Op03SimpleStatement oldTarget) {
        if (this.containedStatement instanceof GotoStatement) {
            throw new ConfusedCFRException("Removing goto target");
        }
        if (!this.targets.remove(oldTarget)) {
            throw new ConfusedCFRException("Invalid target, tried to remove " + oldTarget + "\nfrom " + this + "\nbut was not a target.");
        }
    }

    public void removeGotoTarget(Op03SimpleStatement oldTarget) {
        if (!this.targets.remove(oldTarget)) {
            throw new ConfusedCFRException("Invalid target, tried to remove " + oldTarget + "\nfrom " + this + "\nbut was not a target.");
        }
    }

    private LValue getCreatedLValue() {
        return this.containedStatement.getCreatedLValue();
    }

    @Override
    public InstrIndex getIndex() {
        return this.index;
    }

    public void setIndex(InstrIndex index) {
        this.index = index;
    }

    public BlockIdentifier getThisComparisonBlock() {
        return this.thisComparisonBlock;
    }

    public void clearThisComparisonBlock() {
        this.thisComparisonBlock = null;
    }

    public void markBlockStatement(BlockIdentifier blockIdentifier, Op03SimpleStatement lastInBlock, Op03SimpleStatement blockEnd, List<Op03SimpleStatement> statements) {
        if (this.thisComparisonBlock != null) {
            throw new ConfusedCFRException("Statement marked as the start of multiple blocks");
        }
        this.thisComparisonBlock = blockIdentifier;
        switch (blockIdentifier.getBlockType()) {
            case WHILELOOP: {
                IfStatement ifStatement = (IfStatement)this.containedStatement;
                ifStatement.replaceWithWhileLoopStart(blockIdentifier);
                Op03SimpleStatement whileEndTarget = this.targets.get(1);
                boolean pullOutJump = this.index.isBackJumpTo(whileEndTarget);
                if (!pullOutJump && statements.indexOf(lastInBlock) != statements.indexOf(blockEnd) - 1) {
                    pullOutJump = true;
                }
                if (!pullOutJump) break;
                Set<BlockIdentifier> backJumpContainedIn = SetFactory.newSet(this.containedInBlocks);
                backJumpContainedIn.remove(blockIdentifier);
                Op03SimpleStatement backJump = new Op03SimpleStatement(backJumpContainedIn, new GotoStatement(), blockEnd.index.justBefore());
                whileEndTarget.replaceSource(this, backJump);
                this.replaceTarget(whileEndTarget, backJump);
                backJump.addSource(this);
                backJump.addTarget(whileEndTarget);
                int insertAfter = statements.indexOf(blockEnd) - 1;
                while (!statements.get((int)insertAfter).containedInBlocks.containsAll(this.containedInBlocks)) {
                    --insertAfter;
                }
                backJump.index = statements.get((int)insertAfter).index.justAfter();
                statements.add(insertAfter + 1, backJump);
                break;
            }
            case UNCONDITIONALDOLOOP: {
                this.containedStatement.getContainer().replaceStatement(new WhileStatement(null, blockIdentifier));
                break;
            }
            case DOLOOP: {
                IfStatement ifStatement = (IfStatement)this.containedStatement;
                ifStatement.replaceWithWhileLoopEnd(blockIdentifier);
                break;
            }
            case SIMPLE_IF_ELSE: 
            case SIMPLE_IF_TAKEN: {
                throw new ConfusedCFRException("Shouldn't be marking the comparison of an IF");
            }
            default: {
                throw new ConfusedCFRException("Don't know how to start a block like this");
            }
        }
    }

    public void markFirstStatementInBlock(BlockIdentifier blockIdentifier) {
        if (this.firstStatementInThisBlock != null && this.firstStatementInThisBlock != blockIdentifier) {
            throw new ConfusedCFRException("Statement already marked as first in another block");
        }
        this.firstStatementInThisBlock = blockIdentifier;
    }

    public void markBlock(BlockIdentifier blockIdentifier) {
        this.containedInBlocks.add(blockIdentifier);
    }

    public void collect(LValueAssignmentAndAliasCondenser lValueAssigmentCollector) {
        this.containedStatement.collectLValueAssignments(lValueAssigmentCollector);
    }

    public void condense(LValueRewriter lValueRewriter) {
        this.containedStatement.replaceSingleUsageLValues(lValueRewriter, this.ssaIdentifiers);
    }

    public void rewrite(ExpressionRewriter expressionRewriter) {
        this.containedStatement.rewriteExpressions(expressionRewriter, this.ssaIdentifiers);
    }

    private void findCreation(CreationCollector creationCollector) {
        this.containedStatement.collectObjectCreation(creationCollector);
    }

    private void simplifyConditional() {
        if (this.containedStatement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)this.containedStatement;
            ifStatement.simplifyCondition();
        }
    }

    private boolean needsLabel() {
        if (this.sources.size() > 1) {
            return true;
        }
        if (this.sources.size() == 0) {
            return false;
        }
        Op03SimpleStatement source = this.sources.get(0);
        return !source.getIndex().directlyPreceeds(this.getIndex());
    }

    @Override
    public String getLabel() {
        return this.getIndex().toString();
    }

    public void dumpInner(Dumper dumper) {
        if (this.needsLabel()) {
            dumper.print(this.getLabel() + ":\n");
        }
        for (BlockIdentifier blockIdentifier : this.containedInBlocks) {
            dumper.print(blockIdentifier + " ");
        }
        this.getStatement().dump(dumper);
    }

    @Override
    public Dumper dump(Dumper dumper) {
        dumper.print("**********\n");
        List<Op03SimpleStatement> reachableNodes = ListFactory.newList();
        GraphVisitorCallee graphVisitorCallee = new GraphVisitorCallee(reachableNodes);
        GraphVisitorDFS<Op03SimpleStatement> visitor = new GraphVisitorDFS<Op03SimpleStatement>(this, graphVisitorCallee);
        visitor.process();
        try {
            Collections.sort(reachableNodes, new CompareByIndex());
        }
        catch (ConfusedCFRException e) {
            dumper.print("CONFUSED!" + e);
        }
        for (Op03SimpleStatement op : reachableNodes) {
            op.dumpInner(dumper);
        }
        dumper.print("**********\n");
        return dumper;
    }

    private Op04StructuredStatement getStructuredStatementPlaceHolder() {
        return new Op04StructuredStatement(this.index, this.containedInBlocks, this.containedStatement.getStructuredStatement());
    }

    public boolean isCompound() {
        return this.containedStatement.isCompound();
    }

    public List<Op03SimpleStatement> splitCompound() {
        List<Op03SimpleStatement> result = ListFactory.newList();
        List<Statement> innerStatements = this.containedStatement.getCompoundParts();
        InstrIndex nextIndex = this.index.justAfter();
        for (Statement statement : innerStatements) {
            result.add(new Op03SimpleStatement(this.containedInBlocks, statement, nextIndex));
            nextIndex = nextIndex.justAfter();
        }
        ((Op03SimpleStatement)result.get((int)0)).firstStatementInThisBlock = this.firstStatementInThisBlock;
        Op03SimpleStatement previous = null;
        for (Op03SimpleStatement statement : result) {
            if (previous != null) {
                statement.addSource(previous);
                previous.addTarget(statement);
            }
            previous = statement;
        }
        Op03SimpleStatement op03SimpleStatement = (Op03SimpleStatement)result.get(0);
        Op03SimpleStatement newEnd = previous;
        for (Op03SimpleStatement source : this.sources) {
            source.replaceTarget(this, op03SimpleStatement);
            op03SimpleStatement.addSource(source);
        }
        for (Op03SimpleStatement target : this.targets) {
            target.replaceSource(this, newEnd);
            newEnd.addTarget(target);
        }
        this.containedStatement = new Nop();
        this.sources.clear();
        this.targets.clear();
        this.markAgreedNop();
        return result;
    }

    private void collectLocallyMutatedVariables(SSAIdentifierFactory<LValue> ssaIdentifierFactory) {
        this.ssaIdentifiers = this.containedStatement.collectLocallyMutatedVariables(ssaIdentifierFactory);
    }

    public void forceSSAIdentifiers(SSAIdentifiers<LValue> newIdentifiers) {
        this.ssaIdentifiers = newIdentifiers;
    }

    public static void assignSSAIdentifiers(Method method, List<Op03SimpleStatement> statements) {
        SSAIdentifierFactory<LValue> ssaIdentifierFactory = new SSAIdentifierFactory<LValue>(null);
        List<LocalVariable> params = method.getMethodPrototype().getComputedParameters();
        Map initialSSAValues = MapFactory.newMap();
        for (LocalVariable localVariable : params) {
            initialSSAValues.put(localVariable, ssaIdentifierFactory.getIdent(localVariable));
        }
        SSAIdentifiers initialIdents = new SSAIdentifiers(initialSSAValues);
        for (Op03SimpleStatement statement : statements) {
            statement.collectLocallyMutatedVariables(ssaIdentifierFactory);
        }
        Op03SimpleStatement op03SimpleStatement = statements.get(0);
        LinkedList toProcess = ListFactory.newLinkedList();
        toProcess.addAll(statements);
        while (!toProcess.isEmpty()) {
            Op03SimpleStatement statement = (Op03SimpleStatement)toProcess.remove();
            SSAIdentifiers<LValue> ssaIdentifiers = statement.ssaIdentifiers;
            boolean changed = false;
            if (statement == op03SimpleStatement && ssaIdentifiers.mergeWith(initialIdents)) {
                changed = true;
            }
            for (Op03SimpleStatement source : statement.getSources()) {
                if (!ssaIdentifiers.mergeWith(source.ssaIdentifiers)) continue;
                changed = true;
            }
            if (!changed) continue;
            toProcess.addAll(statement.getTargets());
        }
    }

    public static void condenseLValueChain1(List<Op03SimpleStatement> statements) {
        for (Op03SimpleStatement statement : statements) {
            Statement stm2;
            Op03SimpleStatement statement2;
            Statement stm = statement.getStatement();
            if (!(stm instanceof AssignmentSimple) || statement.getTargets().size() != 1 || (statement2 = statement.getTargets().get(0)).getSources().size() != 1 || !((stm2 = statement2.getStatement()) instanceof AssignmentSimple)) continue;
            Op03SimpleStatement.applyLValueSwap((AssignmentSimple)stm, (AssignmentSimple)stm2, statement, statement2);
        }
    }

    private static void applyLValueSwap(AssignmentSimple a1, AssignmentSimple a2, Op03SimpleStatement stm1, Op03SimpleStatement stm2) {
        Expression r2;
        Expression r1 = a1.getRValue();
        if (!r1.equals(r2 = a2.getRValue())) {
            return;
        }
        LValue l1 = a1.getCreatedLValue();
        LValue l2 = a2.getCreatedLValue();
        if (l1 instanceof StackSSALabel && !(l2 instanceof StackSSALabel)) {
            stm1.replaceStatement(a2);
            stm2.replaceStatement(new AssignmentSimple(l1, new LValueExpression(l2)));
        }
    }

    public static void condenseLValueChain2(List<Op03SimpleStatement> statements) {
        for (Op03SimpleStatement statement : statements) {
            Statement stm2;
            Op03SimpleStatement statement2;
            Statement stm = statement.getStatement();
            if (!(stm instanceof AssignmentSimple) || statement.getTargets().size() != 1 || (statement2 = statement.getTargets().get(0)).getSources().size() != 1 || !((stm2 = statement2.getStatement()) instanceof AssignmentSimple)) continue;
            Op03SimpleStatement.applyLValueCondense((AssignmentSimple)stm, (AssignmentSimple)stm2, statement, statement2);
        }
    }

    private static void applyLValueCondense(AssignmentSimple a1, AssignmentSimple a2, Op03SimpleStatement stm1, Op03SimpleStatement stm2) {
        Expression r1 = a1.getRValue();
        Expression r2 = a2.getRValue();
        LValue l1 = a1.getCreatedLValue();
        LValue l2 = a2.getCreatedLValue();
        if (!r2.equals(new LValueExpression(l1))) {
            return;
        }
        Expression newRhs = null;
        if (r1 instanceof ArithmeticOperation && ((ArithmeticOperation)r1).isMutationOf(l1)) {
            ArithmeticOperation ar1 = (ArithmeticOperation)r1;
            AbstractMutatingAssignmentExpression me = ar1.getMutationOf(l1);
            newRhs = me;
        }
        if (newRhs == null) {
            newRhs = new AssignmentExpression(l1, r1);
        }
        if (newRhs.getInferredJavaType().getJavaTypeInstance() != l2.getInferredJavaType().getJavaTypeInstance()) {
            return;
        }
        stm2.replaceStatement(new AssignmentSimple(l2, newRhs));
        stm1.nopOut();
    }

    private static void replacePostChangeAssignment(Op03SimpleStatement statement) {
        AssignmentSimple assignmentSimple = (AssignmentSimple)statement.containedStatement;
        LValue postIncLValue = assignmentSimple.getCreatedLValue();
        if (statement.sources.size() != 1) {
            return;
        }
        Op03SimpleStatement prior = statement.sources.get(0);
        Statement statementPrior = prior.getStatement();
        if (!(statementPrior instanceof AssignmentSimple)) {
            return;
        }
        AssignmentSimple assignmentSimplePrior = (AssignmentSimple)statementPrior;
        LValue tmp = assignmentSimplePrior.getCreatedLValue();
        if (!(tmp instanceof StackSSALabel)) {
            return;
        }
        if (!assignmentSimplePrior.getRValue().equals(new LValueExpression(postIncLValue))) {
            return;
        }
        StackSSALabel tmpStackVar = (StackSSALabel)tmp;
        StackValue stackValue = new StackValue(tmpStackVar);
        Expression incrRValue = assignmentSimple.getRValue();
        if (!(incrRValue instanceof ArithmeticOperation)) {
            return;
        }
        ArithmeticOperation arithOp = (ArithmeticOperation)incrRValue;
        ArithOp op = arithOp.getOp();
        if (!op.equals((Object)ArithOp.PLUS) && !op.equals((Object)ArithOp.MINUS)) {
            return;
        }
        Expression lhs = arithOp.getLhs();
        Expression rhs = arithOp.getRhs();
        if (((Object)stackValue).equals(lhs)) {
            if (!Literal.equalsAnyOne(rhs)) {
                return;
            }
        } else if (((Object)stackValue).equals(rhs)) {
            if (!Literal.equalsAnyOne(lhs)) {
                return;
            }
            if (op.equals((Object)ArithOp.MINUS)) {
                return;
            }
        } else {
            return;
        }
        ArithmeticPostMutationOperation postMutationOperation = new ArithmeticPostMutationOperation(postIncLValue, op);
        prior.nopOut();
        statement.replaceStatement(new AssignmentSimple(tmp, postMutationOperation));
    }

    private static boolean replacePreChangeAssignment(Op03SimpleStatement statement) {
        AssignmentSimple assignmentSimple = (AssignmentSimple)statement.containedStatement;
        LValue lValue = assignmentSimple.getCreatedLValue();
        Expression rValue = assignmentSimple.getRValue();
        if (!(rValue instanceof ArithmeticOperation)) {
            return false;
        }
        ArithmeticOperation arithmeticOperation = (ArithmeticOperation)rValue;
        if (!arithmeticOperation.isMutationOf(lValue)) {
            return false;
        }
        AbstractMutatingAssignmentExpression mutationOperation = arithmeticOperation.getMutationOf(lValue);
        AssignmentPreMutation res = new AssignmentPreMutation(lValue, mutationOperation);
        statement.replaceStatement(res);
        return true;
    }

    public static void replacePrePostChangeAssignments(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> assignments = Functional.filter(statements, new TypeFilter<AssignmentSimple>(AssignmentSimple.class));
        for (Op03SimpleStatement assignment : assignments) {
            if (Op03SimpleStatement.replacePreChangeAssignment(assignment)) continue;
            Op03SimpleStatement.replacePostChangeAssignment(assignment);
        }
    }

    private static boolean eliminateCatchTemporary(Op03SimpleStatement catchh) {
        if (catchh.targets.size() != 1) {
            return false;
        }
        Op03SimpleStatement maybeAssign = catchh.targets.get(0);
        CatchStatement catchStatement = (CatchStatement)catchh.getStatement();
        LValue catching = catchStatement.getCreatedLValue();
        if (!(catching instanceof StackSSALabel)) {
            return false;
        }
        StackSSALabel catchingSSA = (StackSSALabel)catching;
        if (catchingSSA.getStackEntry().getUsageCount() != 1L) {
            return false;
        }
        while (maybeAssign.getStatement() instanceof TryStatement) {
            maybeAssign = maybeAssign.targets.get(0);
        }
        WildcardMatch match = new WildcardMatch();
        if (!match.match(new AssignmentSimple(match.getLValueWildCard("caught"), new StackValue(catchingSSA)), maybeAssign.getStatement())) {
            return false;
        }
        catchh.replaceStatement(new CatchStatement(catchStatement.getExceptions(), match.getLValueWildCard("caught").getMatch()));
        maybeAssign.nopOut();
        return true;
    }

    public static List<Op03SimpleStatement> eliminateCatchTemporaries(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> catches = Functional.filter(statements, new TypeFilter<CatchStatement>(CatchStatement.class));
        boolean effect = false;
        for (Op03SimpleStatement catchh : catches) {
            effect |= Op03SimpleStatement.eliminateCatchTemporary(catchh);
        }
        if (effect) {
            statements = Cleaner.removeUnreachableCode(statements, false);
        }
        return statements;
    }

    public static void removePointlessExpressionStatements(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> exrps = Functional.filter(statements, new TypeFilter<ExpressionStatement>(ExpressionStatement.class));
        for (Op03SimpleStatement esc : exrps) {
            ExpressionStatement es = (ExpressionStatement)esc.getStatement();
            Expression expression = es.getExpression();
            if (!(expression instanceof LValueExpression) && !(expression instanceof StackValue) && !(expression instanceof Literal)) continue;
            esc.nopOut();
        }
        List<Op03SimpleStatement> sas = Functional.filter(statements, new TypeFilter<AssignmentSimple>(AssignmentSimple.class));
        for (Op03SimpleStatement ass : sas) {
            LValueExpression lValueExpression;
            LValue lFromR;
            Expression rValue;
            AssignmentSimple assignmentSimple = (AssignmentSimple)ass.containedStatement;
            LValue lValue = assignmentSimple.getCreatedLValue();
            if (lValue instanceof FieldVariable || (rValue = assignmentSimple.getRValue()).getClass() != LValueExpression.class || !(lFromR = (lValueExpression = (LValueExpression)rValue).getLValue()).equals(lValue)) continue;
            ass.nopOut();
        }
    }

    private static boolean pushPreChange(Op03SimpleStatement preChange, boolean back) {
        AssignmentPreMutation mutation = (AssignmentPreMutation)preChange.containedStatement;
        Op03SimpleStatement current = preChange;
        LValue mutatedLValue = mutation.getCreatedLValue();
        LValueExpression lvalueExpression = new LValueExpression(mutatedLValue);
        UsageWatcher usageWatcher = new UsageWatcher(mutatedLValue);
        do {
            AssignmentSimple assignmentSimple;
            List<Op03SimpleStatement> candidates;
            List<Op03SimpleStatement> list = candidates = back ? current.getSources() : current.getTargets();
            if (candidates.size() != 1) {
                return false;
            }
            current = candidates.get(0);
            Statement innerStatement = current.getStatement();
            if (innerStatement instanceof AssignmentSimple && (assignmentSimple = (AssignmentSimple)innerStatement).getRValue().equals(lvalueExpression)) {
                SSAIdentifiers<LValue> assignIdents;
                LValue tgt = assignmentSimple.getCreatedLValue();
                SSAIdentifiers<LValue> preChangeIdents = preChange.getSSAIdentifiers();
                if (!preChangeIdents.isValidReplacement(tgt, assignIdents = current.getSSAIdentifiers())) {
                    return false;
                }
                if (back) {
                    assignIdents.setKnownIdentifierOnExit(mutatedLValue, preChangeIdents.getSSAIdentOnExit(mutatedLValue));
                } else {
                    assignIdents.setKnownIdentifierOnEntry(mutatedLValue, preChangeIdents.getSSAIdentOnEntry(mutatedLValue));
                }
                current.replaceStatement(new AssignmentSimple(tgt, back ? mutation.getPostMutation() : mutation.getPreMutation()));
                preChange.nopOut();
                return true;
            }
            current.rewrite(usageWatcher);
        } while (!usageWatcher.isFound());
        return false;
    }

    public static void pushPreChangeBack(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> assignments = Functional.filter(statements, new TypeFilter<AssignmentPreMutation>(AssignmentPreMutation.class));
        if ((assignments = Functional.filter(assignments, new StatementCanBePostMutation())).isEmpty()) {
            return;
        }
        for (Op03SimpleStatement assignment : assignments) {
            if (Op03SimpleStatement.pushPreChange(assignment, true)) continue;
            Op03SimpleStatement.pushPreChange(assignment, false);
        }
    }

    public static void condenseConstruction(DCCommonState state, Method method, List<Op03SimpleStatement> statements, AnonymousClassUsage anonymousClassUsage) {
        CreationCollector creationCollector = new CreationCollector(anonymousClassUsage);
        for (Op03SimpleStatement statement : statements) {
            statement.findCreation(creationCollector);
        }
        creationCollector.condenseConstructions(method, state);
    }

    public static boolean condenseConditionals(List<Op03SimpleStatement> statements) {
        boolean effect = false;
        for (int x = 0; x < statements.size(); ++x) {
            boolean retry;
            do {
                boolean takenJumpBy1;
                retry = false;
                Op03SimpleStatement op03SimpleStatement = statements.get(x);
                Statement inner = op03SimpleStatement.getStatement();
                if (!(inner instanceof IfStatement)) continue;
                Op03SimpleStatement fallThrough = op03SimpleStatement.getTargets().get(0);
                Op03SimpleStatement taken = op03SimpleStatement.getTargets().get(1);
                Statement fallthroughInner = fallThrough.getStatement();
                Statement takenInner = taken.getStatement();
                boolean bl = takenJumpBy1 = x < statements.size() - 2 && statements.get(x + 2) == taken;
                if (fallthroughInner instanceof IfStatement) {
                    Op03SimpleStatement sndIf = fallThrough;
                    Op03SimpleStatement sndTaken = sndIf.getTargets().get(1);
                    Op03SimpleStatement sndFallThrough = sndIf.getTargets().get(0);
                    retry = Op03SimpleStatement.condenseIfs(op03SimpleStatement, sndIf, taken, sndTaken, sndFallThrough, false);
                } else if (fallthroughInner.getClass() == GotoStatement.class && takenJumpBy1 && takenInner instanceof IfStatement) {
                    Op03SimpleStatement negatedTaken = fallThrough.getTargets().get(0);
                    Op03SimpleStatement sndIf = statements.get(x + 2);
                    Op03SimpleStatement sndTaken = sndIf.getTargets().get(1);
                    Op03SimpleStatement sndFallThrough = sndIf.getTargets().get(0);
                    retry = Op03SimpleStatement.condenseIfs(op03SimpleStatement, sndIf, negatedTaken, sndTaken, sndFallThrough, true);
                }
                if (!retry) continue;
                effect = true;
                while (statements.get(--x).isAgreedNop() && x > 0) {
                }
            } while (retry);
        }
        return effect;
    }

    private static boolean condenseIfs(Op03SimpleStatement if1, Op03SimpleStatement if2, Op03SimpleStatement taken1, Op03SimpleStatement taken2, Op03SimpleStatement fall2, boolean negated1) {
        boolean negate1;
        BoolOp resOp;
        if (if2.sources.size() != 1) {
            return false;
        }
        if (taken1 == fall2) {
            resOp = BoolOp.AND;
            negate1 = true;
        } else if (taken1 == taken2) {
            resOp = BoolOp.OR;
            negate1 = false;
        } else {
            Statement fall2stm = fall2.getStatement();
            if (fall2stm.getClass() == GotoStatement.class && fall2.getTargets().get(0) == taken1) {
                resOp = BoolOp.AND;
                negate1 = true;
            } else {
                return false;
            }
        }
        ConditionalExpression cond1 = ((IfStatement)if1.getStatement()).getCondition();
        ConditionalExpression cond2 = ((IfStatement)if2.getStatement()).getCondition();
        if (negated1) {
            boolean bl = negate1 = !negate1;
        }
        if (negate1) {
            cond1 = cond1.getNegated();
        }
        ConditionalExpression combined = new BooleanOperation(cond1, cond2, resOp);
        combined = combined.simplify();
        if2.replaceStatement(new IfStatement(combined));
        for (Op03SimpleStatement target1 : if1.getTargets()) {
            target1.removeSource(if1);
        }
        if1.targets.clear();
        for (Op03SimpleStatement source1 : if2.getSources()) {
            source1.removeGotoTarget(if2);
        }
        if2.sources.clear();
        if1.targets.add(if2);
        if2.sources.add(if1);
        if1.nopOutConditional();
        return true;
    }

    public static void simplifyConditionals(List<Op03SimpleStatement> statements, boolean aggressive) {
        for (Op03SimpleStatement statement : statements) {
            statement.simplifyConditional();
        }
        if (aggressive) {
            ConditionalSimplifyingRewriter conditionalSimplifier = new ConditionalSimplifyingRewriter();
            for (Op03SimpleStatement statement : statements) {
                statement.rewrite(conditionalSimplifier);
            }
        }
    }

    public static boolean condenseConditionals2(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> ifStatements = Functional.filter(statements, new TypeFilter<IfStatement>(IfStatement.class));
        boolean result = false;
        for (Op03SimpleStatement ifStatement : ifStatements) {
            if (Op03SimpleStatement.condenseConditional2_type1(ifStatement, statements)) {
                result = true;
                continue;
            }
            if (Op03SimpleStatement.condenseConditional2_type2(ifStatement)) {
                result = true;
                continue;
            }
            if (!Op03SimpleStatement.condenseConditional2_type3(ifStatement, statements)) continue;
            result = true;
        }
        return result;
    }

    private static boolean normalizeDupAssigns_type1(Op03SimpleStatement stm) {
        Statement inner1 = stm.getStatement();
        if (!(inner1 instanceof AssignmentSimple)) {
            return false;
        }
        List<Op03SimpleStatement> tgts = stm.getTargets();
        if (tgts.size() != 1) {
            return false;
        }
        Op03SimpleStatement next = tgts.get(0);
        Statement inner2 = next.getStatement();
        if (!(inner2 instanceof AssignmentSimple)) {
            return false;
        }
        if (next.getTargets().size() != 1) {
            return false;
        }
        Op03SimpleStatement after = next.getTargets().get(0);
        if (!(after.getStatement() instanceof IfStatement)) {
            return false;
        }
        AssignmentSimple a1 = (AssignmentSimple)inner1;
        AssignmentSimple a2 = (AssignmentSimple)inner2;
        LValue l1 = a1.getCreatedLValue();
        LValue l2 = a2.getCreatedLValue();
        Expression r1 = a1.getRValue();
        Expression r2 = a2.getRValue();
        if (!(r2 instanceof StackValue)) {
            return false;
        }
        StackSSALabel s2 = ((StackValue)r2).getStackValue();
        if (!l1.equals(s2)) {
            return false;
        }
        next.nopOut();
        stm.ssaIdentifiers = next.ssaIdentifiers;
        stm.replaceStatement(new AssignmentSimple(l1, new AssignmentExpression(l2, r1)));
        return true;
    }

    public static boolean normalizeDupAssigns(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> assignStatements = Functional.filter(statements, new TypeFilter<AssignmentSimple>(AssignmentSimple.class));
        boolean result = false;
        for (Op03SimpleStatement assign : assignStatements) {
            if (!Op03SimpleStatement.normalizeDupAssigns_type1(assign)) continue;
            result = true;
        }
        return result;
    }

    private static void replaceReturningIf(Op03SimpleStatement ifStatement, boolean aggressive) {
        Op03SimpleStatement next;
        boolean requireJustOneSource;
        Op03SimpleStatement tgt;
        if (ifStatement.containedStatement.getClass() != IfStatement.class) {
            return;
        }
        IfStatement innerIf = (IfStatement)ifStatement.containedStatement;
        Op03SimpleStatement origtgt = tgt = ifStatement.getTargets().get(1);
        boolean bl = requireJustOneSource = !aggressive;
        while ((next = Misc.followNopGoto(tgt, requireJustOneSource, aggressive)) != tgt) {
            tgt = next;
        }
        Statement tgtStatement = tgt.containedStatement;
        if (!(tgtStatement instanceof ReturnStatement)) {
            return;
        }
        ifStatement.replaceStatement(new IfExitingStatement(innerIf.getCondition(), tgtStatement));
        origtgt.removeSource(ifStatement);
        ifStatement.removeTarget(origtgt);
    }

    public static void replaceReturningIfs(List<Op03SimpleStatement> statements, boolean aggressive) {
        List<Op03SimpleStatement> ifStatements = Functional.filter(statements, new TypeFilter<IfStatement>(IfStatement.class));
        for (Op03SimpleStatement ifStatement : ifStatements) {
            Op03SimpleStatement.replaceReturningIf(ifStatement, aggressive);
        }
    }

    public static void propagateToReturn2(List<Op03SimpleStatement> statements) {
        boolean success = false;
        for (Op03SimpleStatement stm : statements) {
            Statement inner = stm.getStatement();
            if (!(inner instanceof ReturnStatement)) continue;
            success |= Op03SimpleStatement.pushReturnBack(stm);
        }
        if (success) {
            Op03SimpleStatement.replaceReturningIfs(statements, true);
        }
    }

    private static boolean pushReturnBack(Op03SimpleStatement returnStm) {
        ReturnStatement returnStatement = (ReturnStatement)returnStm.getStatement();
        final List<Op03SimpleStatement> replaceWithReturn = ListFactory.newList();
        new GraphVisitorDFS<Op03SimpleStatement>(returnStm.getSources(), new BinaryProcedure<Op03SimpleStatement, GraphVisitor<Op03SimpleStatement>>(){

            @Override
            public void call(Op03SimpleStatement arg1, GraphVisitor<Op03SimpleStatement> arg2) {
                Class<?> clazz = arg1.getStatement().getClass();
                if (clazz == CommentStatement.class || clazz == Nop.class || clazz == DoStatement.class) {
                    arg2.enqueue(arg1.getSources());
                } else if (clazz == WhileStatement.class) {
                    WhileStatement whileStatement = (WhileStatement)arg1.getStatement();
                    if (whileStatement.getCondition() == null) {
                        arg2.enqueue(arg1.getSources());
                        replaceWithReturn.add(arg1);
                    }
                } else if (clazz == GotoStatement.class) {
                    arg2.enqueue(arg1.getSources());
                    replaceWithReturn.add(arg1);
                }
            }
        }).process();
        if (replaceWithReturn.isEmpty()) {
            return false;
        }
        CloneHelper cloneHelper = new CloneHelper();
        for (Op03SimpleStatement remove : replaceWithReturn) {
            remove.replaceStatement((Statement)returnStatement.deepClone(cloneHelper));
            for (Op03SimpleStatement tgt : remove.getTargets()) {
                tgt.removeSource(remove);
            }
            remove.targets.clear();
        }
        return true;
    }

    private static boolean condenseConditional2_type3(Op03SimpleStatement ifStatement, List<Op03SimpleStatement> allStatements) {
        Op03SimpleStatement s1c = ifStatement;
        Statement s1 = s1c.containedStatement;
        if (s1.getClass() != IfStatement.class) {
            return false;
        }
        Op03SimpleStatement s4c = ifStatement.targets.get(1);
        Op03SimpleStatement s2c = ifStatement.targets.get(0);
        Statement s2 = s2c.getStatement();
        if (s2.getClass() != IfStatement.class) {
            return false;
        }
        Statement s4 = s4c.getStatement();
        if (s4.getClass() != IfStatement.class) {
            return false;
        }
        Op03SimpleStatement s3c = s2c.targets.get(0);
        Statement s3 = s3c.getStatement();
        if (s3.getClass() != GotoStatement.class) {
            return false;
        }
        Op03SimpleStatement s5c = s2c.targets.get(1);
        Op03SimpleStatement y = s3c.targets.get(0);
        if (s4c.targets.get(1) != y) {
            return false;
        }
        if (s4c.targets.get(0) != s5c) {
            return false;
        }
        if (s2c.sources.size() != 1) {
            return false;
        }
        if (s3c.sources.size() != 1) {
            return false;
        }
        if (s4c.sources.size() != 1) {
            return false;
        }
        IfStatement is1 = (IfStatement)s1;
        IfStatement is2 = (IfStatement)s2;
        IfStatement is4 = (IfStatement)s4;
        BooleanExpression cond = new BooleanExpression(new TernaryExpression(is1.getCondition(), is4.getCondition(), is2.getCondition().getNegated()));
        s1c.replaceStatement(new IfStatement(cond));
        s1c.replaceTarget(s4c, y);
        y.replaceSource(s4c, s1c);
        s2c.replaceStatement(new GotoStatement());
        s2c.removeGotoTarget(s3c);
        s3c.removeSource(s2c);
        s3c.clear();
        s4c.clear();
        int idx = allStatements.indexOf(s1c);
        if (allStatements.size() > idx + 5 && allStatements.get(idx + 1) == s2c && allStatements.get(idx + 2) == s3c && allStatements.get(idx + 3) == s4c && allStatements.get(idx + 4) == s5c) {
            s5c.replaceSource(s2c, s1c);
            s1c.replaceTarget(s2c, s5c);
            s2c.clear();
        }
        return true;
    }

    private static boolean condenseConditional2_type2(Op03SimpleStatement ifStatement) {
        Statement innerStatement = ifStatement.getStatement();
        if (!(innerStatement instanceof IfStatement)) {
            return false;
        }
        IfStatement innerIf = (IfStatement)innerStatement;
        Op03SimpleStatement tgt1 = ifStatement.targets.get(0);
        Op03SimpleStatement tgt2 = ifStatement.targets.get(1);
        if (tgt1.sources.size() != 1) {
            return false;
        }
        if (tgt2.sources.size() != 1) {
            return false;
        }
        if (tgt1.targets.size() != 1) {
            return false;
        }
        if (tgt2.targets.size() != 1) {
            return false;
        }
        Op03SimpleStatement evTgt = tgt1.targets.get(0);
        evTgt = Misc.followNopGoto(evTgt, true, false);
        Op03SimpleStatement oneSource = tgt1;
        if (!evTgt.sources.contains(oneSource) && !evTgt.sources.contains(oneSource = oneSource.targets.get(0))) {
            return false;
        }
        if (evTgt.sources.size() < 2) {
            return false;
        }
        if (tgt2.targets.get(0) != evTgt) {
            return false;
        }
        Statement stm1 = tgt1.getStatement();
        Statement stm2 = tgt2.getStatement();
        if (!(stm1 instanceof AssignmentSimple) || !(stm2 instanceof AssignmentSimple)) {
            return false;
        }
        AssignmentSimple a1 = (AssignmentSimple)stm1;
        AssignmentSimple a2 = (AssignmentSimple)stm2;
        LValue lv = a1.getCreatedLValue();
        if (!lv.equals(a2.getCreatedLValue())) {
            return false;
        }
        ConditionalExpression condition = innerIf.getCondition().getNegated();
        condition = condition.simplify();
        ifStatement.replaceStatement(new AssignmentSimple(lv, new TernaryExpression(condition, a1.getRValue(), a2.getRValue())));
        ifStatement.getSSAIdentifiers().consumeEntry(evTgt.getSSAIdentifiers());
        oneSource.replaceStatement(new Nop());
        oneSource.removeTarget(evTgt);
        tgt2.replaceStatement(new Nop());
        tgt2.removeTarget(evTgt);
        evTgt.removeSource(oneSource);
        evTgt.removeSource(tgt2);
        evTgt.sources.add(ifStatement);
        for (Op03SimpleStatement tgt : ifStatement.targets) {
            tgt.removeSource(ifStatement);
        }
        ifStatement.targets.clear();
        ifStatement.addTarget(evTgt);
        tgt1.replaceStatement(new Nop());
        if (lv instanceof StackSSALabel) {
            ((StackSSALabel)lv).getStackEntry().decSourceCount();
        }
        return true;
    }

    private static boolean condenseConditional2_type1(Op03SimpleStatement ifStatement, List<Op03SimpleStatement> allStatements) {
        block14: {
            Op03SimpleStatement next;
            Op03SimpleStatement nontaken3rewrite;
            Op03SimpleStatement nontaken2rewrite;
            Op03SimpleStatement nottaken2;
            if (!(ifStatement.containedStatement instanceof IfStatement)) {
                return false;
            }
            Op03SimpleStatement taken1 = ifStatement.getTargets().get(1);
            Op03SimpleStatement nottaken1 = ifStatement.getTargets().get(0);
            if (!(nottaken1.containedStatement instanceof IfStatement)) {
                return false;
            }
            Op03SimpleStatement ifStatement2 = nottaken1;
            Op03SimpleStatement taken2 = ifStatement2.getTargets().get(1);
            Op03SimpleStatement nottaken2Immed = nottaken2 = ifStatement2.getTargets().get(0);
            if (nottaken2Immed.sources.size() != 1) {
                return false;
            }
            nottaken2 = Misc.followNopGotoChain(nottaken2, true, false);
            while ((nontaken2rewrite = Misc.followNopGoto(nottaken2, true, false)) != nottaken2) {
                nottaken2 = nontaken2rewrite;
            }
            if (!(taken1.containedStatement instanceof IfStatement)) {
                return false;
            }
            if (taken1.sources.size() != 1) {
                return false;
            }
            Op03SimpleStatement ifStatement3 = taken1;
            Op03SimpleStatement taken3 = ifStatement3.getTargets().get(1);
            Op03SimpleStatement nottaken3 = ifStatement3.getTargets().get(0);
            Op03SimpleStatement notTaken3Source = ifStatement3;
            while ((nontaken3rewrite = Misc.followNopGoto(nottaken3, true, false)) != nottaken3) {
                notTaken3Source = nottaken3;
                nottaken3 = nontaken3rewrite;
            }
            if (nottaken2 != nottaken3) {
                if (nottaken2.getStatement() instanceof ReturnStatement) {
                    if (!nottaken2.getStatement().equivalentUnder(nottaken3.getStatement(), new StatementEquivalenceConstraint(nottaken2, nottaken3))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (taken2 != taken3) {
                return false;
            }
            IfStatement if1 = (IfStatement)ifStatement.containedStatement;
            IfStatement if2 = (IfStatement)ifStatement2.containedStatement;
            IfStatement if3 = (IfStatement)ifStatement3.containedStatement;
            ConditionalExpression newCond = new BooleanExpression(new TernaryExpression(if1.getCondition().getNegated().simplify(), if2.getCondition().getNegated().simplify(), if3.getCondition().getNegated().simplify())).getNegated();
            ifStatement.replaceTarget(taken1, taken3);
            taken3.addSource(ifStatement);
            taken3.removeSource(ifStatement2);
            taken3.removeSource(ifStatement3);
            nottaken1.sources.remove(ifStatement);
            nottaken2Immed.replaceSource(ifStatement2, ifStatement);
            ifStatement.replaceTarget(nottaken1, nottaken2Immed);
            nottaken3.removeSource(notTaken3Source);
            ifStatement2.replaceStatement(new Nop());
            ifStatement3.replaceStatement(new Nop());
            ifStatement2.removeTarget(taken3);
            ifStatement3.removeTarget(taken3);
            ifStatement.replaceStatement(new IfStatement(newCond));
            if (nottaken2Immed.sources.size() != 1 || !nottaken2Immed.sources.get(0).getIndex().isBackJumpFrom(nottaken2Immed) || nottaken2Immed.containedStatement.getClass() != GotoStatement.class) break block14;
            Op03SimpleStatement nottaken2ImmedTgt = nottaken2Immed.targets.get(0);
            int idx = allStatements.indexOf(nottaken2Immed);
            int idx2 = idx + 1;
            while (true) {
                next = allStatements.get(idx2);
                if (!(next.containedStatement instanceof Nop)) break;
                ++idx2;
            }
            if (next == nottaken2ImmedTgt) {
                nottaken2ImmedTgt.replaceSource(nottaken2Immed, ifStatement);
                ifStatement.replaceTarget(nottaken2Immed, nottaken2ImmedTgt);
            }
        }
        return true;
    }

    private static boolean appropriateForIfAssignmentCollapse1(Op03SimpleStatement statement) {
        boolean extraCondSeen = false;
        boolean preCondAssignmentSeen = false;
        while (statement.sources.size() == 1) {
            Op03SimpleStatement source = statement.sources.get(0);
            if (statement.getIndex().isBackJumpFrom(source)) break;
            Statement contained = source.containedStatement;
            if (contained instanceof AbstractAssignment) {
                preCondAssignmentSeen |= !extraCondSeen;
            } else {
                if (!(contained instanceof IfStatement)) break;
                extraCondSeen = true;
            }
            statement = source;
        }
        if (!preCondAssignmentSeen) {
            return false;
        }
        if (extraCondSeen) {
            return false;
        }
        InstrIndex statementIndex = statement.getIndex();
        for (Op03SimpleStatement source : statement.sources) {
            if (!statementIndex.isBackJumpFrom(source)) continue;
            return true;
        }
        return false;
    }

    private static boolean appropriateForIfAssignmentCollapse2(Op03SimpleStatement statement) {
        Op03SimpleStatement source;
        boolean preCondAssignmentSeen = false;
        while (statement.sources.size() == 1 && (source = statement.sources.get(0)).getTargets().size() == 1) {
            Statement contained = source.containedStatement;
            if (contained instanceof AbstractAssignment) {
                preCondAssignmentSeen = true;
            }
            statement = source;
        }
        return preCondAssignmentSeen;
    }

    private static void collapseAssignmentsIntoConditional(Op03SimpleStatement ifStatement, boolean testEclipse) {
        ConditionalExpression conditionalExpression;
        IfStatement innerIf;
        block15: {
            boolean eclipseHeuristic;
            if (!Op03SimpleStatement.appropriateForIfAssignmentCollapse1(ifStatement) && !Op03SimpleStatement.appropriateForIfAssignmentCollapse2(ifStatement)) {
                return;
            }
            innerIf = (IfStatement)ifStatement.containedStatement;
            conditionalExpression = innerIf.getCondition();
            boolean bl = eclipseHeuristic = testEclipse && ifStatement.getTargets().get(1).getIndex().isBackJumpFrom(ifStatement);
            if (!eclipseHeuristic) {
                Statement opStatement;
                Op03SimpleStatement statement = ifStatement;
                Set visited = SetFactory.newSet();
                do {
                    if (statement.sources.size() > 1) {
                        InstrIndex statementIndex = statement.index;
                        for (Op03SimpleStatement source : statement.sources) {
                            if (!statementIndex.isBackJumpFrom(source)) continue;
                            break block15;
                        }
                    }
                    if (statement.sources.isEmpty()) break block15;
                    statement = statement.sources.get(0);
                    if (!visited.add(statement)) {
                        return;
                    }
                    opStatement = statement.getStatement();
                    if (opStatement instanceof IfStatement) break block15;
                } while (opStatement instanceof Nop || opStatement instanceof AbstractAssignment);
                return;
            }
        }
        Op03SimpleStatement previousSource = null;
        while (ifStatement.sources.size() == 1) {
            Op03SimpleStatement source = ifStatement.sources.get(0);
            if (source == previousSource) {
                return;
            }
            previousSource = source;
            if (!(source.containedStatement instanceof AbstractAssignment)) {
                return;
            }
            LValue lValue = source.getCreatedLValue();
            if (lValue instanceof StackSSALabel) {
                return;
            }
            LValueUsageCollectorSimple lvc = new LValueUsageCollectorSimple();
            conditionalExpression.collectUsedLValues(lvc);
            if (!lvc.isUsed(lValue)) {
                return;
            }
            AbstractAssignment assignment = (AbstractAssignment)source.containedStatement;
            AbstractAssignmentExpression assignmentExpression = assignment.getInliningExpression();
            LValueUsageCollectorSimple assignmentLVC = new LValueUsageCollectorSimple();
            assignmentExpression.collectUsedLValues(assignmentLVC);
            Set<LValue> used = SetFactory.newSet(assignmentLVC.getUsedLValues());
            used.remove(lValue);
            Set<LValue> usedComparison = SetFactory.newSet(lvc.getUsedLValues());
            SSAIdentifiers<LValue> beforeSSA = source.getSSAIdentifiers();
            SSAIdentifiers<LValue> afterSSA = ifStatement.getSSAIdentifiers();
            Set<LValue> intersection = SetUtil.intersectionOrNull(used, usedComparison);
            if (intersection != null) {
                for (LValue intersect : intersection) {
                    if (afterSSA.isValidReplacement(intersect, beforeSSA)) continue;
                    return;
                }
            }
            if (!afterSSA.isValidReplacement(lValue, beforeSSA)) {
                return;
            }
            LValueAssignmentExpressionRewriter rewriter = new LValueAssignmentExpressionRewriter(lValue, assignmentExpression, source);
            ConditionalExpression replacement = rewriter.rewriteExpression(conditionalExpression, ifStatement.getSSAIdentifiers(), (StatementContainer)ifStatement, ExpressionRewriterFlags.LVALUE);
            if (replacement == null) {
                return;
            }
            innerIf.setCondition(replacement);
        }
    }

    public static void collapseAssignmentsIntoConditionals(List<Op03SimpleStatement> statements, Options options) {
        List<Op03SimpleStatement> ifStatements = Functional.filter(statements, new TypeFilter<IfStatement>(IfStatement.class));
        boolean testEclipse = (Boolean)options.getOption(OptionsImpl.ECLIPSE);
        for (Op03SimpleStatement statement : ifStatements) {
            Op03SimpleStatement.collapseAssignmentsIntoConditional(statement, testEclipse);
        }
    }

    private static boolean movableJump(JumpType jumpType) {
        switch (jumpType) {
            case BREAK: 
            case GOTO_OUT_OF_IF: 
            case CONTINUE: {
                return false;
            }
        }
        return true;
    }

    public static void removePointlessJumps(List<Op03SimpleStatement> statements) {
        Statement innerStatement;
        int x;
        int size = statements.size() - 1;
        for (x = 0; x < size - 1; ++x) {
            Op03SimpleStatement a = statements.get(x);
            Op03SimpleStatement b = statements.get(x + 1);
            if (a.containedStatement.getClass() != GotoStatement.class || b.containedStatement.getClass() != GotoStatement.class || a.targets.get(0) != b.targets.get(0) || !a.getBlockIdentifiers().equals(b.getBlockIdentifiers())) continue;
            Op03SimpleStatement realTgt = a.targets.get(0);
            realTgt.removeSource(a);
            a.replaceTarget(realTgt, b);
            b.addSource(a);
            a.nopOut();
        }
        for (x = 0; x < size - 1; ++x) {
            Op03SimpleStatement maybeJump = statements.get(x);
            if (maybeJump.containedStatement.getClass() != GotoStatement.class || maybeJump.getJumpType() == JumpType.BREAK || maybeJump.targets.size() != 1 || maybeJump.targets.get(0) != statements.get(x + 1)) continue;
            if (maybeJump.getBlockIdentifiers().equals(statements.get(x + 1).getBlockIdentifiers())) {
                maybeJump.nopOut();
                continue;
            }
            Set<BlockIdentifier> changes = SetUtil.difference(maybeJump.getBlockIdentifiers(), statements.get(x + 1).getBlockIdentifiers());
            boolean ok = true;
            for (BlockIdentifier change : changes) {
                if (!change.getBlockType().isLoop()) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            maybeJump.nopOut();
        }
        for (Op03SimpleStatement statement : statements) {
            JumpingStatement jumpInnerPrior;
            Statement jumpingInnerPriorTarget;
            Op03SimpleStatement prior;
            Statement innerPrior;
            innerStatement = statement.getStatement();
            if (!(innerStatement instanceof JumpingStatement) || statement.getSources().size() != 1 || statement.getTargets().size() != 1 || !((innerPrior = (prior = statement.getSources().get(0)).getStatement()) instanceof JumpingStatement) || (jumpingInnerPriorTarget = (jumpInnerPrior = (JumpingStatement)innerPrior).getJumpTarget()) != innerStatement || !Op03SimpleStatement.movableJump(jumpInnerPrior.getJumpType())) continue;
            statement.nopOut();
        }
        for (int x2 = statements.size() - 1; x2 >= 0; --x2) {
            IfStatement ifStatement;
            Op03SimpleStatement ultimateTarget;
            Op03SimpleStatement target;
            Op03SimpleStatement statement;
            statement = statements.get(x2);
            innerStatement = statement.getStatement();
            if (innerStatement.getClass() == GotoStatement.class) {
                GotoStatement innerGoto = (GotoStatement)innerStatement;
                if (innerGoto.getJumpType() == JumpType.BREAK || (target = statement.targets.get(0)) == (ultimateTarget = Misc.followNopGotoChain(target, false, false))) continue;
                ultimateTarget = Op03SimpleStatement.maybeMoveTarget(ultimateTarget, statement, statements);
                target.removeSource(statement);
                statement.replaceTarget(target, ultimateTarget);
                ultimateTarget.addSource(statement);
                continue;
            }
            if (innerStatement.getClass() != IfStatement.class || !Op03SimpleStatement.movableJump((ifStatement = (IfStatement)innerStatement).getJumpType()) || (target = statement.targets.get(1)) == (ultimateTarget = Misc.followNopGotoChain(target, false, false))) continue;
            ultimateTarget = Op03SimpleStatement.maybeMoveTarget(ultimateTarget, statement, statements);
            target.removeSource(statement);
            statement.replaceTarget(target, ultimateTarget);
            ultimateTarget.addSource(statement);
        }
    }

    private static void extractExceptionJumps(Op03SimpleStatement tryi, List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tryTargets = tryi.getTargets();
        Op03SimpleStatement uniqueForwardTarget = null;
        Set relevantBlocks = SetFactory.newSet();
        Op03SimpleStatement lastEnd = null;
        int lpidx = 0;
        for (Op03SimpleStatement tgt : tryTargets) {
            Object block;
            if ((block = Op03SimpleStatement.getBlockStart((lpidx++ == 0 ? tryi : tgt).getStatement())) == null) {
                return;
            }
            relevantBlocks.add(block);
            Op03SimpleStatement op03SimpleStatement = Op03SimpleStatement.getLastContiguousBlockStatement((BlockIdentifier)block, in, tgt);
            if (op03SimpleStatement == null) {
                return;
            }
            if (op03SimpleStatement.getStatement().getClass() == GotoStatement.class) {
                Op03SimpleStatement lastTgt = op03SimpleStatement.getTargets().get(0);
                if (uniqueForwardTarget == null) {
                    uniqueForwardTarget = lastTgt;
                } else if (uniqueForwardTarget != lastTgt) {
                    return;
                }
            }
            lastEnd = op03SimpleStatement;
        }
        if (uniqueForwardTarget == null) {
            return;
        }
        if (!uniqueForwardTarget.getBlockIdentifiers().equals(tryi.getBlockIdentifiers())) {
            return;
        }
        int idx = in.indexOf(lastEnd);
        if (idx >= in.size() - 1) {
            return;
        }
        Op03SimpleStatement next = in.get(idx + 1);
        if (next == uniqueForwardTarget) {
            return;
        }
        for (Op03SimpleStatement op03SimpleStatement : next.getSources()) {
            if (!SetUtil.hasIntersection(op03SimpleStatement.getBlockIdentifiers(), relevantBlocks)) continue;
            return;
        }
        LinkedList<Op03SimpleStatement> blockSources = ListFactory.newLinkedList();
        for (Op03SimpleStatement source : uniqueForwardTarget.getSources()) {
            if (!SetUtil.hasIntersection(source.getBlockIdentifiers(), relevantBlocks)) continue;
            blockSources.add(source);
        }
        Op03SimpleStatement op03SimpleStatement = new Op03SimpleStatement(next.getBlockIdentifiers(), new GotoStatement(), next.getIndex().justBefore());
        for (Op03SimpleStatement source : blockSources) {
            Statement srcStatement = source.getStatement();
            if (srcStatement instanceof GotoStatement) {
                ((GotoStatement)srcStatement).setJumpType(JumpType.GOTO_OUT_OF_TRY);
            }
            uniqueForwardTarget.removeSource(source);
            source.replaceTarget(uniqueForwardTarget, op03SimpleStatement);
            op03SimpleStatement.addSource(source);
        }
        op03SimpleStatement.addTarget(uniqueForwardTarget);
        uniqueForwardTarget.addSource(op03SimpleStatement);
        in.add(idx + 1, op03SimpleStatement);
    }

    private static BlockIdentifier getBlockStart(Statement statement) {
        Class<?> clazz = statement.getClass();
        if (clazz == TryStatement.class) {
            TryStatement tryStatement = (TryStatement)statement;
            return tryStatement.getBlockIdentifier();
        }
        if (clazz == CatchStatement.class) {
            CatchStatement catchStatement = (CatchStatement)statement;
            return catchStatement.getCatchBlockIdent();
        }
        if (clazz == FinallyStatement.class) {
            FinallyStatement finallyStatement = (FinallyStatement)statement;
            return finallyStatement.getFinallyBlockIdent();
        }
        return null;
    }

    public static void extractExceptionJumps(List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tries = Functional.filter(in, new TypeFilter<TryStatement>(TryStatement.class));
        for (Op03SimpleStatement tryi : tries) {
            Op03SimpleStatement.extractExceptionJumps(tryi, in);
        }
    }

    public static void extractAssertionJumps(List<Op03SimpleStatement> in) {
        WildcardMatch wcm = new WildcardMatch();
        ThrowStatement assertionError = new ThrowStatement(wcm.getConstructorSimpleWildcard("exception", TypeConstants.ASSERTION_ERROR));
        int len = in.size();
        for (int x = 0; x < len; ++x) {
            Op03SimpleStatement next;
            IfStatement ifStatement;
            Op03SimpleStatement ostm = in.get(x);
            Statement stm = ostm.getStatement();
            if (stm.getClass() != IfStatement.class || (ifStatement = (IfStatement)stm).getJumpType() == JumpType.GOTO || (next = in.get(x + 1)).getSources().size() != 1) continue;
            wcm.reset();
            if (!((Object)assertionError).equals(next.getStatement()) || !ostm.getBlockIdentifiers().equals(next.getBlockIdentifiers())) continue;
            GotoStatement reJumpStm = new GotoStatement();
            reJumpStm.setJumpType(ifStatement.getJumpType());
            Op03SimpleStatement reJump = new Op03SimpleStatement(ostm.getBlockIdentifiers(), reJumpStm, next.getIndex().justAfter());
            in.add(x + 2, reJump);
            Op03SimpleStatement origTarget = ostm.getTargets().get(1);
            ostm.replaceTarget(origTarget, reJump);
            reJump.addSource(ostm);
            origTarget.replaceSource(ostm, reJump);
            reJump.addTarget(origTarget);
            ifStatement.setJumpType(JumpType.GOTO);
            ++len;
        }
    }

    private static LinearScannedBlock getLinearScannedBlock(List<Op03SimpleStatement> statements, int idx, Op03SimpleStatement stm, BlockIdentifier blockIdentifier, boolean prefix) {
        Op03SimpleStatement nstm;
        Set found = SetFactory.newSet();
        int nextIdx = idx + (prefix ? 1 : 0);
        if (prefix) {
            found.add(stm);
        }
        int cnt = statements.size();
        while ((nstm = statements.get(nextIdx)).getBlockIdentifiers().contains(blockIdentifier)) {
            found.add(nstm);
            if (++nextIdx < cnt) continue;
        }
        Set<Op03SimpleStatement> reachable = Misc.GraphVisitorBlockReachable.getBlockReachable(stm, blockIdentifier);
        if (!reachable.equals(found)) {
            return null;
        }
        --nextIdx;
        if (reachable.isEmpty()) {
            return null;
        }
        return new LinearScannedBlock(stm, statements.get(nextIdx), idx, nextIdx);
    }

    private static SingleExceptionAddressing getSingleTryCatch(Op03SimpleStatement trystm, List<Op03SimpleStatement> statements) {
        TryStatement tryStatement;
        BlockIdentifier tryBlockIdent;
        int idx = statements.indexOf(trystm);
        LinearScannedBlock tryBlock = Op03SimpleStatement.getLinearScannedBlock(statements, idx, trystm, tryBlockIdent = (tryStatement = (TryStatement)trystm.getStatement()).getBlockIdentifier(), true);
        if (tryBlock == null) {
            return null;
        }
        Op03SimpleStatement catchs = trystm.getTargets().get(1);
        Statement testCatch = catchs.getStatement();
        if (!(testCatch instanceof CatchStatement)) {
            return null;
        }
        CatchStatement catchStatement = (CatchStatement)testCatch;
        BlockIdentifier catchBlockIdent = catchStatement.getCatchBlockIdent();
        LinearScannedBlock catchBlock = Op03SimpleStatement.getLinearScannedBlock(statements, statements.indexOf(catchs), catchs, catchBlockIdent, true);
        if (catchBlock == null) {
            return null;
        }
        if (!catchBlock.isAfter(tryBlock)) {
            return null;
        }
        return new SingleExceptionAddressing(tryBlockIdent, catchBlockIdent, tryBlock, catchBlock);
    }

    private static boolean extractExceptionMiddle(Op03SimpleStatement trystm, List<Op03SimpleStatement> statements, SingleExceptionAddressing trycatch) {
        Op03SimpleStatement stm;
        int x;
        LinearScannedBlock tryBlock = trycatch.tryBlock;
        LinearScannedBlock catchBlock = trycatch.catchBlock;
        BlockIdentifier tryBlockIdent = trycatch.tryBlockIdent;
        BlockIdentifier catchBlockIdent = trycatch.catchBlockIdent;
        int catchLast = catchBlock.getIdxLast();
        if (catchLast < statements.size() - 1) {
            Op03SimpleStatement afterCatchBlock = statements.get(catchLast + 1);
            for (Op03SimpleStatement source : afterCatchBlock.getSources()) {
                if (!source.getBlockIdentifiers().contains(catchBlockIdent)) continue;
                return false;
            }
        }
        if (catchBlock.immediatelyFollows(tryBlock)) {
            return false;
        }
        Set<BlockIdentifier> expected = trystm.getBlockIdentifiers();
        Set middle = SetFactory.newSet();
        List<Op03SimpleStatement> toMove = ListFactory.newList();
        for (x = tryBlock.getIdxLast() + 1; x < catchBlock.getIdxFirst(); ++x) {
            stm = statements.get(x);
            middle.add(stm);
            toMove.add(stm);
        }
        for (x = tryBlock.getIdxLast() + 1; x < catchBlock.getIdxFirst(); ++x) {
            stm = statements.get(x);
            if (!stm.getBlockIdentifiers().containsAll(expected)) {
                return false;
            }
            for (Op03SimpleStatement source : stm.getSources()) {
                Set<BlockIdentifier> sourceBlocks;
                if (!source.getIndex().isBackJumpTo(stm) || (sourceBlocks = source.getBlockIdentifiers()).contains(tryBlockIdent) || sourceBlocks.contains(catchBlockIdent)) continue;
                return false;
            }
        }
        InstrIndex afterIdx = catchBlock.getLast().getIndex().justAfter();
        for (Op03SimpleStatement move : toMove) {
            move.setIndex(afterIdx);
            afterIdx = afterIdx.justAfter();
        }
        return true;
    }

    private static void extractCatchEnd(List<Op03SimpleStatement> statements, SingleExceptionAddressing trycatch) {
        LinearScannedBlock tryBlock = trycatch.tryBlock;
        BlockIdentifier tryBlockIdent = trycatch.tryBlockIdent;
        BlockIdentifier catchBlockIdent = trycatch.catchBlockIdent;
        Op03SimpleStatement possibleAfterBlock = null;
        if (trycatch.catchBlock.getIdxLast() < statements.size() - 1) {
            Op03SimpleStatement afterCatch = statements.get(trycatch.catchBlock.getIdxLast() + 1);
            for (Op03SimpleStatement op03SimpleStatement : afterCatch.getSources()) {
                if (!op03SimpleStatement.getBlockIdentifiers().contains(tryBlockIdent)) continue;
                return;
            }
        }
        for (int x = tryBlock.getIdxFirst() + 1; x <= tryBlock.getIdxLast(); ++x) {
            List<Op03SimpleStatement> targets = statements.get(x).getTargets();
            for (Op03SimpleStatement target : targets) {
                if (!target.getBlockIdentifiers().contains(catchBlockIdent)) continue;
                if (possibleAfterBlock == null) {
                    possibleAfterBlock = target;
                    continue;
                }
                if (target == possibleAfterBlock) continue;
                return;
            }
        }
        if (possibleAfterBlock == null) {
            return;
        }
        Set<BlockIdentifier> tryStartBlocks = trycatch.tryBlock.getFirst().getBlockIdentifiers();
        Set<BlockIdentifier> possibleBlocks = possibleAfterBlock.getBlockIdentifiers();
        if (possibleBlocks.size() != tryStartBlocks.size() + 1) {
            return;
        }
        if (!possibleBlocks.containsAll(tryStartBlocks)) {
            return;
        }
        if (!possibleBlocks.contains(catchBlockIdent)) {
            return;
        }
        int n = statements.indexOf(possibleAfterBlock);
        LinearScannedBlock unmarkBlock = Op03SimpleStatement.getLinearScannedBlock(statements, n, possibleAfterBlock, catchBlockIdent, false);
        if (unmarkBlock == null) {
            return;
        }
        for (int x = unmarkBlock.getIdxFirst(); x <= unmarkBlock.getIdxLast(); ++x) {
            statements.get(x).getBlockIdentifiers().remove(catchBlockIdent);
        }
    }

    public static void extractExceptionMiddle(List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tryStatements = Functional.filter(in, new ExactTypeFilter<TryStatement>(TryStatement.class));
        if (tryStatements.isEmpty()) {
            return;
        }
        Collections.reverse(tryStatements);
        for (Op03SimpleStatement tryStatement : tryStatements) {
            SingleExceptionAddressing trycatch;
            if (tryStatement.getTargets().size() != 2 || (trycatch = Op03SimpleStatement.getSingleTryCatch(tryStatement, in)) == null) continue;
            if (Op03SimpleStatement.extractExceptionMiddle(tryStatement, in, trycatch)) {
                Cleaner.sortAndRenumberInPlace(in);
                trycatch.tryBlock.reindex(in);
                trycatch.catchBlock.reindex(in);
            }
            Op03SimpleStatement.extractCatchEnd(in, trycatch);
        }
    }

    private static Op03SimpleStatement maybeMoveTarget(Op03SimpleStatement expectedRetarget, Op03SimpleStatement source, List<Op03SimpleStatement> statements) {
        int startIdx;
        if (expectedRetarget.getBlockIdentifiers().equals(source.getBlockIdentifiers())) {
            return expectedRetarget;
        }
        int idx = startIdx = statements.indexOf(expectedRetarget);
        Op03SimpleStatement maybe = null;
        while (idx > 0 && statements.get(--idx).getStatement() instanceof TryStatement && !(maybe = statements.get(idx)).getBlockIdentifiers().equals(source.getBlockIdentifiers())) {
        }
        if (maybe == null) {
            return expectedRetarget;
        }
        return maybe;
    }

    public static void rewriteNegativeJumps(List<Op03SimpleStatement> statements, boolean requireChainedConditional) {
        List removeThese = ListFactory.newList();
        for (int x = 0; x < statements.size() - 2; ++x) {
            Op03SimpleStatement yStatement;
            Statement innerZStatement;
            Op03SimpleStatement aStatement = statements.get(x);
            Statement innerAStatement = aStatement.getStatement();
            if (!(innerAStatement instanceof IfStatement)) continue;
            Op03SimpleStatement zStatement = statements.get(x + 1);
            Op03SimpleStatement xStatement = statements.get(x + 2);
            if (requireChainedConditional && !(xStatement.getStatement() instanceof IfStatement) || aStatement.targets.get(0) != zStatement || aStatement.targets.get(1) != xStatement || (innerZStatement = zStatement.getStatement()).getClass() != GotoStatement.class || (yStatement = zStatement.targets.get(0)) == zStatement) continue;
            aStatement.replaceTarget(xStatement, yStatement);
            aStatement.replaceTarget(zStatement, xStatement);
            yStatement.replaceSource(zStatement, aStatement);
            zStatement.sources.clear();
            zStatement.targets.clear();
            zStatement.containedStatement = new Nop();
            removeThese.add(zStatement);
            IfStatement innerAIfStatement = (IfStatement)innerAStatement;
            innerAIfStatement.negateCondition();
        }
        statements.removeAll(removeThese);
    }

    private static Op03SimpleStatement getForInvariant(Op03SimpleStatement start, LValue invariant, BlockIdentifier whileLoop) {
        Op03SimpleStatement current = start;
        while (current.containedInBlocks.contains(whileLoop)) {
            Op03SimpleStatement next;
            AbstractAssignment assignment;
            LValue assigned;
            if (current.containedStatement instanceof AbstractAssignment && invariant.equals(assigned = (assignment = (AbstractAssignment)current.containedStatement).getCreatedLValue()) && assignment.isSelfMutatingOperation()) {
                return current;
            }
            if (current.sources.size() > 1 || !current.index.isBackJumpTo(next = current.sources.get(0))) break;
            current = next;
        }
        throw new ConfusedCFRException("Shouldn't be able to get here.");
    }

    private static Set<LValue> findForInvariants(Op03SimpleStatement start, BlockIdentifier whileLoop) {
        Set<LValue> res = SetFactory.newOrderedSet();
        Op03SimpleStatement current = start;
        while (current.containedInBlocks.contains(whileLoop)) {
            Op03SimpleStatement next;
            AbstractAssignment assignment;
            if (current.containedStatement instanceof AbstractAssignment && (assignment = (AbstractAssignment)current.containedStatement).isSelfMutatingOperation()) {
                res.add(assignment.getCreatedLValue());
            }
            if (current.sources.size() > 1 || !current.index.isBackJumpTo(next = current.sources.get(0))) break;
            current = next;
        }
        return res;
    }

    private static Op03SimpleStatement findMovableAssignment(Op03SimpleStatement start, LValue lValue) {
        Op03SimpleStatement current = Misc.findSingleBackSource(start);
        if (current == null) {
            return null;
        }
        do {
            AssignmentSimple assignmentSimple;
            if (current.containedStatement instanceof AssignmentSimple && (assignmentSimple = (AssignmentSimple)current.containedStatement).getCreatedLValue().equals(lValue)) {
                Expression rhs = assignmentSimple.getRValue();
                LValueUsageCollectorSimple lValueUsageCollector = new LValueUsageCollectorSimple();
                rhs.collectUsedLValues(lValueUsageCollector);
                if (SSAIdentifierUtils.isMovableUnder(lValueUsageCollector.getUsedLValues(), lValue, start.ssaIdentifiers, current.ssaIdentifiers)) {
                    return current;
                }
                logger.info("** incompatible sources");
                return null;
            }
            if (current.sources.size() == 1) continue;
            logger.info("** too many sources");
            return null;
        } while ((current = current.sources.get(0)) != null);
        return null;
    }

    private static List<Op03SimpleStatement> getMutations(List<Op03SimpleStatement> backSources, LValue loopVariable, BlockIdentifier whileBlockIdentifier) {
        List<Op03SimpleStatement> mutations = ListFactory.newList();
        for (Op03SimpleStatement source : backSources) {
            Op03SimpleStatement incrStatement = Op03SimpleStatement.getForInvariant(source, loopVariable, whileBlockIdentifier);
            mutations.add(incrStatement);
        }
        Op03SimpleStatement baseline = (Op03SimpleStatement)mutations.get(0);
        for (Op03SimpleStatement incrStatement : mutations) {
            if (baseline.equals(incrStatement)) continue;
            logger.info("Incompatible constant mutations.");
            return null;
        }
        return mutations;
    }

    private static void rewriteWhileAsFor(Op03SimpleStatement statement, boolean aggcapture) {
        List<Op03SimpleStatement> backSources = Functional.filter(statement.sources, new Misc.IsBackJumpTo(statement.index));
        WhileStatement whileStatement = (WhileStatement)statement.containedStatement;
        ConditionalExpression condition = whileStatement.getCondition();
        Set<LValue> loopVariablePossibilities = condition.getLoopLValues();
        if (loopVariablePossibilities.isEmpty()) {
            logger.info("No loop variable possibilities\n");
            return;
        }
        BlockIdentifier whileBlockIdentifier = whileStatement.getBlockIdentifier();
        Set<LValue> reverseOrderedMutatedPossibilities = null;
        for (Op03SimpleStatement source : backSources) {
            Set<LValue> incrPoss = Op03SimpleStatement.findForInvariants(source, whileBlockIdentifier);
            if (reverseOrderedMutatedPossibilities == null) {
                reverseOrderedMutatedPossibilities = incrPoss;
            } else {
                reverseOrderedMutatedPossibilities.retainAll(incrPoss);
            }
            if (!reverseOrderedMutatedPossibilities.isEmpty()) continue;
            logger.info("No invariant possibilities on source\n");
            return;
        }
        if (reverseOrderedMutatedPossibilities == null || reverseOrderedMutatedPossibilities.isEmpty()) {
            logger.info("No invariant intersection\n");
            return;
        }
        loopVariablePossibilities.retainAll(reverseOrderedMutatedPossibilities);
        if (loopVariablePossibilities.isEmpty()) {
            logger.info("No invariant intersection\n");
            return;
        }
        Op03SimpleStatement loopVariableOp = null;
        LValue loopVariable = null;
        for (LValue loopVariablePoss : loopVariablePossibilities) {
            Op03SimpleStatement initialValue = Op03SimpleStatement.findMovableAssignment(statement, loopVariablePoss);
            if (initialValue == null || loopVariableOp != null && !initialValue.getIndex().isBackJumpTo(loopVariableOp)) continue;
            loopVariableOp = initialValue;
            loopVariable = loopVariablePoss;
        }
        if (loopVariable == null) {
            return;
        }
        AssignmentSimple initalAssignmentSimple = null;
        List<AbstractAssignmentExpression> postUpdates = ListFactory.newList();
        List<List> usedMutatedPossibilities = ListFactory.newList();
        boolean usesLoopVar = false;
        for (LValue otherMutant : reverseOrderedMutatedPossibilities) {
            List<Op03SimpleStatement> othermutations = Op03SimpleStatement.getMutations(backSources, otherMutant, whileBlockIdentifier);
            if (othermutations == null) continue;
            if (!loopVariablePossibilities.contains(otherMutant) && !aggcapture) break;
            if (otherMutant.equals(loopVariable)) {
                usesLoopVar = true;
            }
            AbstractAssignmentExpression postUpdate2 = ((AbstractAssignment)((Op03SimpleStatement)othermutations.get(0)).getStatement()).getInliningExpression();
            postUpdates.add(postUpdate2);
            usedMutatedPossibilities.add(othermutations);
        }
        if (!usesLoopVar) {
            return;
        }
        Collections.reverse(postUpdates);
        for (List lst : usedMutatedPossibilities) {
            for (Op03SimpleStatement op : lst) {
                op.nopOut();
            }
        }
        if (loopVariableOp != null) {
            initalAssignmentSimple = (AssignmentSimple)loopVariableOp.containedStatement;
            loopVariableOp.nopOut();
        }
        whileBlockIdentifier.setBlockType(BlockType.FORLOOP);
        whileStatement.replaceWithForLoop(initalAssignmentSimple, postUpdates);
        for (Op03SimpleStatement source : backSources) {
            if (!source.containedInBlocks.contains(whileBlockIdentifier)) continue;
            List<Op03SimpleStatement> ssources = ListFactory.newList(source.getSources());
            for (Op03SimpleStatement ssource : ssources) {
                JumpingStatement jumpingStatement;
                Statement sstatement;
                if (!ssource.containedInBlocks.contains(whileBlockIdentifier) || !((sstatement = ssource.getStatement()) instanceof JumpingStatement) || (jumpingStatement = (JumpingStatement)sstatement).getJumpTarget().getContainer() != source) continue;
                ((JumpingStatement)sstatement).setJumpType(JumpType.CONTINUE);
                ssource.replaceTarget(source, statement);
                statement.addSource(ssource);
                source.removeSource(ssource);
            }
        }
    }

    public static void rewriteWhilesAsFors(Options options, List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> whileStarts = Functional.filter(statements, new Predicate<Op03SimpleStatement>(){

            @Override
            public boolean test(Op03SimpleStatement in) {
                return in.containedStatement instanceof WhileStatement && ((WhileStatement)in.containedStatement).getBlockIdentifier().getBlockType() == BlockType.WHILELOOP;
            }
        });
        boolean aggcapture = options.getOption(OptionsImpl.FOR_LOOP_CAPTURE) == Troolean.TRUE;
        for (Op03SimpleStatement whileStart : whileStarts) {
            Op03SimpleStatement.rewriteWhileAsFor(whileStart, aggcapture);
        }
    }

    private static void rewriteDoWhileTruePredAsWhile(Op03SimpleStatement end, List<Op03SimpleStatement> statements) {
        WhileStatement whileStatement = (WhileStatement)end.getStatement();
        if (null != whileStatement.getCondition()) {
            return;
        }
        List<Op03SimpleStatement> endTargets = end.getTargets();
        if (endTargets.size() != 1) {
            return;
        }
        Op03SimpleStatement loopStart = endTargets.get(0);
        Statement loopBodyStartStatement = loopStart.getStatement();
        BlockIdentifier whileBlockIdentifier = whileStatement.getBlockIdentifier();
        Op03SimpleStatement doStart = null;
        for (Op03SimpleStatement source : loopStart.getSources()) {
            DoStatement doStatement;
            Statement statement = source.getStatement();
            if (statement.getClass() != DoStatement.class || (doStatement = (DoStatement)statement).getBlockIdentifier() != whileBlockIdentifier) continue;
            doStart = source;
            break;
        }
        if (doStart == null) {
            return;
        }
        if (loopBodyStartStatement.getClass() == IfStatement.class) {
            return;
        }
        if (loopBodyStartStatement.getClass() == IfExitingStatement.class) {
            IfExitingStatement ifExitingStatement = (IfExitingStatement)loopBodyStartStatement;
            Statement exitStatement = ifExitingStatement.getExitStatement();
            ConditionalExpression conditionalExpression = ifExitingStatement.getCondition();
            WhileStatement replacementWhile = new WhileStatement(conditionalExpression.getNegated(), whileBlockIdentifier);
            GotoStatement endGoto = new GotoStatement();
            endGoto.setJumpType(JumpType.CONTINUE);
            end.replaceStatement(endGoto);
            Op03SimpleStatement after = new Op03SimpleStatement(doStart.getBlockIdentifiers(), exitStatement, end.getIndex().justAfter());
            int endIdx = statements.indexOf(end);
            if (endIdx < statements.size() - 2) {
                Op03SimpleStatement shuffled = statements.get(endIdx + 1);
                for (Op03SimpleStatement shuffledSource : shuffled.sources) {
                    JumpingStatement jumpingStatement;
                    if (!(shuffledSource.getStatement() instanceof JumpingStatement) || (jumpingStatement = (JumpingStatement)shuffledSource.getStatement()).getJumpType() != JumpType.BREAK) continue;
                    jumpingStatement.setJumpType(JumpType.GOTO);
                }
            }
            statements.add(endIdx + 1, after);
            doStart.addTarget(after);
            after.addSource(doStart);
            doStart.replaceStatement(replacementWhile);
            Op03SimpleStatement afterLoopStart = loopStart.getTargets().get(0);
            doStart.replaceTarget(loopStart, afterLoopStart);
            afterLoopStart.replaceSource(loopStart, doStart);
            loopStart.removeSource(doStart);
            loopStart.removeTarget(afterLoopStart);
            for (Op03SimpleStatement otherSource : loopStart.getSources()) {
                otherSource.replaceTarget(loopStart, doStart);
                doStart.addSource(otherSource);
            }
            loopStart.getSources().clear();
            loopStart.nopOut();
            whileBlockIdentifier.setBlockType(BlockType.WHILELOOP);
            return;
        }
    }

    public static void rewriteDoWhileTruePredAsWhile(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> doWhileEnds = Functional.filter(statements, new Predicate<Op03SimpleStatement>(){

            @Override
            public boolean test(Op03SimpleStatement in) {
                return in.containedStatement instanceof WhileStatement && ((WhileStatement)in.containedStatement).getBlockIdentifier().getBlockType() == BlockType.UNCONDITIONALDOLOOP;
            }
        });
        if (doWhileEnds.isEmpty()) {
            return;
        }
        for (Op03SimpleStatement whileEnd : doWhileEnds) {
            Op03SimpleStatement.rewriteDoWhileTruePredAsWhile(whileEnd, statements);
        }
    }

    public static void rewriteBreakStatements(List<Op03SimpleStatement> statements) {
        Cleaner.reindexInPlace(statements);
        for (Op03SimpleStatement statement : statements) {
            BlockIdentifier outermostContainedIn;
            JumpingStatement jumpingStatement;
            Statement innerStatement = statement.getStatement();
            if (!(innerStatement instanceof JumpingStatement) || !(jumpingStatement = (JumpingStatement)innerStatement).getJumpType().isUnknown()) continue;
            Statement targetInnerStatement = jumpingStatement.getJumpTarget();
            Op03SimpleStatement targetStatement = (Op03SimpleStatement)targetInnerStatement.getContainer();
            if (targetStatement.thisComparisonBlock != null) {
                BlockType blockType = targetStatement.thisComparisonBlock.getBlockType();
                switch (blockType) {
                    default: 
                }
                if (BlockIdentifier.blockIsOneOf(targetStatement.thisComparisonBlock, statement.containedInBlocks)) {
                    jumpingStatement.setJumpType(JumpType.CONTINUE);
                    continue;
                }
            }
            if (targetStatement.getBlockStarted() != null && targetStatement.getBlockStarted().getBlockType() == BlockType.UNCONDITIONALDOLOOP && BlockIdentifier.blockIsOneOf(targetStatement.getBlockStarted(), statement.containedInBlocks)) {
                jumpingStatement.setJumpType(JumpType.CONTINUE);
                continue;
            }
            Set<BlockIdentifier> blocksEnded = targetStatement.getBlocksEnded();
            if (blocksEnded.isEmpty() || (outermostContainedIn = BlockIdentifier.getOutermostContainedIn(blocksEnded, statement.containedInBlocks)) == null) continue;
            jumpingStatement.setJumpType(JumpType.BREAK);
        }
    }

    private static boolean classifyTryCatchLeaveGoto(Op03SimpleStatement gotoStm, Set<BlockIdentifier> blocks, int idx, Set<BlockIdentifier> tryBlockIdents, Map<BlockIdentifier, Op03SimpleStatement> tryStatementsByBlock, Map<BlockIdentifier, List<BlockIdentifier>> catchStatementByBlock, List<Op03SimpleStatement> in) {
        if (idx >= in.size() - 1) {
            return false;
        }
        GotoStatement gotoStatement = (GotoStatement)gotoStm.getStatement();
        Set<BlockIdentifier> tryBlocks = SetUtil.intersectionOrNull(blocks, tryBlockIdents);
        if (tryBlocks == null) {
            return false;
        }
        Op03SimpleStatement after = in.get(idx + 1);
        Set<BlockIdentifier> afterBlocks = SetUtil.intersectionOrNull(after.getBlockIdentifiers(), tryBlockIdents);
        if (afterBlocks != null) {
            tryBlocks.removeAll(afterBlocks);
        }
        if (tryBlocks.size() != 1) {
            return false;
        }
        BlockIdentifier left = tryBlocks.iterator().next();
        Op03SimpleStatement tryStatement = tryStatementsByBlock.get(left);
        if (tryStatement == null) {
            return false;
        }
        List<BlockIdentifier> catchForThis = catchStatementByBlock.get(left);
        if (catchForThis == null) {
            return false;
        }
        Op03SimpleStatement gotoTgt = gotoStm.getTargets().get(0);
        Set<BlockIdentifier> gotoTgtIdents = gotoTgt.getBlockIdentifiers();
        if (SetUtil.hasIntersection(gotoTgtIdents, catchForThis)) {
            return false;
        }
        int idxtgt = in.indexOf(gotoTgt);
        if (idxtgt == 0) {
            return false;
        }
        Op03SimpleStatement prev = in.get(idxtgt - 1);
        if (!SetUtil.hasIntersection(prev.getBlockIdentifiers(), catchForThis)) {
            return false;
        }
        gotoStatement.setJumpType(JumpType.GOTO_OUT_OF_TRY);
        return true;
    }

    private static boolean classifyTryLeaveGoto(Op03SimpleStatement gotoStm, int idx, Set<BlockIdentifier> tryBlockIdents, Map<BlockIdentifier, Op03SimpleStatement> tryStatementsByBlock, Map<BlockIdentifier, List<BlockIdentifier>> catchStatementByBlock, List<Op03SimpleStatement> in) {
        Set<BlockIdentifier> blocks = gotoStm.getBlockIdentifiers();
        return Op03SimpleStatement.classifyTryCatchLeaveGoto(gotoStm, blocks, idx, tryBlockIdents, tryStatementsByBlock, catchStatementByBlock, in);
    }

    private static void classifyCatchLeaveGoto(Op03SimpleStatement gotoStm, int idx, Set<BlockIdentifier> tryBlockIdents, Map<BlockIdentifier, Op03SimpleStatement> tryStatementsByBlock, Map<BlockIdentifier, List<BlockIdentifier>> catchStatementByBlock, Map<BlockIdentifier, Set<BlockIdentifier>> catchBlockToTryBlocks, List<Op03SimpleStatement> in) {
        Set<BlockIdentifier> inBlocks = gotoStm.getBlockIdentifiers();
        Set<BlockIdentifier> blocks = SetFactory.newOrderedSet();
        for (BlockIdentifier block : inBlocks) {
            if (!catchBlockToTryBlocks.containsKey(block)) continue;
            Set<BlockIdentifier> catchToTries = catchBlockToTryBlocks.get(block);
            blocks.addAll(catchToTries);
        }
        Op03SimpleStatement.classifyTryCatchLeaveGoto(gotoStm, blocks, idx, tryBlockIdents, tryStatementsByBlock, catchStatementByBlock, in);
    }

    public static void classifyGotos(List<Op03SimpleStatement> in) {
        Op03SimpleStatement stm;
        List<Pair> gotos = ListFactory.newList();
        Map<BlockIdentifier, Op03SimpleStatement> tryStatementsByBlock = MapFactory.newMap();
        Map<BlockIdentifier, List<BlockIdentifier>> catchStatementsByBlock = MapFactory.newMap();
        Map<BlockIdentifier, Set<BlockIdentifier>> catchToTries = MapFactory.newLazyMap(new UnaryFunction<BlockIdentifier, Set<BlockIdentifier>>(){

            @Override
            public Set<BlockIdentifier> invoke(BlockIdentifier arg) {
                return SetFactory.newOrderedSet();
            }
        });
        int len = in.size();
        for (int x = 0; x < len; ++x) {
            GotoStatement gotoStatement;
            stm = in.get(x);
            Statement statement = stm.getStatement();
            Class<?> clz = statement.getClass();
            if (clz == TryStatement.class) {
                TryStatement tryStatement = (TryStatement)statement;
                BlockIdentifier tryBlockIdent = tryStatement.getBlockIdentifier();
                tryStatementsByBlock.put(tryBlockIdent, stm);
                List<Op03SimpleStatement> targets = stm.getTargets();
                List catchBlocks = ListFactory.newList();
                catchStatementsByBlock.put(tryStatement.getBlockIdentifier(), catchBlocks);
                int len2 = targets.size();
                for (int y = 1; y < len2; ++y) {
                    Statement statement2 = targets.get(y).getStatement();
                    if (statement2.getClass() != CatchStatement.class) continue;
                    BlockIdentifier catchBlockIdent = ((CatchStatement)statement2).getCatchBlockIdent();
                    catchBlocks.add(catchBlockIdent);
                    catchToTries.get(catchBlockIdent).add(tryBlockIdent);
                }
                continue;
            }
            if (clz != GotoStatement.class || !(gotoStatement = (GotoStatement)statement).getJumpType().isUnknown()) continue;
            gotos.add(Pair.make(stm, x));
        }
        if (!tryStatementsByBlock.isEmpty()) {
            for (Pair goto_ : gotos) {
                int idx;
                stm = (Op03SimpleStatement)goto_.getFirst();
                if (Op03SimpleStatement.classifyTryLeaveGoto(stm, idx = ((Integer)goto_.getSecond()).intValue(), tryStatementsByBlock.keySet(), tryStatementsByBlock, catchStatementsByBlock, in)) continue;
                Op03SimpleStatement.classifyCatchLeaveGoto(stm, idx, tryStatementsByBlock.keySet(), tryStatementsByBlock, catchStatementsByBlock, catchToTries, in);
            }
        }
    }

    public static void classifyAnonymousBlockGotos(List<Op03SimpleStatement> in, boolean agressive) {
        int agressiveOffset = agressive ? 1 : 0;
        for (Op03SimpleStatement statement : in) {
            Op03SimpleStatement targetStatement;
            boolean isForwardJump;
            JumpingStatement jumpingStatement;
            JumpType jumpType;
            Statement inner = statement.getStatement();
            if (!(inner instanceof JumpingStatement) || (jumpType = (jumpingStatement = (JumpingStatement)inner).getJumpType()) != JumpType.GOTO || !(isForwardJump = (targetStatement = (Op03SimpleStatement)jumpingStatement.getJumpTarget().getContainer()).getIndex().isBackJumpTo(statement))) continue;
            Set<BlockIdentifier> targetBlocks = targetStatement.getBlockIdentifiers();
            Set<BlockIdentifier> srcBlocks = statement.getBlockIdentifiers();
            if (targetBlocks.size() >= srcBlocks.size() + agressiveOffset || !srcBlocks.containsAll(targetBlocks)) continue;
            srcBlocks = Functional.filterSet(srcBlocks, new Predicate<BlockIdentifier>(){

                @Override
                public boolean test(BlockIdentifier in) {
                    BlockType blockType = in.getBlockType();
                    if (blockType == BlockType.CASE) {
                        return false;
                    }
                    return blockType != BlockType.SWITCH;
                }
            });
            if (targetBlocks.size() >= srcBlocks.size() + agressiveOffset || !srcBlocks.containsAll(targetBlocks)) continue;
            jumpingStatement.setJumpType(JumpType.BREAK_ANONYMOUS);
        }
    }

    public static Op04StructuredStatement createInitialStructuredBlock(List<Op03SimpleStatement> statements) {
        GraphConversionHelper<Op03SimpleStatement, Op04StructuredStatement> conversionHelper = new GraphConversionHelper<Op03SimpleStatement, Op04StructuredStatement>();
        List<Op04StructuredStatement> containers = ListFactory.newList();
        for (Op03SimpleStatement statement : statements) {
            Op04StructuredStatement unstructuredStatement = statement.getStructuredStatementPlaceHolder();
            containers.add(unstructuredStatement);
            conversionHelper.registerOriginalAndNew(statement, unstructuredStatement);
        }
        conversionHelper.patchUpRelations();
        return Op04StructuredStatement.buildNestedBlocks(containers);
    }

    public static List<Op03SimpleStatement> pushThroughGoto(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> pathtests = Functional.filter(statements, new ExactTypeFilter<GotoStatement>(GotoStatement.class));
        boolean success = false;
        for (Op03SimpleStatement gotostm : pathtests) {
            if (!gotostm.getTargets().get(0).getIndex().isBackJumpTo(gotostm) || !Op03SimpleStatement.pushThroughGoto(gotostm, statements)) continue;
            success = true;
        }
        if (success) {
            statements = Cleaner.sortAndRenumber(statements);
            Op03SimpleStatement.rewriteNegativeJumps(statements, false);
            Op03SimpleStatement.rewriteNegativeJumps(statements, false);
        }
        return statements;
    }

    private static boolean moveable(Statement statement) {
        Class<?> clazz = statement.getClass();
        if (clazz == Nop.class) {
            return true;
        }
        if (clazz == AssignmentSimple.class) {
            return true;
        }
        if (clazz == CommentStatement.class) {
            return true;
        }
        if (clazz == ExpressionStatement.class) {
            return true;
        }
        return clazz == IfExitingStatement.class;
    }

    private static boolean pushThroughGoto(Op03SimpleStatement forwardGoto, List<Op03SimpleStatement> statements) {
        boolean abortNext;
        Set<BlockIdentifier> tgtLoopBlocks;
        if (forwardGoto.sources.size() != 1) {
            return false;
        }
        Op03SimpleStatement tgt = forwardGoto.getTargets().get(0);
        int idx = statements.indexOf(tgt);
        if (idx == 0) {
            return false;
        }
        Op03SimpleStatement before = statements.get(idx - 1);
        if (tgt.getSources().contains(before)) {
            return false;
        }
        if (tgt.getSources().size() != 1) {
            return false;
        }
        InstrIndex beforeTgt = tgt.getIndex().justBefore();
        class IsLoopBlock
        implements Predicate<BlockIdentifier> {
            IsLoopBlock() {
            }

            @Override
            public boolean test(BlockIdentifier in) {
                BlockType blockType = in.getBlockType();
                switch (blockType) {
                    case WHILELOOP: 
                    case DOLOOP: {
                        return true;
                    }
                }
                return false;
            }
        }
        IsLoopBlock isLoopBlock = new IsLoopBlock();
        Set<BlockIdentifier> beforeLoopBlocks = SetFactory.newSet(Functional.filterSet(before.getBlockIdentifiers(), isLoopBlock));
        if (!beforeLoopBlocks.equals(tgtLoopBlocks = SetFactory.newSet(Functional.filterSet(tgt.getBlockIdentifiers(), isLoopBlock)))) {
            return false;
        }
        class IsExceptionBlock
        implements Predicate<BlockIdentifier> {
            IsExceptionBlock() {
            }

            @Override
            public boolean test(BlockIdentifier in) {
                BlockType blockType = in.getBlockType();
                switch (blockType) {
                    case TRYBLOCK: 
                    case SWITCH: 
                    case CATCHBLOCK: 
                    case CASE: {
                        return true;
                    }
                }
                return false;
            }
        }
        IsExceptionBlock exceptionFilter = new IsExceptionBlock();
        Set<BlockIdentifier> exceptionBlocks = SetFactory.newSet(Functional.filterSet(tgt.getBlockIdentifiers(), exceptionFilter));
        int nextCandidateIdx = statements.indexOf(forwardGoto) - 1;
        Op03SimpleStatement lastTarget = tgt;
        Set seen = SetFactory.newSet();
        boolean success = false;
        do {
            Op03SimpleStatement tryMoveThis;
            if (!Op03SimpleStatement.moveable((tryMoveThis = forwardGoto.sources.get(0)).getStatement())) {
                return success;
            }
            if (!seen.add(tryMoveThis)) {
                return success;
            }
            if (statements.get(nextCandidateIdx) != tryMoveThis) {
                return success;
            }
            if (tryMoveThis.targets.size() != 1) {
                return success;
            }
            abortNext = tryMoveThis.sources.size() != 1;
            Set<BlockIdentifier> moveEB = SetFactory.newSet(Functional.filterSet(forwardGoto.getBlockIdentifiers(), exceptionFilter));
            if (!moveEB.equals(exceptionBlocks)) {
                return success;
            }
            forwardGoto.sources.clear();
            for (Op03SimpleStatement beforeTryMove : tryMoveThis.sources) {
                beforeTryMove.replaceTarget(tryMoveThis, forwardGoto);
                forwardGoto.sources.add(beforeTryMove);
            }
            tryMoveThis.sources.clear();
            tryMoveThis.sources.add(forwardGoto);
            forwardGoto.replaceTarget(lastTarget, tryMoveThis);
            tryMoveThis.replaceTarget(forwardGoto, lastTarget);
            lastTarget.replaceSource(forwardGoto, tryMoveThis);
            tryMoveThis.index = beforeTgt;
            beforeTgt = beforeTgt.justBefore();
            tryMoveThis.containedInBlocks.clear();
            tryMoveThis.containedInBlocks.addAll(lastTarget.containedInBlocks);
            lastTarget = tryMoveThis;
            --nextCandidateIdx;
            success = true;
        } while (!abortNext);
        return true;
    }

    public static void eclipseLoopPass(List<Op03SimpleStatement> statements) {
        boolean effect = false;
        int len = statements.size() - 1;
        for (int x = 0; x < len; ++x) {
            Statement tgtInr;
            Op03SimpleStatement target;
            Op03SimpleStatement statement = statements.get(x);
            Statement inr = statement.getStatement();
            if (inr.getClass() != GotoStatement.class || (target = statement.getTargets().get(0)) == statement || target.getIndex().isBackJumpFrom(statement) || (tgtInr = target.getStatement()).getClass() != IfStatement.class) continue;
            IfStatement ifStatement = (IfStatement)tgtInr;
            Op03SimpleStatement bodyStart = statements.get(x + 1);
            if (bodyStart != ifStatement.getJumpTarget().getContainer()) continue;
            for (Op03SimpleStatement source : target.getSources()) {
                InstrIndex sourceIdx = source.getIndex();
                if (!sourceIdx.isBackJumpFrom(statement) && !sourceIdx.isBackJumpTo(target)) continue;
            }
            Op03SimpleStatement afterTest = target.getTargets().get(0);
            IfStatement topTest = new IfStatement(ifStatement.getCondition().getNegated().simplify());
            statement.replaceStatement(topTest);
            statement.replaceTarget(target, bodyStart);
            bodyStart.addSource(statement);
            statement.addTarget(afterTest);
            afterTest.replaceSource(target, statement);
            target.replaceStatement(new Nop());
            target.removeSource(statement);
            target.removeTarget(afterTest);
            target.replaceTarget(bodyStart, statement);
            target.replaceStatement(new GotoStatement());
            bodyStart.removeSource(target);
            statement.addSource(target);
            effect = true;
        }
        if (effect) {
            Op03SimpleStatement.removePointlessJumps(statements);
        }
    }

    public JumpType getJumpType() {
        if (this.containedStatement instanceof JumpingStatement) {
            return ((JumpingStatement)this.containedStatement).getJumpType();
        }
        return JumpType.NONE;
    }

    public static List<Op03SimpleStatement> removeUselessNops(List<Op03SimpleStatement> in) {
        return Functional.filter(in, new Predicate<Op03SimpleStatement>(){

            @Override
            public boolean test(Op03SimpleStatement in) {
                return !in.sources.isEmpty() || !in.targets.isEmpty();
            }
        });
    }

    public static void rewriteWith(List<Op03SimpleStatement> in, ExpressionRewriter expressionRewriter) {
        for (Op03SimpleStatement op03SimpleStatement : in) {
            op03SimpleStatement.rewrite(expressionRewriter);
        }
    }

    private static void combineTryCatchBlocks(Op03SimpleStatement tryStatement) {
        Set allStatements = SetFactory.newSet();
        TryStatement innerTryStatement = (TryStatement)tryStatement.getStatement();
        allStatements.addAll(Misc.GraphVisitorBlockReachable.getBlockReachable(tryStatement, innerTryStatement.getBlockIdentifier()));
        for (Op03SimpleStatement target : tryStatement.getTargets()) {
            if (!(target.containedStatement instanceof CatchStatement)) continue;
            CatchStatement catchStatement = (CatchStatement)target.containedStatement;
            allStatements.addAll(Misc.GraphVisitorBlockReachable.getBlockReachable(target, catchStatement.getCatchBlockIdent()));
        }
        Set<BlockIdentifier> tryBlocks = tryStatement.containedInBlocks;
        if ((tryBlocks = SetFactory.newSet(Functional.filter(tryBlocks, new Predicate<BlockIdentifier>(){

            @Override
            public boolean test(BlockIdentifier in) {
                return in.getBlockType() == BlockType.TRYBLOCK || in.getBlockType() == BlockType.CATCHBLOCK;
            }
        }))).isEmpty()) {
            return;
        }
        List<Op03SimpleStatement> orderedStatements = ListFactory.newList(allStatements);
        Collections.sort(orderedStatements, new CompareByIndex(false));
        for (Op03SimpleStatement statement : orderedStatements) {
            for (BlockIdentifier ident : tryBlocks) {
                if (statement.containedInBlocks.contains(ident) || !statement.sources.contains(statement.linearlyPrevious) || !statement.linearlyPrevious.containedInBlocks.contains(ident)) continue;
                statement.addPossibleExitFor(ident);
            }
            statement.containedInBlocks.addAll(tryBlocks);
        }
    }

    private void addPossibleExitFor(BlockIdentifier ident) {
        if (this.possibleExitsFor == null) {
            this.possibleExitsFor = SetFactory.newOrderedSet();
        }
        this.possibleExitsFor.add(ident);
    }

    public boolean isPossibleExitFor(BlockIdentifier ident) {
        return this.possibleExitsFor != null && this.possibleExitsFor.contains(ident);
    }

    public static void combineTryCatchBlocks(List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tries = Functional.filter(in, new TypeFilter<TryStatement>(TryStatement.class));
        for (Op03SimpleStatement tryStatement : tries) {
            Op03SimpleStatement.combineTryCatchBlocks(tryStatement);
        }
    }

    private static void combineTryCatchEnds(Op03SimpleStatement tryStatement, List<Op03SimpleStatement> in) {
        TryStatement innerTryStatement = (TryStatement)tryStatement.getStatement();
        List<Op03SimpleStatement> lastStatements = ListFactory.newList();
        lastStatements.add(Op03SimpleStatement.getLastContiguousBlockStatement(innerTryStatement.getBlockIdentifier(), in, tryStatement));
        int len = tryStatement.targets.size();
        for (int x = 1; x < len; ++x) {
            Op03SimpleStatement statementContainer = tryStatement.targets.get(x);
            Statement statement = statementContainer.getStatement();
            if (!(statement instanceof CatchStatement)) {
                if (statement instanceof FinallyStatement) {
                    return;
                }
                return;
            }
            lastStatements.add(Op03SimpleStatement.getLastContiguousBlockStatement(((CatchStatement)statement).getCatchBlockIdent(), in, statementContainer));
        }
        if (lastStatements.size() <= 1) {
            return;
        }
        for (Op03SimpleStatement last : lastStatements) {
            if (last == null) {
                return;
            }
            if (last.getStatement().getClass() == GotoStatement.class) continue;
            return;
        }
        Op03SimpleStatement target = lastStatements.get(0).getTargets().get(0);
        for (Op03SimpleStatement last : lastStatements) {
            if (last.getTargets().get(0) == target) continue;
            return;
        }
        Op03SimpleStatement finalStatement = lastStatements.get(lastStatements.size() - 1);
        int beforeTgt = in.indexOf(finalStatement);
        Op03SimpleStatement proxy = new Op03SimpleStatement(tryStatement.getBlockIdentifiers(), new GotoStatement(), finalStatement.getIndex().justAfter());
        in.add(beforeTgt + 1, proxy);
        proxy.addTarget(target);
        target.addSource(proxy);
        Set seen = SetFactory.newSet();
        for (Op03SimpleStatement last : lastStatements) {
            if (!seen.add(last)) continue;
            GotoStatement gotoStatement = (GotoStatement)last.containedStatement;
            gotoStatement.setJumpType(JumpType.END_BLOCK);
            last.replaceTarget(target, proxy);
            target.removeSource(last);
            proxy.addSource(last);
        }
    }

    private static void rewriteTryBackJump(Op03SimpleStatement stm) {
        InstrIndex idx = stm.getIndex();
        TryStatement tryStatement = (TryStatement)stm.getStatement();
        Op03SimpleStatement firstbody = stm.getTargets().get(0);
        BlockIdentifier blockIdentifier = tryStatement.getBlockIdentifier();
        Iterator<Op03SimpleStatement> sourceIter = stm.sources.iterator();
        while (sourceIter.hasNext()) {
            Op03SimpleStatement source = sourceIter.next();
            if (!idx.isBackJumpFrom(source) || !source.getBlockIdentifiers().contains(blockIdentifier)) continue;
            source.replaceTarget(stm, firstbody);
            firstbody.addSource(source);
            sourceIter.remove();
        }
    }

    public static void rewriteTryBackJumps(List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tries = Functional.filter(in, new TypeFilter<TryStatement>(TryStatement.class));
        for (Op03SimpleStatement trystm : tries) {
            Op03SimpleStatement.rewriteTryBackJump(trystm);
        }
    }

    public static void combineTryCatchEnds(List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tries = Functional.filter(in, new TypeFilter<TryStatement>(TryStatement.class));
        for (Op03SimpleStatement tryStatement : tries) {
            Op03SimpleStatement.combineTryCatchEnds(tryStatement, in);
        }
    }

    private static Op03SimpleStatement insertBlockPadding(String comment, Op03SimpleStatement insertAfter, Op03SimpleStatement insertBefore, BlockIdentifier blockIdentifier, List<Op03SimpleStatement> statements) {
        Op03SimpleStatement between = new Op03SimpleStatement(insertAfter.getBlockIdentifiers(), new CommentStatement(comment), insertAfter.getIndex().justAfter());
        insertAfter.replaceTarget(insertBefore, between);
        insertBefore.replaceSource(insertAfter, between);
        between.addSource(insertAfter);
        between.addTarget(insertBefore);
        between.getBlockIdentifiers().add(blockIdentifier);
        statements.add(between);
        return between;
    }

    private static void identifyCatchBlock(Op03SimpleStatement start, BlockIdentifier blockIdentifier, List<Op03SimpleStatement> statements) {
        Set knownMembers = SetFactory.newSet();
        Set seen = SetFactory.newSet();
        seen.add(start);
        knownMembers.add(start);
        LinkedList pendingPossibilities = ListFactory.newLinkedList();
        if (start.targets.size() != 1) {
            throw new ConfusedCFRException("Catch statement with multiple targets");
        }
        for (Op03SimpleStatement target : start.targets) {
            pendingPossibilities.add(target);
            seen.add(target);
        }
        Map<Op03SimpleStatement, Set<Op03SimpleStatement>> allows = MapFactory.newLazyMap(new UnaryFunction<Op03SimpleStatement, Set<Op03SimpleStatement>>(){

            @Override
            public Set<Op03SimpleStatement> invoke(Op03SimpleStatement ignore) {
                return SetFactory.newSet();
            }
        });
        int sinceDefinite = 0;
        while (!pendingPossibilities.isEmpty() && sinceDefinite <= pendingPossibilities.size()) {
            Op03SimpleStatement maybe = (Op03SimpleStatement)pendingPossibilities.removeFirst();
            boolean definite = true;
            for (Op03SimpleStatement op03SimpleStatement : maybe.sources) {
                if (knownMembers.contains(op03SimpleStatement) || op03SimpleStatement.getIndex().isBackJumpTo(maybe)) continue;
                definite = false;
                allows.get(op03SimpleStatement).add(maybe);
            }
            if (definite) {
                sinceDefinite = 0;
                knownMembers.add(maybe);
                Set<Op03SimpleStatement> allowedBy = allows.get(maybe);
                pendingPossibilities.addAll(allowedBy);
                allowedBy.clear();
                for (Op03SimpleStatement target : maybe.targets) {
                    if (seen.contains(target)) continue;
                    seen.add(target);
                    if (!target.getIndex().isBackJumpTo(start)) continue;
                    pendingPossibilities.add(target);
                }
                continue;
            }
            ++sinceDefinite;
            pendingPossibilities.add(maybe);
        }
        knownMembers.remove(start);
        if (knownMembers.isEmpty()) {
            List<Op03SimpleStatement> targets = start.getTargets();
            if (targets.size() != 1) {
                throw new ConfusedCFRException("Synthetic catch block has multiple targets");
            }
            knownMembers.add(Op03SimpleStatement.insertBlockPadding("empty catch block", start, targets.get(0), blockIdentifier, statements));
        }
        List knownMemberList = ListFactory.newList(knownMembers);
        Collections.sort(knownMemberList, new CompareByIndex());
        List<Op03SimpleStatement> truncatedKnownMembers = ListFactory.newList();
        List list = ListFactory.newList();
        int l = statements.size();
        for (int x = statements.indexOf(knownMemberList.get(0)); x < l; ++x) {
            Op03SimpleStatement statement = statements.get(x);
            if (statement.isAgreedNop()) {
                list.add(statement);
                continue;
            }
            if (!knownMembers.contains(statement)) break;
            truncatedKnownMembers.add(statement);
            if (list.isEmpty()) continue;
            truncatedKnownMembers.addAll(list);
            list.clear();
        }
        for (Op03SimpleStatement inBlock : truncatedKnownMembers) {
            inBlock.containedInBlocks.add(blockIdentifier);
        }
        Op03SimpleStatement first = start.getTargets().get(0);
        first.markFirstStatementInBlock(blockIdentifier);
    }

    public static void identifyCatchBlocks(List<Op03SimpleStatement> in, BlockIdentifierFactory blockIdentifierFactory) {
        List<Op03SimpleStatement> catchStarts = Functional.filter(in, new TypeFilter<CatchStatement>(CatchStatement.class));
        for (Op03SimpleStatement catchStart : catchStarts) {
            CatchStatement catchStatement = (CatchStatement)catchStart.containedStatement;
            if (catchStatement.getCatchBlockIdent() != null) continue;
            BlockIdentifier blockIdentifier = blockIdentifierFactory.getNextBlockIdentifier(BlockType.CATCHBLOCK);
            catchStatement.setCatchBlockIdent(blockIdentifier);
            Op03SimpleStatement.identifyCatchBlock(catchStart, blockIdentifier, in);
        }
    }

    private static Op03SimpleStatement getLastContiguousBlockStatement(BlockIdentifier blockIdentifier, List<Op03SimpleStatement> in, Op03SimpleStatement preBlock) {
        if (preBlock.targets.isEmpty()) {
            return null;
        }
        Op03SimpleStatement currentStatement = preBlock.targets.get(0);
        int x = in.indexOf(currentStatement);
        if (!currentStatement.getBlockIdentifiers().contains(blockIdentifier)) {
            return null;
        }
        Op03SimpleStatement last = currentStatement;
        while (currentStatement.getBlockIdentifiers().contains(blockIdentifier) && ++x < in.size()) {
            last = currentStatement;
            currentStatement = in.get(x);
        }
        return last;
    }

    private static void extendTryBlock(Op03SimpleStatement tryStatement, List<Op03SimpleStatement> in, DCCommonState dcCommonState) {
        TryStatement tryStatementInner = (TryStatement)tryStatement.getStatement();
        BlockIdentifier tryBlockIdent = tryStatementInner.getBlockIdentifier();
        Op03SimpleStatement lastStatement = null;
        Op03SimpleStatement currentStatement = tryStatement.targets.get(0);
        int x = in.indexOf(currentStatement);
        List<Op03SimpleStatement> jumps = ListFactory.newList();
        while (currentStatement.getBlockIdentifiers().contains(tryBlockIdent)) {
            if (++x >= in.size()) {
                return;
            }
            lastStatement = currentStatement;
            if (currentStatement.getStatement() instanceof JumpingStatement) {
                jumps.add(currentStatement);
            }
            currentStatement = in.get(x);
        }
        Set<JavaRefTypeInstance> caught = SetFactory.newSet();
        List<Op03SimpleStatement> targets = tryStatement.targets;
        int len = targets.size();
        for (int i = 1; i < len; ++i) {
            Statement statement = targets.get(i).getStatement();
            if (!(statement instanceof CatchStatement)) continue;
            CatchStatement catchStatement = (CatchStatement)statement;
            List<ExceptionGroup.Entry> list = catchStatement.getExceptions();
            for (ExceptionGroup.Entry entry : list) {
                caught.add(entry.getCatchType());
            }
        }
        ExceptionCheckImpl exceptionCheck = new ExceptionCheckImpl(dcCommonState, caught);
        block3: while (!currentStatement.getStatement().canThrow(exceptionCheck)) {
            Set validBlocks = SetFactory.newSet();
            validBlocks.add(tryBlockIdent);
            int len2 = tryStatement.targets.size();
            for (int i = 1; i < len2; ++i) {
                Op03SimpleStatement op03SimpleStatement = tryStatement.targets.get(i);
                Statement tgtStatement = op03SimpleStatement.getStatement();
                if (tgtStatement instanceof CatchStatement) {
                    validBlocks.add(((CatchStatement)tgtStatement).getCatchBlockIdent());
                    continue;
                }
                if (tgtStatement instanceof FinallyStatement) {
                    validBlocks.add(((FinallyStatement)tgtStatement).getFinallyBlockIdent());
                    continue;
                }
                return;
            }
            boolean foundSource = false;
            for (Op03SimpleStatement op03SimpleStatement : currentStatement.sources) {
                if (!SetUtil.hasIntersection(validBlocks, op03SimpleStatement.getBlockIdentifiers())) {
                    return;
                }
                if (!op03SimpleStatement.getBlockIdentifiers().contains(tryBlockIdent)) continue;
                foundSource = true;
            }
            if (!foundSource) {
                return;
            }
            currentStatement.getBlockIdentifiers().add(tryBlockIdent);
            if (++x >= in.size()) break;
            Op03SimpleStatement nextStatement = in.get(x);
            if (!currentStatement.getTargets().contains(nextStatement)) {
                for (Op03SimpleStatement source2 : nextStatement.getSources()) {
                    if (source2.getBlockIdentifiers().contains(tryBlockIdent)) continue;
                    break block3;
                }
            }
            lastStatement = currentStatement;
            if (currentStatement.getStatement() instanceof JumpingStatement) {
                jumps.add(currentStatement);
            }
            currentStatement = nextStatement;
        }
        if (lastStatement != null && lastStatement.getTargets().isEmpty()) {
            Set outTargets = SetFactory.newSet();
            for (Op03SimpleStatement jump : jumps) {
                int idx;
                JumpingStatement jumpingStatement = (JumpingStatement)jump.getStatement();
                int n = idx = jumpingStatement.isConditional() ? 1 : 0;
                if (idx >= jump.getTargets().size()) {
                    return;
                }
                Op03SimpleStatement jumpTarget = jump.getTargets().get(idx);
                if (jumpTarget.getIndex().isBackJumpFrom(jump) || jumpTarget.getBlockIdentifiers().contains(tryBlockIdent)) continue;
                outTargets.add(jumpTarget);
            }
            if (outTargets.size() == 1) {
                Op03SimpleStatement replace = (Op03SimpleStatement)outTargets.iterator().next();
                Op03SimpleStatement newJump = new Op03SimpleStatement(lastStatement.getBlockIdentifiers(), new GotoStatement(), lastStatement.getIndex().justAfter());
                newJump.addTarget(replace);
                replace.addSource(newJump);
                for (Op03SimpleStatement jump : jumps) {
                    if (!jump.getTargets().contains(replace)) continue;
                    jump.replaceTarget(replace, newJump);
                    newJump.addSource(jump);
                    replace.removeSource(jump);
                }
                in.add(in.indexOf(lastStatement) + 1, newJump);
            }
        }
    }

    public static void extendTryBlocks(DCCommonState dcCommonState, List<Op03SimpleStatement> in) {
        List<Op03SimpleStatement> tries = Functional.filter(in, new TypeFilter<TryStatement>(TryStatement.class));
        for (Op03SimpleStatement tryStatement : tries) {
            Op03SimpleStatement.extendTryBlock(tryStatement, in, dcCommonState);
        }
    }

    public static List<Op03SimpleStatement> removeRedundantTries(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> tryStarts = Functional.filter(statements, new TypeFilter<TryStatement>(TryStatement.class));
        boolean effect = false;
        Collections.reverse(tryStarts);
        LinkedList starts = ListFactory.newLinkedList();
        starts.addAll(tryStarts);
        while (!starts.isEmpty()) {
            Op03SimpleStatement trys = (Op03SimpleStatement)starts.removeFirst();
            Statement stm = trys.getStatement();
            if (!(stm instanceof TryStatement)) continue;
            TryStatement tryStatement = (TryStatement)stm;
            BlockIdentifier tryBlock = tryStatement.getBlockIdentifier();
            if (!trys.targets.isEmpty() && trys.targets.get(0).getBlockIdentifiers().contains(tryBlock)) continue;
            Op03SimpleStatement codeTarget = trys.targets.get(0);
            for (Op03SimpleStatement target : trys.targets) {
                target.removeSource(trys);
            }
            trys.targets.clear();
            for (Op03SimpleStatement source : trys.sources) {
                source.replaceTarget(trys, codeTarget);
                codeTarget.addSource(source);
            }
            trys.sources.clear();
            effect = true;
        }
        if (effect) {
            statements = Cleaner.removeUnreachableCode(statements, false);
            statements = Cleaner.sortAndRenumber(statements);
        }
        return statements;
    }

    private static boolean verifyLinearBlock(Op03SimpleStatement current, BlockIdentifier block, int num) {
        while (num >= 0) {
            if (num > 0) {
                if (current.getStatement() instanceof Nop && current.targets.size() == 0) break;
                if (current.targets.size() != 1) {
                    return false;
                }
                if (!current.containedInBlocks.contains(block)) {
                    return false;
                }
                current = current.targets.get(0);
            } else if (!current.containedInBlocks.contains(block)) {
                return false;
            }
            --num;
        }
        for (Op03SimpleStatement target : current.targets) {
            if (!target.containedInBlocks.contains(block)) continue;
            return false;
        }
        return true;
    }

    private static boolean removeSynchronizedCatchBlock(Op03SimpleStatement start, List<Op03SimpleStatement> statements) {
        Op03SimpleStatement rethrow;
        Op03SimpleStatement variableAss;
        Op03SimpleStatement monitorExit;
        BlockIdentifier block = start.firstStatementInThisBlock;
        if (start.sources.size() != 1) {
            return false;
        }
        Op03SimpleStatement catchStatementContainer = start.sources.get(0);
        if (catchStatementContainer.sources.size() != 1) {
            return false;
        }
        Statement catchOrFinally = catchStatementContainer.containedStatement;
        boolean isFinally = false;
        if (catchOrFinally instanceof CatchStatement) {
            CatchStatement catchStatement = (CatchStatement)catchStatementContainer.containedStatement;
            List<ExceptionGroup.Entry> exceptions = catchStatement.getExceptions();
            if (exceptions.size() != 1) {
                return false;
            }
            ExceptionGroup.Entry exception = exceptions.get(0);
            if (!exception.isJustThrowable()) {
                return false;
            }
        } else if (catchOrFinally instanceof FinallyStatement) {
            isFinally = true;
        } else {
            return false;
        }
        if (!Op03SimpleStatement.verifyLinearBlock(start, block, 2)) {
            return false;
        }
        if (isFinally) {
            monitorExit = start;
            variableAss = null;
            rethrow = null;
        } else {
            variableAss = start;
            monitorExit = start.targets.get(0);
            if (monitorExit.targets.size() != 1) {
                return false;
            }
            rethrow = monitorExit.targets.get(0);
        }
        WildcardMatch wildcardMatch = new WildcardMatch();
        if (!isFinally && !wildcardMatch.match(new AssignmentSimple(wildcardMatch.getLValueWildCard("var"), wildcardMatch.getExpressionWildCard("e")), variableAss.containedStatement)) {
            return false;
        }
        if (!wildcardMatch.match(new MonitorExitStatement(wildcardMatch.getExpressionWildCard("lock")), monitorExit.containedStatement)) {
            return false;
        }
        if (!isFinally && !wildcardMatch.match(new ThrowStatement(new LValueExpression(wildcardMatch.getLValueWildCard("var"))), rethrow.containedStatement)) {
            return false;
        }
        Op03SimpleStatement tryStatementContainer = catchStatementContainer.sources.get(0);
        if (isFinally) {
            MonitorExitStatement monitorExitStatement = (MonitorExitStatement)monitorExit.getStatement();
            TryStatement tryStatement = (TryStatement)tryStatementContainer.getStatement();
            tryStatement.addExitMutex(monitorExitStatement.getMonitor());
        }
        tryStatementContainer.removeTarget(catchStatementContainer);
        catchStatementContainer.removeSource(tryStatementContainer);
        catchStatementContainer.nopOut();
        if (!isFinally) {
            variableAss.nopOut();
        }
        monitorExit.nopOut();
        if (!isFinally) {
            for (Op03SimpleStatement target : rethrow.targets) {
                target.removeSource(rethrow);
                rethrow.removeTarget(target);
            }
            rethrow.nopOut();
        }
        if (tryStatementContainer.targets.size() == 1 && !isFinally) {
            TryStatement tryStatement = (TryStatement)tryStatementContainer.containedStatement;
            BlockIdentifier tryBlock = tryStatement.getBlockIdentifier();
            tryStatementContainer.nopOut();
            for (Op03SimpleStatement statement : statements) {
                statement.containedInBlocks.remove(tryBlock);
            }
        }
        return true;
    }

    public static void commentMonitors(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> monitors = Functional.filter(statements, new TypeFilter<MonitorStatement>(MonitorStatement.class));
        if (monitors.isEmpty()) {
            return;
        }
        for (Op03SimpleStatement monitor : monitors) {
            monitor.replaceStatement(new CommentStatement(monitor.getStatement()));
        }
        for (Op03SimpleStatement monitor : monitors) {
            Op03SimpleStatement target = monitor.getTargets().get(0);
            Set<BlockIdentifier> monitorLast = SetFactory.newSet(monitor.getBlockIdentifiers());
            monitorLast.removeAll(target.getBlockIdentifiers());
            if (monitorLast.isEmpty()) continue;
            for (Op03SimpleStatement source : ListFactory.newList(monitor.sources)) {
                Set<BlockIdentifier> sourceBlocks = source.getBlockIdentifiers();
                if (sourceBlocks.containsAll(monitorLast)) continue;
                source.replaceTarget(monitor, target);
                monitor.removeSource(source);
                target.addSource(source);
            }
        }
    }

    public static void removeSynchronizedCatchBlocks(Options options, List<Op03SimpleStatement> in) {
        if (!((Boolean)options.getOption(OptionsImpl.TIDY_MONITORS)).booleanValue()) {
            return;
        }
        List<Op03SimpleStatement> catchStarts = Functional.filter(in, new FindBlockStarts(BlockType.CATCHBLOCK));
        if (catchStarts.isEmpty()) {
            return;
        }
        boolean effect = false;
        for (Op03SimpleStatement catchStart : catchStarts) {
            effect = Op03SimpleStatement.removeSynchronizedCatchBlock(catchStart, in) || effect;
        }
        if (effect) {
            Op03SimpleStatement.removePointlessJumps(in);
        }
    }

    private static void optimiseForTypes(Op03SimpleStatement statement) {
        IfStatement ifStatement = (IfStatement)statement.containedStatement;
        ifStatement.optimiseForTypes();
    }

    public static void optimiseForTypes(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> conditionals = Functional.filter(statements, new TypeFilter<IfStatement>(IfStatement.class));
        for (Op03SimpleStatement conditional : conditionals) {
            Op03SimpleStatement.optimiseForTypes(conditional);
        }
    }

    public static void rejoinBlocks(List<Op03SimpleStatement> statements) {
        Set<Object> lastBlocks = SetFactory.newSet();
        Set haveLeft = SetFactory.newSet();
        Set blackListed = SetFactory.newSet();
        int len = statements.size();
        for (int x = 0; x < len; ++x) {
            Op03SimpleStatement stm = statements.get(x);
            Statement stmInner = stm.getStatement();
            if (stmInner instanceof CatchStatement) {
                CatchStatement catchStatement = (CatchStatement)stmInner;
                for (ExceptionGroup.Entry entry : catchStatement.getExceptions()) {
                    blackListed.add(entry.getTryBlockIdentifier());
                }
            }
            Set<BlockIdentifier> blocks = stm.getBlockIdentifiers();
            blocks.removeAll(blackListed);
            for (BlockIdentifier ident : blocks) {
                Op03SimpleStatement backFill;
                if (!haveLeft.contains(ident)) continue;
                for (int y = x - 1; y >= 0 && (backFill = statements.get(y)).getBlockIdentifiers().add(ident); --y) {
                }
            }
            for (BlockIdentifier wasIn : lastBlocks) {
                if (blocks.contains(wasIn)) continue;
                haveLeft.add(wasIn);
            }
            lastBlocks = blocks;
        }
    }

    private static void removePointlessSwitchDefault(Op03SimpleStatement swtch) {
        SwitchStatement switchStatement = (SwitchStatement)swtch.getStatement();
        BlockIdentifier switchBlock = switchStatement.getSwitchBlock();
        if (swtch.getTargets().size() <= 1) {
            return;
        }
        for (Op03SimpleStatement tgt : swtch.getTargets()) {
            CaseStatement caseStatement;
            Statement statement = tgt.getStatement();
            if (!(statement instanceof CaseStatement) || (caseStatement = (CaseStatement)statement).getSwitchBlock() != switchBlock || !caseStatement.isDefault()) continue;
            if (tgt.targets.size() != 1) {
                return;
            }
            Op03SimpleStatement afterTgt = tgt.targets.get(0);
            if (afterTgt.containedInBlocks.contains(switchBlock)) {
                return;
            }
            tgt.nopOut();
            return;
        }
    }

    public static void removePointlessSwitchDefaults(List<Op03SimpleStatement> statements) {
        List<Op03SimpleStatement> switches = Functional.filter(statements, new TypeFilter<SwitchStatement>(SwitchStatement.class));
        for (Op03SimpleStatement swtch : switches) {
            Op03SimpleStatement.removePointlessSwitchDefault(swtch);
        }
    }

    public static void labelAnonymousBlocks(List<Op03SimpleStatement> statements, BlockIdentifierFactory blockIdentifierFactory) {
        List<Op03SimpleStatement> anonBreaks = Functional.filter(statements, new Predicate<Op03SimpleStatement>(){

            @Override
            public boolean test(Op03SimpleStatement in) {
                Statement statement = in.getStatement();
                if (!(statement instanceof JumpingStatement)) {
                    return false;
                }
                JumpType jumpType = ((JumpingStatement)statement).getJumpType();
                return jumpType == JumpType.BREAK_ANONYMOUS;
            }
        });
        if (anonBreaks.isEmpty()) {
            return;
        }
        Set<Op03SimpleStatement> targets = SetFactory.newOrderedSet();
        for (Op03SimpleStatement anonBreak : anonBreaks) {
            JumpingStatement jumpingStatement = (JumpingStatement)anonBreak.getStatement();
            Op03SimpleStatement anonBreakTarget = (Op03SimpleStatement)jumpingStatement.getJumpTarget().getContainer();
            if (anonBreakTarget.getStatement() instanceof AnonBreakTarget) continue;
            targets.add(anonBreakTarget);
        }
        for (Op03SimpleStatement target : targets) {
            BlockIdentifier blockIdentifier = blockIdentifierFactory.getNextBlockIdentifier(BlockType.ANONYMOUS);
            InstrIndex targetIndex = target.getIndex();
            Op03SimpleStatement anonTarget = new Op03SimpleStatement(target.getBlockIdentifiers(), new AnonBreakTarget(blockIdentifier), targetIndex.justBefore());
            List<Op03SimpleStatement> sources = ListFactory.newList(target.getSources());
            for (Op03SimpleStatement source : sources) {
                if (!targetIndex.isBackJumpTo(source)) continue;
                target.removeSource(source);
                source.replaceTarget(target, anonTarget);
                anonTarget.addSource(source);
            }
            target.addSource(anonTarget);
            anonTarget.addTarget(target);
            int pos = statements.indexOf(target);
            statements.add(pos, anonTarget);
        }
    }

    public static void replaceStackVarsWithLocals(List<Op03SimpleStatement> statements) {
        StackVarToLocalRewriter rewriter = new StackVarToLocalRewriter();
        for (Op03SimpleStatement statement : statements) {
            statement.rewrite(rewriter);
        }
    }

    public static void narrowAssignmentTypes(Method method, List<Op03SimpleStatement> statements) {
        NarrowingTypeRewriter narrowingTypeRewriter = new NarrowingTypeRewriter();
        narrowingTypeRewriter.rewrite(method, statements);
    }

    public String toString() {
        Set blockIds = SetFactory.newSet();
        for (BlockIdentifier b : this.containedInBlocks) {
            blockIds.add(b.getIndex());
        }
        return "" + blockIds + " " + this.index + " : " + this.containedStatement;
    }

    private static final class FindBlockStarts
    implements Predicate<Op03SimpleStatement> {
        private final BlockType blockType;

        FindBlockStarts(BlockType blockType) {
            this.blockType = blockType;
        }

        @Override
        public boolean test(Op03SimpleStatement in) {
            BlockIdentifier blockIdentifier = in.firstStatementInThisBlock;
            if (blockIdentifier == null) {
                return false;
            }
            return blockIdentifier.getBlockType() == this.blockType;
        }
    }

    public static class ExactTypeFilter<T>
    implements Predicate<Op03SimpleStatement> {
        private final Class<T> clazz;

        ExactTypeFilter(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean test(Op03SimpleStatement in) {
            return this.clazz == in.containedStatement.getClass();
        }
    }

    private static class SingleExceptionAddressing {
        BlockIdentifier tryBlockIdent;
        BlockIdentifier catchBlockIdent;
        LinearScannedBlock tryBlock;
        LinearScannedBlock catchBlock;

        private SingleExceptionAddressing(BlockIdentifier tryBlockIdent, BlockIdentifier catchBlockIdent, LinearScannedBlock tryBlock, LinearScannedBlock catchBlock) {
            this.tryBlockIdent = tryBlockIdent;
            this.catchBlockIdent = catchBlockIdent;
            this.tryBlock = tryBlock;
            this.catchBlock = catchBlock;
        }
    }

    private static class StatementCanBePostMutation
    implements Predicate<Op03SimpleStatement> {
        private StatementCanBePostMutation() {
        }

        @Override
        public boolean test(Op03SimpleStatement in) {
            LValue lValue;
            AssignmentPreMutation assignmentPreMutation = (AssignmentPreMutation)in.getStatement();
            return assignmentPreMutation.isSelfMutatingOp1(lValue = assignmentPreMutation.getCreatedLValue(), ArithOp.PLUS) || assignmentPreMutation.isSelfMutatingOp1(lValue, ArithOp.MINUS);
        }
    }

    private static class UsageWatcher
    extends AbstractExpressionRewriter {
        private final LValue needle;
        boolean found = false;

        private UsageWatcher(LValue needle) {
            this.needle = needle;
        }

        @Override
        public LValue rewriteExpression(LValue lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
            if (this.needle.equals(lValue)) {
                this.found = true;
            }
            return super.rewriteExpression(lValue, ssaIdentifiers, statementContainer, flags);
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public class GraphVisitorCallee
    implements BinaryProcedure<Op03SimpleStatement, GraphVisitor<Op03SimpleStatement>> {
        private final List<Op03SimpleStatement> reachableNodes;

        GraphVisitorCallee(List<Op03SimpleStatement> reachableNodes) {
            this.reachableNodes = reachableNodes;
        }

        @Override
        public void call(Op03SimpleStatement node, GraphVisitor<Op03SimpleStatement> graphVisitor) {
            this.reachableNodes.add(node);
            for (Op03SimpleStatement target : node.targets) {
                graphVisitor.enqueue(target);
            }
        }
    }
}

