/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bekit.common.transaction.TransactionManager;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.event.EventPublisher;
import org.bekit.event.bus.EventBusHub;
import org.bekit.event.publisher.DefaultEventPublisher;
import org.bekit.service.annotation.service.Service;
import org.bekit.service.annotation.service.ServiceAfter;
import org.bekit.service.annotation.service.ServiceBefore;
import org.bekit.service.annotation.service.ServiceExecute;
import org.bekit.service.engine.ServiceContext;
import org.bekit.service.listener.ServiceListenerType;
import org.bekit.service.service.ServiceExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ServiceParser {
    private static final Logger log = LoggerFactory.getLogger(ServiceParser.class);
    private static final Class<? extends Annotation>[] SERVICE_PHASE_ANNOTATIONS = new Class[]{ServiceBefore.class, ServiceExecute.class, ServiceAfter.class};

    public static ServiceExecutor parseService(Object service, EventBusHub eventBusHub, TransactionManager transactionManager) {
        Class serviceClass = AopUtils.getTargetClass((Object)service);
        log.debug("\u89e3\u6790\u670d\u52a1\uff1a{}", (Object)serviceClass);
        Service serviceAnnotation = (Service)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)serviceClass, Service.class);
        String serviceName = serviceAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = ClassUtils.getShortNameAsProperty((Class)serviceClass);
        }
        TxExecutor txExecutor = null;
        if (serviceAnnotation.enableTx()) {
            txExecutor = new TxExecutor(transactionManager, TransactionManager.TransactionType.REQUIRED);
        }
        Map<Class<?>, ServiceExecutor.ServicePhaseExecutor> phaseExecutorMap = ServiceParser.parseToPhaseExecutors(serviceClass);
        return new ServiceExecutor(serviceName, service, phaseExecutorMap, (EventPublisher)new DefaultEventPublisher(eventBusHub.getEventBus(ServiceListenerType.class)), txExecutor);
    }

    private static Map<Class<?>, ServiceExecutor.ServicePhaseExecutor> parseToPhaseExecutors(Class serviceClass) {
        HashMap map = new HashMap();
        ReflectionUtils.doWithLocalMethods((Class)serviceClass, method -> {
            for (Class<? extends Annotation> annotationClass : SERVICE_PHASE_ANNOTATIONS) {
                Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, annotationClass);
                if (annotation == null) continue;
                map.put(annotationClass, ServiceParser.parseServicePhase(method));
            }
        });
        Assert.isTrue((boolean)map.containsKey(ServiceExecute.class), (String)String.format("\u670d\u52a1[%s]\u7f3a\u5c11@ServiceExecute\u7c7b\u578b\u65b9\u6cd5", serviceClass));
        Class<?> orderType = ((ServiceExecutor.ServicePhaseExecutor)((Object)map.get(ServiceExecute.class))).getOrderType();
        Class<?> resultType = ((ServiceExecutor.ServicePhaseExecutor)((Object)map.get(ServiceExecute.class))).getResultType();
        Assert.isTrue((boolean)ClassUtils.hasConstructor(resultType, (Class[])new Class[0]), (String)String.format("@ServiceExecute\u670d\u52a1\u65b9\u6cd5[%s]\u7684\u53c2\u6570ServiceContext\u7684\u6cdb\u578b[%s]\u5fc5\u987b\u5f97\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570", ((ServiceExecutor.ServicePhaseExecutor)((Object)map.get(ServiceExecute.class))).getMethod(), resultType));
        map.forEach((annotationClass, phaseExecutor) -> {
            Assert.isAssignable(phaseExecutor.getOrderType(), (Class)orderType, (String)String.format("\u670d\u52a1[%s]\u5185\u7684ServiceContext\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u7edf\u4e00", serviceClass));
            Assert.isAssignable(phaseExecutor.getResultType(), (Class)resultType, (String)String.format("\u670d\u52a1[%s]\u5185\u7684ServiceContext\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u7edf\u4e00", serviceClass));
        });
        return map;
    }

    private static ServiceExecutor.ServicePhaseExecutor parseServicePhase(Method servicePhaseMethod) {
        log.debug("\u89e3\u6790\u670d\u52a1\u65b9\u6cd5\uff1a{}", (Object)servicePhaseMethod);
        Assert.isTrue((boolean)Modifier.isPublic(servicePhaseMethod.getModifiers()), (String)String.format("\u670d\u52a1\u65b9\u6cd5[%s]\u5fc5\u987b\u662fpublic\u7c7b\u578b", servicePhaseMethod));
        Assert.isTrue((servicePhaseMethod.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)String.format("\u670d\u52a1\u65b9\u6cd5[%s]\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fvoid", servicePhaseMethod));
        Class<?>[] parameterTypes = servicePhaseMethod.getParameterTypes();
        if (parameterTypes.length != 1 || parameterTypes[0] != ServiceContext.class) {
            throw new IllegalArgumentException(String.format("\u670d\u52a1\u65b9\u6cd5[%s]\u7684\u5165\u53c2\u5fc5\u987b\u662f(ServiceContext<O,R> context)", servicePhaseMethod));
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)servicePhaseMethod, (int)0);
        Class orderType = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
        Class resultType = resolvableType.getGeneric(new int[]{1}).resolve(Object.class);
        return new ServiceExecutor.ServicePhaseExecutor(servicePhaseMethod, orderType, resultType);
    }
}

