/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.lang.reflect.Method;
import java.util.Map;
import org.bekit.common.method.MethodExecutor;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.event.EventPublisher;
import org.bekit.service.annotation.service.ServiceAfter;
import org.bekit.service.annotation.service.ServiceBefore;
import org.bekit.service.annotation.service.ServiceExecute;
import org.bekit.service.engine.ServiceContext;
import org.bekit.service.event.ServiceApplyEvent;
import org.bekit.service.event.ServiceExceptionEvent;
import org.bekit.service.event.ServiceFinishEvent;

public class ServiceExecutor {
    private final String serviceName;
    private final Object service;
    private final Map<Class<?>, ServicePhaseExecutor> phaseExecutorMap;
    private final EventPublisher eventPublisher;
    private final TxExecutor txExecutor;

    public void execute(ServiceContext context) {
        try {
            this.eventPublisher.publish((Object)new ServiceApplyEvent(this.serviceName, context));
            this.executePhases(context);
        }
        catch (Throwable e) {
            this.eventPublisher.publish((Object)new ServiceExceptionEvent(this.serviceName, e, context));
        }
        finally {
            this.eventPublisher.publish((Object)new ServiceFinishEvent(this.serviceName, context));
        }
    }

    private void executePhases(ServiceContext context) throws Throwable {
        if (this.phaseExecutorMap.containsKey(ServiceBefore.class)) {
            this.phaseExecutorMap.get(ServiceBefore.class).execute(this.service, context);
        }
        this.executeServiceExecute(context);
        if (this.phaseExecutorMap.containsKey(ServiceAfter.class)) {
            this.phaseExecutorMap.get(ServiceAfter.class).execute(this.service, context);
        }
    }

    private void executeServiceExecute(ServiceContext context) throws Throwable {
        if (this.txExecutor != null) {
            this.txExecutor.createTx();
        }
        try {
            this.phaseExecutorMap.get(ServiceExecute.class).execute(this.service, context);
            if (this.txExecutor != null) {
                this.txExecutor.commitTx();
            }
        }
        catch (Throwable e) {
            if (this.txExecutor != null) {
                this.txExecutor.rollbackTx();
            }
            throw e;
        }
    }

    public Class<?> getOrderType() {
        return this.phaseExecutorMap.get(ServiceExecute.class).getOrderType();
    }

    public Class<?> getResultType() {
        return this.phaseExecutorMap.get(ServiceExecute.class).getResultType();
    }

    public ServiceExecutor(String serviceName, Object service, Map<Class<?>, ServicePhaseExecutor> phaseExecutorMap, EventPublisher eventPublisher, TxExecutor txExecutor) {
        this.serviceName = serviceName;
        this.service = service;
        this.phaseExecutorMap = phaseExecutorMap;
        this.eventPublisher = eventPublisher;
        this.txExecutor = txExecutor;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Object getService() {
        return this.service;
    }

    public static class ServicePhaseExecutor
    extends MethodExecutor {
        private final Class<?> orderType;
        private final Class<?> resultType;

        public ServicePhaseExecutor(Method servicePhaseMethod, Class<?> orderType, Class<?> resultType) {
            super(servicePhaseMethod);
            this.orderType = orderType;
            this.resultType = resultType;
        }

        public void execute(Object service, ServiceContext context) throws Throwable {
            this.execute(service, new Object[]{context});
        }

        public Class<?> getOrderType() {
            return this.orderType;
        }

        public Class<?> getResultType() {
            return this.resultType;
        }
    }
}

