/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.engine;

import java.util.HashMap;
import java.util.Map;
import org.bekit.service.ServiceEngine;
import org.bekit.service.engine.ServiceContext;
import org.bekit.service.service.ServiceExecutor;
import org.bekit.service.service.ServiceRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public class DefaultServiceEngine
implements ServiceEngine {
    private final ServiceRegistrar serviceRegistrar;

    @Override
    public <O, R> R execute(String service, O order) {
        return this.execute(service, order, null);
    }

    @Override
    public <O, R> R execute(String service, O order, Map<Object, Object> attachment) {
        ServiceExecutor serviceExecutor = this.getServiceExecutor(service);
        this.checkOrder(order, serviceExecutor);
        ServiceContext<O, Object> context = new ServiceContext<O, Object>(order, this.newResult(serviceExecutor), this.reviseAttachment(attachment));
        serviceExecutor.execute(context);
        return (R)context.getResult();
    }

    private ServiceExecutor getServiceExecutor(String service) {
        ServiceExecutor serviceExecutor = (ServiceExecutor)this.serviceRegistrar.get(service);
        if (serviceExecutor == null) {
            throw new IllegalArgumentException(String.format("\u670d\u52a1[%s]\u4e0d\u5b58\u5728", service));
        }
        return serviceExecutor;
    }

    private void checkOrder(Object order, ServiceExecutor serviceExecutor) {
        Assert.notNull((Object)order, (String)"order\u4e0d\u80fd\u4e3anull");
        if (!serviceExecutor.getOrderType().isAssignableFrom(order.getClass())) {
            throw new IllegalArgumentException(String.format("\u5165\u53c2order\u7684\u7c7b\u578b[%s]\u548c\u670d\u52a1[%s]\u671f\u671b\u7684\u7c7b\u578b\u4e0d\u5339\u914d", order.getClass(), serviceExecutor.getServiceName()));
        }
    }

    private Object newResult(ServiceExecutor serviceExecutor) {
        return BeanUtils.instantiate(serviceExecutor.getResultType());
    }

    private Map<Object, Object> reviseAttachment(Map<Object, Object> attachment) {
        return attachment != null ? attachment : new HashMap();
    }

    public DefaultServiceEngine(ServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }
}

