/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.boot;

import org.bekit.common.scanner.AbstractScanner;
import org.bekit.common.transaction.TransactionManager;
import org.bekit.event.boot.EventBusConfiguration;
import org.bekit.event.bus.EventBusHub;
import org.bekit.service.annotation.service.Service;
import org.bekit.service.engine.DefaultServiceEngine;
import org.bekit.service.service.ServiceExecutor;
import org.bekit.service.service.ServiceParser;
import org.bekit.service.service.ServiceRegistrar;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Configuration
@Import(value={EventBusConfiguration.class, DefaultServiceEngine.class, ServiceRegistrar.class, ServiceScanner.class})
public class ServiceEngineConfiguration {
    public static final int ORDER = 2000;

    @Order(value=2000)
    public static class ServiceScanner
    extends AbstractScanner {
        private final ServiceRegistrar serviceRegistrar;
        private final EventBusHub eventBusHub;
        private final TransactionManager transactionManager;

        public ServiceScanner(ServiceRegistrar serviceRegistrar, EventBusHub eventBusHub, TransactionManager transactionManager) {
            super(Service.class);
            this.serviceRegistrar = serviceRegistrar;
            this.eventBusHub = eventBusHub;
            this.transactionManager = transactionManager;
        }

        protected void onScan(Object obj) {
            ServiceExecutor serviceExecutor = ServiceParser.parseService(obj, this.eventBusHub, this.transactionManager);
            ServiceExecutor existedOne = (ServiceExecutor)this.serviceRegistrar.register(serviceExecutor);
            Assert.isNull((Object)existedOne, (String)String.format("\u5b58\u5728\u91cd\u540d\u7684\u670d\u52a1[%s]", serviceExecutor.getServiceName()));
        }
    }
}

