/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.bekit.service.annotation.service.Service;
import org.bekit.service.service.ServiceExecutor;
import org.bekit.service.service.ServiceParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class ServicesHolder {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private PlatformTransactionManager transactionManager;
    private Map<String, ServiceExecutor> serviceExecutorMap = new HashMap<String, ServiceExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Service.class)) {
            ServiceExecutor serviceExecutor = ServiceParser.parseService(this.applicationContext.getBean(beanName), this.transactionManager);
            if (this.serviceExecutorMap.containsKey(serviceExecutor.getServiceName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u670d\u52a1\uff1a" + serviceExecutor.getServiceName());
            }
            this.serviceExecutorMap.put(serviceExecutor.getServiceName(), serviceExecutor);
        }
    }

    public Set<String> getServiceNames() {
        return this.serviceExecutorMap.keySet();
    }

    public ServiceExecutor getRequiredServiceExecutor(String service) {
        if (!this.serviceExecutorMap.containsKey(service)) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u670d\u52a1" + service);
        }
        return this.serviceExecutorMap.get(service);
    }
}

