/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bekit.common.method.MethodExecutor;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.service.annotation.service.ServiceAfter;
import org.bekit.service.annotation.service.ServiceBefore;
import org.bekit.service.annotation.service.ServiceExecute;
import org.bekit.service.engine.ServiceContext;
import org.springframework.util.ClassUtils;

public class ServiceExecutor {
    public static final Class[] SERVICE_PHASE_ANNOTATIONS = new Class[]{ServiceBefore.class, ServiceExecute.class, ServiceAfter.class};
    private String serviceName;
    private boolean enableTx;
    private Object service;
    private Map<Class, ServicePhaseExecutor> phaseExecutorMap = new HashMap<Class, ServicePhaseExecutor>();
    private TxExecutor txExecutor;

    public ServiceExecutor(String serviceName, boolean enableTx, Object service) {
        this.serviceName = serviceName;
        this.enableTx = enableTx;
        this.service = service;
    }

    public void execute(ServiceContext serviceContext) throws Throwable {
        if (this.phaseExecutorMap.containsKey(ServiceBefore.class)) {
            this.phaseExecutorMap.get(ServiceBefore.class).execute(this.service, serviceContext);
        }
        this.executeServiceExecute(serviceContext);
        if (this.phaseExecutorMap.containsKey(ServiceAfter.class)) {
            this.phaseExecutorMap.get(ServiceAfter.class).execute(this.service, serviceContext);
        }
    }

    private void executeServiceExecute(ServiceContext serviceContext) throws Throwable {
        if (this.enableTx) {
            this.txExecutor.createTx();
        }
        try {
            this.phaseExecutorMap.get(ServiceExecute.class).execute(this.service, serviceContext);
            if (this.enableTx) {
                this.txExecutor.commitTx();
            }
        }
        catch (Throwable e) {
            if (this.enableTx) {
                this.txExecutor.rollbackTx();
            }
            throw e;
        }
    }

    public void setPhaseExecutor(Class clazz, ServicePhaseExecutor phaseExecutor) {
        if (!Arrays.asList(SERVICE_PHASE_ANNOTATIONS).contains(clazz)) {
            throw new IllegalArgumentException(ClassUtils.getShortName((Class)clazz) + "\u4e0d\u662f\u670d\u52a1\u9636\u6bb5\u6ce8\u89e3");
        }
        if (this.phaseExecutorMap.containsKey(clazz)) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u5b58\u5728\u591a\u4e2a@" + ClassUtils.getShortName((Class)clazz) + "\u7c7b\u578b\u65b9\u6cd5");
        }
        this.phaseExecutorMap.put(clazz, phaseExecutor);
    }

    public void setTxExecutor(TxExecutor txExecutor) {
        if (!this.enableTx) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u7684enableTx\u5c5e\u6027\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e8b\u52a1\u6267\u884c\u5668");
        }
        if (this.txExecutor != null) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u7684\u4e8b\u52a1\u6267\u884c\u5668\u5df2\u7ecf\u88ab\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e");
        }
        this.txExecutor = txExecutor;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Object getService() {
        return this.service;
    }

    public Class getOrderClass() {
        return this.phaseExecutorMap.get(ServiceExecute.class).getOrderClass();
    }

    public Class getResultClass() {
        return this.phaseExecutorMap.get(ServiceExecute.class).getResultClass();
    }

    public void validate() {
        if (this.serviceName == null || this.service == null) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u5185\u90e8\u8981\u7d20\u4e0d\u5168");
        }
        if (this.enableTx) {
            if (this.txExecutor == null) {
                throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u7684enableTx\u5c5e\u6027\u4e3a\u5f00\u542f\u72b6\u6001\uff0c\u4f46\u672a\u8bbe\u7f6e\u4e8b\u52a1\u6267\u884c\u5668");
            }
            this.txExecutor.validate();
        } else if (this.txExecutor != null) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u7684enableTx\u5c5e\u6027\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4f46\u8bbe\u7f6e\u4e86\u4e8b\u52a1\u6267\u884c\u5668");
        }
        if (!this.phaseExecutorMap.containsKey(ServiceExecute.class)) {
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u7f3a\u5c11@ServiceExecute\u7c7b\u578b\u65b9\u6cd5");
        }
        for (ServicePhaseExecutor phaseExecutor : this.phaseExecutorMap.values()) {
            if (phaseExecutor.getOrderClass() != this.getOrderClass()) {
                throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u5185\u7684ServiceContext\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u7edf\u4e00");
            }
            if (phaseExecutor.getResultClass() == this.getResultClass()) continue;
            throw new IllegalStateException("\u670d\u52a1" + this.serviceName + "\u5185\u7684ServiceContext\u7684\u6cdb\u578b\u7c7b\u578b\u4e0d\u7edf\u4e00");
        }
    }

    public static class ServicePhaseExecutor
    extends MethodExecutor {
        private Class orderClass;
        private Class resultClass;

        public ServicePhaseExecutor(Method targetMethod, Class orderClass, Class resultClass) {
            super(targetMethod);
            this.orderClass = orderClass;
            this.resultClass = resultClass;
        }

        public void execute(Object service, ServiceContext serviceContext) throws Throwable {
            this.execute(service, new Object[]{serviceContext});
        }

        public Class getOrderClass() {
            return this.orderClass;
        }

        public Class getResultClass() {
            return this.resultClass;
        }
    }
}

