/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.engine;

import java.util.Map;
import org.bekit.event.EventPublisher;
import org.bekit.service.ServiceEngine;
import org.bekit.service.engine.ServiceContext;
import org.bekit.service.event.ServiceApplyEvent;
import org.bekit.service.event.ServiceExceptionEvent;
import org.bekit.service.event.ServiceFinishEvent;
import org.bekit.service.service.ServiceExecutor;
import org.bekit.service.service.ServicesHolder;
import org.springframework.cglib.core.ReflectUtils;

public class DefaultServiceEngine
implements ServiceEngine {
    private ServicesHolder servicesHolder;
    private EventPublisher eventPublisher;

    public DefaultServiceEngine(ServicesHolder servicesHolder, EventPublisher eventPublisher) {
        this.servicesHolder = servicesHolder;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public <O, R> R execute(String service, O order) {
        return this.execute(service, order, null);
    }

    @Override
    public <O, R> R execute(String service, O order, Map<Object, Object> attachment) {
        this.checkOrderClass(order, service);
        ServiceContext<O, Object> serviceContext = new ServiceContext<O, Object>(order, this.newResult(service), attachment);
        this.executeService(service, serviceContext);
        return (R)serviceContext.getResult();
    }

    private void checkOrderClass(Object order, String service) {
        ServiceExecutor serviceExecutor = this.servicesHolder.getRequiredServiceExecutor(service);
        if (!serviceExecutor.getOrderClass().isAssignableFrom(order.getClass())) {
            throw new IllegalArgumentException("\u5165\u53c2order\u7684\u7c7b\u578b\u548c\u670d\u52a1" + serviceExecutor.getServiceName() + "\u671f\u671b\u7684\u7c7b\u578b\u4e0d\u5339\u914d");
        }
    }

    private Object newResult(String service) {
        ServiceExecutor serviceExecutor = this.servicesHolder.getRequiredServiceExecutor(service);
        return ReflectUtils.newInstance((Class)serviceExecutor.getResultClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeService(String service, ServiceContext serviceContext) {
        ServiceExecutor serviceExecutor = this.servicesHolder.getRequiredServiceExecutor(service);
        try {
            this.eventPublisher.publish((Object)new ServiceApplyEvent(service, serviceContext));
            serviceExecutor.execute(serviceContext);
        }
        catch (Throwable e) {
            this.eventPublisher.publish((Object)new ServiceExceptionEvent(service, serviceContext, e));
        }
        finally {
            this.eventPublisher.publish((Object)new ServiceFinishEvent(service, serviceContext));
        }
    }
}

