/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.service.annotation.service.Service;
import org.bekit.service.annotation.service.ServiceExecute;
import org.bekit.service.engine.ServiceContext;
import org.bekit.service.service.ServiceExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;

public class ServiceParser {
    private static final Logger logger = LoggerFactory.getLogger(ServiceParser.class);

    public static ServiceExecutor parseService(Object service, PlatformTransactionManager txManager) {
        Class serviceClass = AopUtils.getTargetClass((Object)service);
        logger.info("\u89e3\u6790\u670d\u52a1\uff1a{}", (Object)ClassUtils.getQualifiedName((Class)serviceClass));
        Service serviceAnnotation = serviceClass.getAnnotation(Service.class);
        String serviceName = serviceAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = ClassUtils.getShortNameAsProperty((Class)serviceClass);
        }
        ServiceExecutor serviceExecutor = new ServiceExecutor(serviceName, serviceAnnotation.enableTx(), service);
        if (serviceAnnotation.enableTx()) {
            if (txManager == null) {
                throw new IllegalArgumentException("\u670d\u52a1" + serviceAnnotation.name() + "\u7684enableTx\u5c5e\u6027\u4e3a\u5f00\u542f\u72b6\u6001\uff0c\u4f46\u4e0d\u5b58\u5728\u4e8b\u52a1\u7ba1\u7406\u5668\uff08PlatformTransactionManager\uff09\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u914d\u7f6espring\u4e8b\u52a1\u7ba1\u7406\u5668");
            }
            serviceExecutor.setTxExecutor(new TxExecutor(txManager));
        }
        block0: for (Method method : serviceClass.getDeclaredMethods()) {
            for (Class clazz : ServiceExecutor.SERVICE_PHASE_ANNOTATIONS) {
                if (!method.isAnnotationPresent(clazz)) continue;
                serviceExecutor.setPhaseExecutor(clazz, ServiceParser.parseServicePhase(method));
                continue block0;
            }
        }
        serviceExecutor.validate();
        return serviceExecutor;
    }

    private static ServiceExecutor.ServicePhaseExecutor parseServicePhase(Method method) {
        logger.debug("\u89e3\u6790\u670d\u52a1\u65b9\u6cd5\uff1a{}", (Object)method);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("\u670d\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u662fpublic\u7c7b\u578b");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1 || parameterTypes[0] != ServiceContext.class) {
            throw new IllegalArgumentException("\u670d\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u5165\u53c2\u5fc5\u987b\u662f\uff08ServiceContext\uff09");
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("\u670d\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fvoid");
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0);
        Class orderClass = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
        Class resultClass = resolvableType.getGeneric(new int[]{1}).resolve(Object.class);
        if (method.isAnnotationPresent(ServiceExecute.class) && !ClassUtils.hasConstructor((Class)resultClass, (Class[])new Class[0])) {
            throw new IllegalArgumentException("@ServiceExecute\u670d\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u53c2\u6570ServiceContext\u7684\u6cdb\u578b" + ClassUtils.getShortName((Class)resultClass) + "\u5fc5\u987b\u5f97\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570");
        }
        return new ServiceExecutor.ServicePhaseExecutor(method, orderClass, resultClass);
    }
}

