/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.service.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.bekit.service.annotation.service.Service;
import org.bekit.service.service.ServiceExecutor;
import org.bekit.service.service.ServiceParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class ServiceHolder {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private PlatformTransactionManager txManager;
    private Map<String, ServiceExecutor> serviceExecutorMap = new HashMap<String, ServiceExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Service.class)) {
            ServiceExecutor serviceExecutor = ServiceParser.parseService(this.applicationContext.getBean(beanName), this.txManager);
            if (this.serviceExecutorMap.containsKey(serviceExecutor.getServiceName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u670d\u52a1\uff1a" + serviceExecutor.getServiceName());
            }
            this.serviceExecutorMap.put(serviceExecutor.getServiceName(), serviceExecutor);
        }
    }

    public ServiceExecutor getRequiredServiceExecutor(String service) {
        if (!this.serviceExecutorMap.containsKey(service)) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u670d\u52a1" + service);
        }
        return this.serviceExecutorMap.get(service);
    }
}

