/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.cnctrs.bedework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bedework.notifier.db.Subscription;
import org.bedework.notifier.db.SubscriptionImpl;
import org.bedework.notifier.db.SubscriptionWrapper;
import org.bedework.notifier.exception.NoteException;
import org.bedework.util.misc.ToString;

public class BedeworkSubscription
extends SubscriptionWrapper {
    private String userToken;
    private List<String> emails = new ArrayList<String>();
    private String synchToken;
    private List<String> noteHrefs;

    public BedeworkSubscription() throws NoteException {
        super((Subscription)SubscriptionImpl.make());
    }

    public BedeworkSubscription(Subscription sub) throws NoteException {
        super(sub);
        this.init(this.getSubi().getVals());
    }

    public void init(Map vals) throws NoteException {
        super.init(vals);
        SubscriptionImpl subi = this.getSubi();
        this.setUserToken(subi.must("userToken"));
        this.setEmails(subi.mustList("emails"));
        this.setSynchToken(subi.may("synchToken"));
        this.setNoteHrefs(subi.mayList("noteHrefs"));
    }

    public void setUserToken(String val) {
        this.userToken = val;
        this.getSubi().setString("userToken", this.userToken);
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setEmails(List<String> val) {
        this.emails = val;
        this.getSubi().setObject("emails", this.emails);
    }

    public List<String> getEmails() {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
        }
        return this.emails;
    }

    public void addEmail(String val) {
        if (!this.emails.contains(val)) {
            this.emails.add(val);
        }
    }

    public void setSynchToken(String val) {
        this.synchToken = val;
        this.getSubi().setString("synchToken", this.synchToken);
    }

    public String getSynchToken() {
        return this.synchToken;
    }

    public void setNoteHrefs(List<String> val) {
        this.noteHrefs = val;
        this.getSubi().setObject("noteHrefs", this.noteHrefs);
    }

    public List<String> getNoteHrefs() {
        if (this.noteHrefs == null) {
            this.noteHrefs = new ArrayList<String>();
        }
        return this.noteHrefs;
    }

    public void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("userToken", (Object)this.getUserToken());
        ts.append("emails", this.getEmails());
        ts.append("synchToken", (Object)this.getSynchToken());
        ts.append("noteHrefs", this.getNoteHrefs());
    }
}

