/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.cnctrs.bedework;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.message.BasicHeader;
import org.bedework.caldav.util.notifications.BaseNotificationType;
import org.bedework.caldav.util.notifications.NotificationType;
import org.bedework.caldav.util.notifications.admin.AdminNoteParsers;
import org.bedework.caldav.util.notifications.admin.AdminNotificationType;
import org.bedework.caldav.util.notifications.eventreg.EventregBaseNotificationType;
import org.bedework.caldav.util.notifications.eventreg.EventregParsers;
import org.bedework.caldav.util.notifications.parse.Parser;
import org.bedework.caldav.util.notifications.suggest.SuggestBaseNotificationType;
import org.bedework.caldav.util.notifications.suggest.SuggestParsers;
import org.bedework.notifier.cnctrs.AbstractConnectorInstance;
import org.bedework.notifier.cnctrs.Connector;
import org.bedework.notifier.cnctrs.ConnectorInstance;
import org.bedework.notifier.cnctrs.bedework.BedeworkConnector;
import org.bedework.notifier.cnctrs.bedework.BedeworkConnectorConfig;
import org.bedework.notifier.cnctrs.bedework.BedeworkSubscription;
import org.bedework.notifier.db.NotifyDb;
import org.bedework.notifier.db.Subscription;
import org.bedework.notifier.exception.NoteException;
import org.bedework.notifier.notifications.Note;
import org.bedework.util.dav.DavUtil;
import org.bedework.util.http.BasicHttpClient;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.timezones.TimezonesImpl;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.shared.UrlHandler;
import org.bedework.webdav.servlet.shared.UrlUnprefixer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BedeworkConnectorInstance
extends AbstractConnectorInstance {
    private final BedeworkConnectorConfig config;
    private final BedeworkConnector cnctr;
    private BasicHttpClient client;
    private DavUtil dav;
    private static final Collection<QName> noteTypeProps = new ArrayList<QName>();
    protected static Timezones timezones;
    private static final Collection<QName> notificationURLProps;

    BedeworkConnectorInstance(BedeworkConnectorConfig config, BedeworkConnector cnctr, Subscription sub) {
        super(sub);
        this.config = config;
        this.cnctr = cnctr;
    }

    public Connector getConnector() {
        return this.cnctr;
    }

    public boolean changed() throws NoteException {
        return false;
    }

    public boolean check(NotifyDb db, String resource) throws NoteException {
        BasicHttpClient cl = this.getClient();
        try {
            if (this.sub.getUri() == null && !this.getUri()) {
                boolean bl = false;
                return bl;
            }
            String syncToken = this.getBwsub().getSynchToken();
            Collection chs = this.getDav().syncReport(cl, this.sub.getUri(), syncToken, noteTypeProps);
            if (Util.isEmpty((Collection)chs)) {
                boolean bl = false;
                return bl;
            }
            boolean found = false;
            String newSyncToken = null;
            this.getBwsub().getNoteHrefs().clear();
            for (DavUtil.DavChild ch : chs) {
                if (ch.status != 200) continue;
                if (ch.propVals.size() == 1 && ((DavUtil.DavProp)ch.propVals.get((int)0)).name.equals(WebdavTags.syncToken)) {
                    newSyncToken = XmlUtil.getElementContent((Element)((DavUtil.DavProp)ch.propVals.get((int)0)).element);
                    continue;
                }
                DavUtil.DavProp dp = ch.findProp(AppleServerTags.notificationtype);
                if (dp == null) continue;
                this.getBwsub().getNoteHrefs().add(ch.uri);
                found = found || resource != null && !resource.isEmpty() && ch.uri.endsWith(resource);
            }
            if (found && newSyncToken != null) {
                this.getBwsub().setSynchToken(newSyncToken);
            }
            db.update(this.sub);
            boolean bl = found;
            return bl;
        }
        catch (NoteException ne) {
            throw ne;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
        finally {
            if (cl != null) {
                try {
                    cl.release();
                }
                catch (HttpException e) {
                    this.error(e);
                }
                cl.close();
            }
        }
    }

    public Note nextItem(NotifyDb db) throws NoteException {
        if (Util.isEmpty(this.getBwsub().getNoteHrefs())) {
            return null;
        }
        String noteHref = this.getBwsub().getNoteHrefs().get(0);
        if (this.debug()) {
            this.debug("Fetch item " + noteHref);
        }
        BasicHttpClient cl = this.getClient();
        try {
            URL sysUrl = new URL(this.config.getSystemUrl());
            String context = sysUrl.getPath();
            String urlPrefix = sysUrl.toString();
            if (context != null) {
                urlPrefix = urlPrefix.substring(0, urlPrefix.length() - context.length());
            }
            UrlHandler urlHandler = new UrlHandler(urlPrefix, context, false);
            InputStream is = cl.get(noteHref, "application/xml", this.getAuthHeaders());
            NotificationType nt = Parser.fromXml((InputStream)is);
            Map extraValues = this.checkExtraValues(cl, nt);
            nt.getNotification().unprefixHrefs((UrlUnprefixer)urlHandler);
            String strNote = nt.toXml(true);
            nt = Parser.fromXml((String)strNote);
            ConnectorInstance.ItemInfo item = new ConnectorInstance.ItemInfo(noteHref, null);
            Note note = new Note(item, nt);
            note.setExtraValues(extraValues);
            note.addDeliveryMethod(Note.DeliveryMethod.email);
            this.getBwsub().getNoteHrefs().remove(0);
            db.update(this.sub);
            Note note2 = note;
            return note2;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
        finally {
            if (cl != null) {
                try {
                    cl.release();
                }
                catch (HttpException e) {
                    this.error(e);
                }
                cl.close();
            }
        }
    }

    public boolean completeItem(NotifyDb db, Note note) throws NoteException {
        NotificationType notification = note.getNotification();
        QName noteType = notification.getNotification().getElementName();
        if (noteType.equals(AppleServerTags.resourceChange)) {
            this.deleteItem(note);
        } else {
            this.replaceItem(note);
        }
        return true;
    }

    private Map checkExtraValues(BasicHttpClient cl, NotificationType nt) throws NoteException {
        BaseNotificationType bnt = nt.getNotification();
        String href = null;
        if (bnt instanceof SuggestBaseNotificationType) {
            SuggestBaseNotificationType sbnt = (SuggestBaseNotificationType)bnt;
            href = sbnt.getHref();
        } else if (bnt instanceof AdminNotificationType) {
            AdminNotificationType adnt = (AdminNotificationType)bnt;
            href = adnt.getHref();
        } else if (bnt instanceof EventregBaseNotificationType) {
            EventregBaseNotificationType ebnt = (EventregBaseNotificationType)bnt;
            href = ebnt.getHref();
        }
        if (href == null) {
            return null;
        }
        try {
            Summary summary;
            DtEnd dtend;
            List<Header> headers = this.getAuthHeaders();
            headers.add((Header)new BasicHeader("ACCEPT", "text/calendar"));
            InputStream is = cl.get(href, null, headers);
            CalendarBuilder cb = new CalendarBuilder(Timezones.getTzRegistry());
            Calendar cal = cb.build(is);
            CalendarComponent comp = cal.getComponent("VEVENT");
            if (comp == null) {
                return null;
            }
            HashMap<String, Object> extraValues = new HashMap<String, Object>();
            extraValues.put("event", comp);
            DtStart dtstart = (DtStart)comp.getProperty("DTSTART");
            if (dtstart != null) {
                extraValues.put("dtstart", dtstart.getDate());
            }
            if ((dtend = (DtEnd)comp.getProperty("DTEND")) != null) {
                extraValues.put("dtend", dtend.getDate());
            }
            if ((summary = (Summary)comp.getProperty("SUMMARY")) != null) {
                extraValues.put("summary", summary.getValue());
            }
            return extraValues;
        }
        catch (Throwable t) {
            this.error(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteItem(Note note) throws NoteException {
        ConnectorInstance.ItemInfo item = note.getItemInfo();
        BasicHttpClient cl = this.getClient();
        try {
            int response = cl.delete(item.href, this.getAuthHeaders());
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.error(t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cl != null) {
                try {
                    cl.release();
                }
                catch (HttpException e) {
                    this.error(e);
                }
                cl.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceItem(Note note) throws NoteException {
        BasicHttpClient cl = this.getClient();
        try {
            ConnectorInstance.ItemInfo item = note.getItemInfo();
            String xml = note.getNotification().toXml(true);
            int response = cl.putObject(item.href, this.getAuthHeaders(), (Object)xml, "application/xml");
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.error(t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cl != null) {
                try {
                    cl.release();
                }
                catch (HttpException e) {
                    this.error(e);
                }
                cl.close();
            }
        }
    }

    private BedeworkSubscription getBwsub() {
        return (BedeworkSubscription)this.sub;
    }

    private boolean getUri() throws NoteException {
        BasicHttpClient cl = this.getClient();
        try {
            DavUtil.DavChild dc = this.getDav().getProps(cl, this.sub.getPrincipalHref().substring(1), notificationURLProps);
            if (dc == null) {
                if (this.debug()) {
                    this.debug("No response getting notification collection");
                }
                return false;
            }
            DavUtil.DavProp dp = dc.findProp(WebdavTags.notificationURL);
            if (dp == null || dp.status != 200) {
                dp = dc.findProp(AppleServerTags.notificationURL);
            }
            if (dp == null || dp.status != 200) {
                if (this.debug()) {
                    this.debug("No notification collection");
                }
                return false;
            }
            Element href = XmlUtil.getOnlyElement((Node)dp.element);
            this.sub.setUri(XmlUtil.getElementContent((Element)href));
            return true;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
    }

    private BasicHttpClient getClient() throws NoteException {
        if (this.client != null) {
            return this.client;
        }
        try {
            this.client = new BasicHttpClient(30000, false);
            this.client.setBaseURI(new URI(this.config.getSystemUrl()));
            return this.client;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
    }

    List<Header> getAuthHeaders() {
        String userToken = this.getBwsub().getUserToken();
        ArrayList<Header> authheaders = new ArrayList<Header>(this.cnctr.getAuthHeaders());
        if (userToken == null) {
            return authheaders;
        }
        authheaders.add((Header)new BasicHeader("X-BEDEWORK-NOTEPR", this.sub.getPrincipalHref()));
        authheaders.add((Header)new BasicHeader("X-BEDEWORK-PT", userToken));
        return authheaders;
    }

    private DavUtil getDav() throws NoteException {
        if (this.dav != null) {
            return this.dav;
        }
        try {
            this.dav = new DavUtil(this.getAuthHeaders());
            return this.dav;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
    }

    static {
        noteTypeProps.add(AppleServerTags.notificationtype);
        new SuggestParsers();
        new EventregParsers();
        new AdminNoteParsers();
        timezones = new TimezonesImpl();
        try {
            Timezones.initTimezones((String)"http://localhost:8080/tzsvr");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        notificationURLProps = Arrays.asList(WebdavTags.notificationURL, AppleServerTags.notificationURL);
    }
}

