/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.cnctrs.bedework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.bedework.notifier.NotifyDefs;
import org.bedework.notifier.NotifyEngine;
import org.bedework.notifier.NotifyRegistry;
import org.bedework.notifier.cnctrs.AbstractConnector;
import org.bedework.notifier.cnctrs.Connector;
import org.bedework.notifier.cnctrs.bedework.BedeworkConnectorConfig;
import org.bedework.notifier.cnctrs.bedework.BedeworkConnectorInstance;
import org.bedework.notifier.cnctrs.bedework.BedeworkSubscription;
import org.bedework.notifier.db.NotifyDb;
import org.bedework.notifier.db.Subscription;
import org.bedework.notifier.db.SubscriptionWrapper;
import org.bedework.notifier.exception.NoteException;
import org.bedework.notifier.notifications.Note;
import org.bedework.util.misc.Util;

public class BedeworkConnector
extends AbstractConnector<BedeworkConnector, BedeworkConnectorInstance, Note, BedeworkConnectorConfig> {
    private List<Header> authheaders;

    public void start(NotifyDb db, String callbackUri, NotifyEngine notifier) throws NoteException {
        super.start(db, callbackUri, notifier);
        this.initSpecialNotifications(db);
        this.running = true;
    }

    public NotifyRegistry.Info getInfo() {
        Authenticator authenticator = new Authenticator();
        authenticator.conf = (BedeworkConnectorConfig)this.config;
        return new NotifyRegistry.Info(this.getConnectorName(), BedeworkSubscription.class, (NotifyRegistry.Authenticator)authenticator);
    }

    public Subscription subscribe(NotifyDb db, Map<?, ?> vals) throws NoteException {
        String userToken = BedeworkConnector.must((String)"userToken", vals);
        String href = Util.buildPath((boolean)true, (String[])new String[]{BedeworkConnector.must((String)"href", vals)});
        List emails = BedeworkConnector.mustList((String)"emailAddresses", vals);
        Subscription theSub = db.find(this.getConnectorName(), href);
        if (theSub == null) {
            if (this.debug) {
                this.trace("Adding subscription");
            }
            BedeworkSubscription sub = new BedeworkSubscription();
            sub.setConnectorName(this.getConnectorName());
            sub.setPrincipalHref(Util.buildPath((boolean)true, (String[])new String[]{href}));
            sub.setUserToken(userToken);
            sub.setEmails(emails);
            db.add((Subscription)sub);
            return sub;
        }
        if (this.debug) {
            this.trace("Updating subscription");
        }
        BedeworkSubscription sub = new BedeworkSubscription(theSub);
        for (String email : emails) {
            sub.addEmail(email);
        }
        sub.setUserToken(userToken);
        db.update((Subscription)sub);
        return sub;
    }

    public Subscription unsubscribe(NotifyDb db, Map<?, ?> vals) throws NoteException {
        String href = Util.buildPath((boolean)true, (String[])new String[]{BedeworkConnector.must((String)"href", vals)});
        List emails = BedeworkConnector.mayList((String)"emailAddresses", vals);
        Subscription theSub = db.find(this.getConnectorName(), href);
        if (theSub == null) {
            return null;
        }
        BedeworkSubscription sub = new BedeworkSubscription(theSub);
        if (Util.isEmpty((Collection)emails)) {
            db.delete((Subscription)sub);
            sub.setDeleted(true);
            return sub;
        }
        for (String email : emails) {
            sub.getEmails().remove(email);
        }
        if (Util.isEmpty(sub.getEmails())) {
            db.delete((Subscription)sub);
            sub.setDeleted(true);
            return sub;
        }
        db.update((Subscription)sub);
        return sub;
    }

    public boolean isManager() {
        return false;
    }

    public NotifyDefs.NotifyKind getKind() {
        return NotifyDefs.NotifyKind.poll;
    }

    public boolean isReadOnly() {
        return ((BedeworkConnectorConfig)this.config).getReadOnly();
    }

    public boolean getTrustLastmod() {
        return ((BedeworkConnectorConfig)this.config).getTrustLastmod();
    }

    public BedeworkConnectorInstance getConnectorInstance(NotifyDb db, Subscription sub) throws NoteException {
        if (!this.running) {
            return null;
        }
        return new BedeworkConnectorInstance((BedeworkConnectorConfig)this.config, this, (Subscription)this.rewrap(sub));
    }

    private BedeworkSubscription rewrap(Subscription sub) throws NoteException {
        if (sub instanceof BedeworkSubscription) {
            return (BedeworkSubscription)sub;
        }
        if (sub instanceof SubscriptionWrapper) {
            return new BedeworkSubscription(((SubscriptionWrapper)sub).getSubscription());
        }
        return new BedeworkSubscription(sub);
    }

    public BedeworkNotificationBatch handleCallback(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) throws NoteException {
        return null;
    }

    public void respondCallback(HttpServletResponse resp, Connector.NotificationBatch<Note> notifications) throws NoteException {
    }

    public void stop() throws NoteException {
        this.stopped = true;
    }

    List<Header> getAuthHeaders() {
        if (this.authheaders != null) {
            return this.authheaders;
        }
        String id = ((BedeworkConnectorConfig)this.config).getName();
        String token = ((BedeworkConnectorConfig)this.config).getToken();
        if (id == null || token == null) {
            return null;
        }
        this.authheaders = new ArrayList<Header>(1);
        this.authheaders.add((Header)new BasicHeader("X-BEDEWORK-NOTE", id + ":" + token));
        this.authheaders.add((Header)new BasicHeader("X-BEDEWORK-EXTENSIONS", "true"));
        return this.authheaders;
    }

    private void initSpecialNotifications(NotifyDb db) throws NoteException {
        try {
            if (((BedeworkConnectorConfig)this.config).getSystemNotificationHref() == null) {
                return;
            }
            if (this.debug) {
                this.trace("Notification collections available on " + ((BedeworkConnectorConfig)this.config).getSystemNotificationHref());
            }
            BedeworkSubscription sub = new BedeworkSubscription();
            sub.setTransientSub(true);
            sub.setConnectorName(this.getConnectorName());
            sub.setPrincipalHref(((BedeworkConnectorConfig)this.config).getSystemNotificationHref());
            db.add((Subscription)sub);
            this.notifier.addNotificationMsg((Subscription)sub);
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
    }

    class BedeworkNotificationBatch
    extends Connector.NotificationBatch<Note> {
        BedeworkNotificationBatch() {
        }
    }

    private static class Authenticator
    implements NotifyRegistry.Authenticator {
        BedeworkConnectorConfig conf;

        private Authenticator() {
        }

        public boolean authenticate(String token) throws NoteException {
            return token != null && this.conf.getToken() != null && token.equals(this.conf.getToken());
        }
    }
}

