/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.bedework.eventreg.bus.FormFields;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.FieldDef;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.db.Registration;
import org.bedework.eventreg.web.AuthAbstractController;
import org.springframework.web.servlet.ModelAndView;

public class EventregController
extends AuthAbstractController {
    public ModelAndView doRequest() throws Throwable {
        Event ev = this.sessMan.getCurrEvent();
        int maxTicketsAllowed = ev.getMaxTickets();
        if (maxTicketsAllowed < 0) {
            return this.errorReturn("Cannot register for this event.");
        }
        Date end = ev.getRegistrationEndDate();
        if (end == null) {
            return this.errorReturn("Application register: missing end date.");
        }
        this.sessMan.setDeadlinePassed(new Date().after(end));
        if (this.sessMan.getDeadlinePassed()) {
            if (this.debug()) {
                this.debug("event registration stop - deadline has passed");
            }
            return this.errorReturn("Cannot register for this event - deadline has passed");
        }
        if (!this.registerUserInEvent(ev)) {
            if (this.debug()) {
                this.debug("event registration stop - waitlist is full");
            }
            return this.errorReturn("Cannot register for this event - waitlist is full");
        }
        return this.sessModel("eventreg");
    }

    private boolean registerUserInEvent(Event ev) throws Throwable {
        Registration reg;
        String href = this.req.getHref();
        if (this.debug()) {
            this.debug("Event details: " + this.sessMan.getCurrentUser() + " " + href);
        }
        if ((reg = this.sessMan.getRegistration()) != null) {
            reg.setLastmod();
            this.adjustTickets(reg);
            reg.setComment(this.req.getComment());
            this.sessMan.updateRegistration(reg);
            return true;
        }
        reg = new Registration();
        reg.setAuthid(this.sessMan.getCurrentUser());
        reg.setComment(this.req.getComment());
        reg.setType("reg");
        reg.setHref(href);
        reg.setRegistrationId(this.sessMan.getNextRegistrationId());
        String email = this.req.getEmail();
        if (email == null) {
            email = this.sessMan.getCurrEmail();
        }
        if (this.debug()) {
            this.debug("req.email=" + this.req.getEmail() + " current=" + email);
        }
        reg.setEmail(email);
        reg.setEvSummary(ev.getSummary());
        reg.setEvDate(ev.getDate());
        reg.setEvTime(ev.getTime());
        reg.setEvLocation(ev.getLocation());
        reg.setTimestamps();
        if (this.adjustTickets(reg) == AuthAbstractController.AdjustResult.waitListFull) {
            return false;
        }
        this.handleFormInfo(reg);
        this.sessMan.addRegistration(reg);
        this.sessMan.getChangeManager().addChange(reg, "New_Reg");
        return true;
    }

    private String handleFormInfo(Registration reg) throws Throwable {
        String calsuite = this.sessMan.getCurrentCalsuite();
        if (calsuite == null) {
            return "No calsuite";
        }
        String formName = this.sessMan.getCurrentFormName();
        FormDef form = this.sessMan.getFormDef(formName);
        if (form == null) {
            return "Form " + formName + " does not exist";
        }
        reg.setFormOwner(calsuite);
        reg.setFormName(formName);
        FormFields ffs = new FormFields(form.getFields());
        List required = ffs.getRequiredFormEls();
        Enumeration params = this.req.getRequest().getParameterNames();
        HashMap<String, Object> vals = new HashMap<String, Object>();
        while (params.hasMoreElements()) {
            String[] val;
            String param = (String)params.nextElement();
            FieldDef fd = ffs.getField(param);
            if (fd == null) continue;
            if (fd.getRequired()) {
                required.remove(fd);
            }
            if ((val = this.req.getRequest().getParameterValues(param)).length == 0) {
                if (!fd.getRequired()) continue;
                return "Missing required field(s)";
            }
            if (val.length > 1) {
                if (!fd.getMultivalued()) {
                    return "Invalid field (multi)";
                }
                vals.put(param, val);
                continue;
            }
            vals.put(param, val[0]);
        }
        reg.saveFormValues(vals);
        return null;
    }
}

