/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web;

import org.bedework.eventreg.bus.ChangeManager;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.Registration;
import org.bedework.eventreg.web.AbstractController;
import org.bedework.eventreg.web.AuthAbstractController;
import org.springframework.web.servlet.ModelAndView;

public abstract class AuthAbstractController
extends AbstractController {
    protected boolean admin;

    protected ModelAndView setup() throws Throwable {
        ModelAndView mv = super.setup();
        if (mv != null) {
            return mv;
        }
        if (this.sessMan.getCurrentUser() == null) {
            return this.errorReturn("Not authenticated");
        }
        return null;
    }

    protected ModelAndView updateRegistration() throws Throwable {
        Registration reg;
        Long regId = this.req.getRegistrationId();
        if (regId == null) {
            return this.errorReturn("No registration id supplied");
        }
        if (this.debug()) {
            this.debug("updating registration " + regId);
        }
        if ((reg = this.sessMan.getRegistrationById(regId.longValue())) == null) {
            return this.errorReturn("No registration found.");
        }
        if (!this.admin && !reg.getAuthid().equals(this.sessMan.getCurrentUser())) {
            return this.errorReturn("You are not authorized to update that registration.");
        }
        this.adjustTickets(reg);
        if (this.admin) {
            reg.setComment(this.req.getComment());
        }
        this.sessMan.updateRegistration(reg);
        this.sessMan.setMessage("Registration number " + regId + " updated: admin: " + this.admin + " user: " + this.sessMan.getCurrentUser());
        return null;
    }

    protected ModelAndView removeRegistration(boolean admin) throws Throwable {
        Registration reg;
        Long regId = this.req.getRegistrationId();
        if (regId == null) {
            return this.errorReturn("No registration id supplied");
        }
        if (this.debug()) {
            this.debug("remove reg id: " + regId + ", user: " + this.sessMan.getCurrentUser());
        }
        if ((reg = this.sessMan.getRegistrationById(regId.longValue())) == null) {
            return this.errorReturn("No registration found.");
        }
        if (!admin && !reg.getAuthid().equals(this.sessMan.getCurrentUser())) {
            return this.errorReturn("You are not authorized to remove that registration.");
        }
        this.reallocate(reg.getNumTickets(), reg.getHref());
        this.sessMan.removeRegistration(reg);
        this.sessMan.getChangeManager().deleteReg(reg);
        return null;
    }

    protected void adjustTickets() throws Throwable {
        Event currEvent = this.sessMan.getCurrEvent();
        long allocated = this.sessMan.getRegTicketCount();
        int total = currEvent.getMaxTickets();
        int available = (int)((long)total - allocated);
        if (available <= 0) {
            return;
        }
        this.reallocate(available, this.req.getHref());
    }

    protected AdjustResult adjustTickets(Registration reg) throws Throwable {
        Event currEvent = this.sessMan.getCurrEvent();
        int numTickets = this.req.getTicketsRequested();
        if (numTickets < 0) {
            return AdjustResult.notickets;
        }
        int change = numTickets - reg.getTicketsRequested();
        if (change == 0) {
            return AdjustResult.nochange;
        }
        if (!this.admin && change > 0) {
            int toAllocate;
            String waitListLimitVal = currEvent.getWaitListLimit();
            int total = currEvent.getMaxTickets();
            long allocated = this.sessMan.getRegTicketCount();
            long available = Math.max(0L, (long)total - allocated);
            if (waitListLimitVal != null) {
                boolean percentage = waitListLimitVal.endsWith("%");
                if (percentage) {
                    waitListLimitVal = waitListLimitVal.substring(0, waitListLimitVal.length() - 1);
                }
                int waitListLimit = Integer.valueOf(waitListLimitVal);
                if (percentage) {
                    waitListLimit = total * waitListLimit / 100;
                }
                long waiting = this.sessMan.getWaitingTicketCount();
                if (available < (long)change && waiting + (long)change - available > (long)waitListLimit) {
                    return AdjustResult.waitListFull;
                }
            }
            if ((toAllocate = (int)Math.min((long)change, available)) != change) {
                // empty if block
            }
            change = toAllocate;
        }
        if (reg.getWaitqDate() == null || change > 0) {
            reg.setWaitqDate();
        }
        reg.setTicketsRequested(numTickets);
        ChangeManager chgMan = this.sessMan.getChangeManager();
        if (change < 0) {
            reg.removeTickets(-change);
            chgMan.addChange(reg, "Upd_Reg", ChangeManager.ChangeItem.makeUpdNumTickets((int)change));
            this.reallocate(-change, reg.getHref());
            return AdjustResult.removed;
        }
        reg.addTickets(change);
        chgMan.addChange(reg, "Upd_Reg", ChangeManager.ChangeItem.makeUpdNumTickets((int)change));
        return AdjustResult.added;
    }
}

