/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.bus;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.bedework.eventreg.bus.ChangeManager;
import org.bedework.eventreg.bus.ContextListener;
import org.bedework.eventreg.bus.Request;
import org.bedework.eventreg.common.BwConnector;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.db.Change;
import org.bedework.eventreg.db.DbItem;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.EventregDb;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.db.Registration;
import org.bedework.eventreg.requests.EventregRequest;
import org.bedework.eventreg.requests.RegistrationAction;
import org.bedework.eventreg.service.EventregProperties;
import org.bedework.eventreg.service.EventregSvcMBean;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.Timezones;

public class SessionManager
implements Logged {
    private ChangeManager chgMan;
    private Timestamp ts = new Timestamp(System.currentTimeMillis());
    private EventregDb db;
    private String currentUser;
    private String currentCalsuite;
    private Request req;
    private Event currEvent;
    private boolean deadlinePassed;
    private boolean registrationFull;
    private String message = "";
    private boolean open;
    private BwConnector cnctr;
    private static final XcalUtil.TzGetter tzs = new /* Unavailable Anonymous Inner Class!! */;
    private String currentFormName;
    private String currEmail;
    private BwLogger logger = new BwLogger();

    public SessionManager() throws EventregException {
        this.chgMan = new ChangeManager(this);
    }

    public EventregSvcMBean getSysInfo() throws EventregException {
        try {
            return ContextListener.getSysInfo();
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    public ChangeManager getChangeManager() {
        return this.chgMan;
    }

    public void setEventregDb(EventregDb db) throws Throwable {
        try {
            this.db = db;
            db.setSysInfo((EventregProperties)this.getSysInfo());
            db.open();
            Timezones.initTimezones((String)this.getSysInfo().getTzsUri());
            this.cnctr = new BwConnector(this.getSysInfo().getWsdlUri(), tzs);
        }
        catch (Throwable t) {
            this.error(t);
            throw new Exception(t);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public synchronized void openDb() throws Throwable {
        if (this.db == null) {
            return;
        }
        if (this.open) {
            return;
        }
        this.db.open();
        this.open = true;
    }

    public synchronized void rollbackDb() throws Throwable {
        if (this.db == null) {
            return;
        }
        this.db.rollback();
        this.open = false;
    }

    public synchronized boolean closeDb() {
        if (this.db == null) {
            return true;
        }
        this.open = false;
        return this.db.close();
    }

    public boolean queueRequest(EventregRequest request) throws Throwable {
        return this.getSysInfo().queueRequest(request);
    }

    public void setCurrentUser(String val) {
        this.currentUser = val;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void resetCurrentCalsuite() {
        this.currentCalsuite = null;
    }

    public void setCurrentCalsuite(String val) {
        if (val != null) {
            this.currentCalsuite = val;
        }
    }

    public String getCurrentCalsuite() {
        return this.currentCalsuite;
    }

    public void setCurrentFormName(String val) throws Exception {
        this.currentFormName = val;
    }

    public String getCurrentFormName() {
        return this.currentFormName;
    }

    public boolean getAdminUser() throws Throwable {
        String adminToken = this.getSysInfo().getEventregAdminToken();
        if (adminToken == null) {
            return false;
        }
        return adminToken.equals(this.req.getAdminToken());
    }

    public void flushCurrEvent() {
        this.currEvent = null;
        this.cnctr.flush();
    }

    public Event getCurrEvent() throws Throwable {
        return this.getCurrEvent(this.req.getHref());
    }

    public String getCurrEmail() throws Throwable {
        if (this.currEmail == null) {
            if (this.debug()) {
                this.debug("Try to get email for " + this.currentUser);
            }
            this.currEmail = this.getEmail();
        }
        return this.currEmail;
    }

    public Event getCurrEvent(String href) throws Throwable {
        if (this.currEvent != null && this.currEvent.getHref().equals(href)) {
            this.debug("Returning cached event.");
            return this.currEvent;
        }
        if (href == null) {
            return null;
        }
        this.debug("Fetching event.");
        this.currEvent = this.retrieveEvent(href);
        return this.currEvent;
    }

    public void addChange(Change c) throws Throwable {
        this.db.addChange(c);
    }

    public List<Change> getChanges(String ts) throws Throwable {
        return this.db.getChanges(ts);
    }

    public void addRegistration(Registration r) throws Throwable {
        this.db.add((DbItem)r);
        this.queueRequest((EventregRequest)new RegistrationAction(r));
    }

    public void removeRegistration(Registration reg) throws Throwable {
        this.db.delete((DbItem)reg);
    }

    public void updateRegistration(Registration reg) throws Throwable {
        reg.setLastmod();
        this.db.update((DbItem)reg);
        this.queueRequest((EventregRequest)new RegistrationAction(reg));
    }

    public List<Registration> getRegistrationsByUser(String user) throws Throwable {
        return this.db.getByUser(user);
    }

    public Registration getRegistrationById(long id) throws Throwable {
        return this.db.getByid(Long.valueOf(id));
    }

    public List<Registration> getAllRegistrations() throws Throwable {
        return this.db.getAllRegistrations();
    }

    public List<Registration> getWaiting(String href) throws Throwable {
        return this.db.getWaiting(href);
    }

    public List<Registration> getRegistrationsByHref(String href) throws Throwable {
        return this.db.getByEvent(href);
    }

    public Registration getRegistration() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            this.debug("Getting registration for " + this.getCurrentUser() + " on " + this.getCurrEvent().getHref());
            Registration registration = this.db.getUserRegistration(this.getCurrEvent().getHref(), this.getCurrentUser());
            return registration;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    public boolean getIsRegistered() throws Throwable {
        Registration reg = this.getRegistration();
        return reg != null;
    }

    public boolean getIsWaiting() throws Throwable {
        Registration reg = this.getRegistration();
        if (reg == null) {
            return false;
        }
        return reg.getNumTickets() < reg.getTicketsRequested();
    }

    public boolean getRegistrationFull() {
        return this.registrationFull;
    }

    public void setRegistrationFull(boolean val) {
        this.registrationFull = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRegistrantCount() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            long l = this.db.getRegistrantCount(this.getCurrEvent().getHref());
            return l;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRegTicketCount() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            this.debug("Getting registered/held ticket count for " + this.getCurrEvent().getHref());
            long l = this.db.getRegTicketCount(this.getCurrEvent().getHref());
            return l;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitingTicketCount() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            this.debug("Getting waiting list ticket count for " + this.getCurrEvent().getHref());
            long l = this.db.getWaitingTicketCount(this.getCurrEvent().getHref());
            return l;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTicketCount() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            this.debug("Getting ticket count for " + this.getCurrEvent().getHref());
            long l = this.db.getTicketCount(this.getCurrEvent().getHref());
            return l;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUserTicketCount() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            long l = this.db.getUserTicketCount(this.getCurrEvent().getHref(), this.getCurrentUser());
            return l;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    public boolean getDeadlinePassed() {
        return this.deadlinePassed;
    }

    public void setDeadlinePassed(boolean val) {
        this.deadlinePassed = val;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Event retrieveEvent(String href) throws Throwable {
        return this.cnctr.getEvent(href);
    }

    public Event retrieveEvent(Registration reg) throws Throwable {
        return this.cnctr.getEvent(reg.getHref());
    }

    public void logout() {
        if (this.debug()) {
            this.debug("logout for " + this.ts);
        }
        try {
            HttpSession sess = this.req.getRequest().getSession(false);
            if (sess != null) {
                sess.invalidate();
            }
        }
        catch (Throwable t) {
            this.warn("Exception on logout " + t.getLocalizedMessage());
        }
    }

    public boolean setReq(Request val) throws Throwable {
        if (this.debug()) {
            this.debug("setReq for " + this.ts);
        }
        this.req = val;
        String reqUser = this.req.getRequest().getRemoteUser();
        if (this.getCurrentUser() != null) {
            boolean forceLogout;
            boolean bl = forceLogout = !Util.equalsString((String)reqUser, (String)this.getCurrentUser());
            if (forceLogout) {
                HttpSession sess = this.req.getRequest().getSession(false);
                if (sess != null) {
                    sess.invalidate();
                }
                this.req.getResponse().setStatus(403);
                return false;
            }
        }
        this.setCurrentUser(reqUser);
        this.setCurrentCalsuite(this.req.getCalsuite());
        if (this.req.formNamePresent()) {
            this.setCurrentFormName(this.req.getFormName());
        }
        return true;
    }

    public Request getReq() {
        return this.req;
    }

    public Long getNextRegistrationId() throws Throwable {
        return this.db.getNextRegistrationId();
    }

    public List<FormDef> getFormDefs() throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            List list = this.db.getCalSuiteForms(this.currentCalsuite);
            return list;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDef getFormDef(String formName) throws Throwable {
        boolean wasOpen = this.open;
        try {
            if (!this.open) {
                this.openDb();
            }
            FormDef formDef = this.db.getCalSuiteForm(formName, this.currentCalsuite);
            return formDef;
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    public void addFormDef(FormDef val) throws Throwable {
        boolean wasOpen = this.open;
        if (!val.getOwner().equals(this.currentCalsuite)) {
            throw new EventregException("Owner not current calsuite");
        }
        try {
            if (!this.open) {
                this.openDb();
            }
            this.db.add((DbItem)val);
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    public void removeFormDef(FormDef val) throws Throwable {
        boolean wasOpen = this.open;
        if (!val.getOwner().equals(this.currentCalsuite)) {
            throw new EventregException("Owner not current calsuite");
        }
        try {
            if (!this.open) {
                this.openDb();
            }
            this.db.delete((DbItem)val);
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    public void updateFormDef(FormDef val) throws Throwable {
        boolean wasOpen = this.open;
        if (!val.getOwner().equals(this.currentCalsuite)) {
            throw new EventregException("Owner not current calsuite");
        }
        try {
            if (!this.open) {
                this.openDb();
            }
            this.db.update((DbItem)val);
        }
        finally {
            if (!wasOpen) {
                this.closeDb();
            }
        }
    }

    private String getEmail() throws EventregException {
        if (this.currentUser == null) {
            return null;
        }
        String email = this.getSelfregEmail();
        if (email != null) {
            return email;
        }
        String defDomain = this.getSysInfo().getDefaultEmailDomain();
        if (defDomain == null) {
            return null;
        }
        return this.currentUser + "@" + defDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelfregEmail() throws EventregException {
        Connection con = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/selfregDS");
            con = ds.getConnection();
            con.setAutoCommit(false);
            pstmt = con.prepareStatement("select bw_email from bw_accounts WHERE bw_account = ?");
            pstmt.setString(1, this.currentUser);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String string = rs.getString("bw_email");
            return string;
        }
        catch (Throwable t) {
            this.error(t);
            String string = null;
            return string;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Throwable x) {
                    this.warn("Exception on close " + x.getLocalizedMessage());
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable x) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable x) {
                    this.warn("Exception on close " + x.getLocalizedMessage());
                }
            }
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

