/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web;

import java.util.Date;
import org.bedework.eventreg.bus.FormFields;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.web.AuthAbstractController;
import org.springframework.web.servlet.ModelAndView;

public class InitController
extends AuthAbstractController {
    public ModelAndView doRequest() throws Throwable {
        this.sessMan.flushCurrEvent();
        Event ev = this.sessMan.getCurrEvent();
        if (ev == null) {
            return this.errorReturn("Cannot retrieve the event.");
        }
        int maxTickets = ev.getMaxTickets();
        if (maxTickets < 0) {
            return this.errorReturn("Cannot register for this event.");
        }
        long curTickets = this.sessMan.getRegTicketCount();
        if (this.debug()) {
            this.debug("maxTickets: " + maxTickets);
            this.debug("curTickets: " + curTickets);
        }
        this.sessMan.setRegistrationFull(curTickets >= (long)maxTickets);
        Date end = ev.getRegistrationEndDate();
        if (end == null) {
            return this.errorReturn("Application register: missing end date.");
        }
        this.sessMan.setDeadlinePassed(new Date().after(end));
        if (!this.req.formNamePresent()) {
            if (this.debug()) {
                this.debug("No form specified");
            }
            return this.sessModel("init");
        }
        String formName = this.req.getFormName();
        FormDef form = this.sessMan.getFormDef(formName);
        if (this.sessMan.getCurrentCalsuite() == null) {
            return this.errorReturn("No calsuite");
        }
        if (form == null) {
            this.warn("Form " + formName + "does not exist");
            return this.sessModel("init");
        }
        this.sessMan.setCurrentFormName(formName);
        if (this.debug()) {
            this.debug("Set form name " + formName + " for form with " + form.getFields().size() + " fields");
        }
        return this.objModel("init", "form", (Object)form, "fields", (Object)new FormFields(form.getFields()));
    }
}

