/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.eventreg.bus.Request;
import org.bedework.eventreg.bus.SessionManager;
import org.bedework.eventreg.db.Registration;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public abstract class AbstractController
implements Logged,
Controller {
    protected SessionManager sessMan;
    protected Request req;
    private String forwardSuccess;
    private String forwardFail;
    private String forwardTo;
    private BwLogger logger = new BwLogger();

    public abstract ModelAndView doRequest() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ModelAndView mv = this.setup();
            if (mv != null) {
                ModelAndView modelAndView = mv;
                return modelAndView;
            }
            ModelAndView modelAndView = this.doRequest();
            return modelAndView;
        }
        catch (Exception e) {
            this.error((Throwable)e);
            ModelAndView modelAndView = this.errorReturn((Throwable)e);
            return modelAndView;
        }
        catch (Throwable t) {
            this.error(t);
            ModelAndView modelAndView = this.errorReturn(t);
            return modelAndView;
        }
        finally {
            if (!this.sessMan.closeDb()) {
                this.errorReturn("Error during close");
            }
        }
    }

    protected ModelAndView setup() throws Throwable {
        this.req = this.sessMan.getReq();
        this.sessMan.setMessage("");
        if (this.debug()) {
            this.debug("Entry: " + this.getClass().getSimpleName());
            this.dumpRequest(this.req.getRequest());
        }
        return null;
    }

    protected ModelAndView sessModel(String view) {
        HashMap<String, Object> myModel = new HashMap<String, Object>();
        myModel.put("sessMan", this.sessMan);
        myModel.put("req", this.req);
        return new ModelAndView(view, myModel);
    }

    protected ModelAndView objModel(String view, String name, Object m) {
        HashMap<String, Object> myModel = new HashMap<String, Object>();
        myModel.put("sessMan", this.sessMan);
        myModel.put("req", this.req);
        myModel.put(name, m);
        return new ModelAndView(view, myModel);
    }

    protected ModelAndView objModel(String view, String name, Object m, String name2, Object m2) {
        HashMap<String, Object> myModel = new HashMap<String, Object>();
        myModel.put("sessMan", this.sessMan);
        myModel.put("req", this.req);
        myModel.put(name, m);
        myModel.put(name2, m2);
        return new ModelAndView(view, myModel);
    }

    protected ModelAndView errorReturn(Throwable t) {
        return this.errorReturn(t.getLocalizedMessage());
    }

    protected ModelAndView errorReturn(String msg) {
        return this.errorReturn(this.getForwardFail(), msg);
    }

    protected ModelAndView errorReturn(String forward, String msg) {
        this.sessMan.setMessage(msg);
        HashMap<String, Object> myModel = new HashMap<String, Object>();
        myModel.put("sessMan", this.sessMan);
        myModel.put("req", this.req);
        return new ModelAndView(forward, myModel);
    }

    public void setSessionManager(SessionManager sm) {
        this.sessMan = sm;
    }

    public void setForwardTo(String val) {
        this.forwardTo = val;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public void setForwardSuccess(String val) {
        this.forwardSuccess = val;
    }

    public String getForwardSuccess() {
        return this.forwardSuccess;
    }

    public void setForwardFail(String val) {
        this.forwardFail = val;
    }

    public String getForwardFail() {
        return this.forwardFail;
    }

    public void dumpRequest(HttpServletRequest req) {
        try {
            Enumeration names = req.getParameterNames();
            String title = "Request parameters";
            this.debug("Request parameters - global info and uris");
            this.debug("getRequestURI = " + req.getRequestURI());
            this.debug("getRemoteUser = " + req.getRemoteUser());
            this.debug("getRequestedSessionId = " + req.getRequestedSessionId());
            this.debug("HttpUtils.getRequestURL(req) = " + req.getRequestURL());
            this.debug("query=" + req.getQueryString());
            this.debug("contentlen=" + req.getContentLength());
            this.debug("request=" + req);
            this.debug("parameters:");
            this.debug("Request parameters");
            while (names.hasMoreElements()) {
                String[] vals;
                String key = (String)names.nextElement();
                for (String val : vals = req.getParameterValues(key)) {
                    this.debug("  " + key + " = \"" + val + "\"");
                }
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    protected void reallocate(int numTickets, String href) throws Throwable {
        List regs = this.sessMan.getWaiting(href);
        int remaining = numTickets;
        for (Registration reg : regs) {
            int required = reg.getTicketsRequested() - reg.getNumTickets();
            if (required <= 0) continue;
            required = Math.min(required, remaining);
            reg.addTickets(required);
            this.sessMan.updateRegistration(reg);
            this.sessMan.getChangeManager().addTicketsAdded(reg, required);
            if (reg.getTicketsRequested() == reg.getNumTickets()) {
                this.sessMan.getChangeManager().addRegFulfilled(reg);
            }
            if ((remaining -= required) > 0) continue;
            break;
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

