/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.bus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bedework.eventreg.db.FieldDef;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class FormFields
implements Logged,
Iterator<FieldDef>,
Iterable<FieldDef> {
    private final Set<FieldDef> fields;
    final List<FieldDef> formEls = new ArrayList();
    final Iterator<FieldDef> formElsIt;
    private FieldDef lastFieldDef;
    private static Comparator<FieldDef> orderComparator = new /* Unavailable Anonymous Inner Class!! */;
    private BwLogger logger = new BwLogger();

    public FormFields(Set<FieldDef> fields) {
        this.fields = fields;
        for (FieldDef fd : fields) {
            if (fd.getType().equals("option")) continue;
            this.formEls.add(fd);
        }
        Collections.sort(this.formEls, orderComparator);
        this.formElsIt = this.formEls.iterator();
    }

    public int size() {
        if (this.formEls == null) {
            return 0;
        }
        return this.formEls.size();
    }

    public Set<FieldDef> getFields() {
        return this.fields;
    }

    public FieldDef getField(String fieldName) {
        for (FieldDef fd : this.fields) {
            if (!fd.getName().equals(fieldName)) continue;
            return fd;
        }
        return null;
    }

    public List<FieldDef> getFormEls() {
        return this.formEls;
    }

    public List<FieldDef> getRequiredFormEls() {
        ArrayList<FieldDef> formEls = new ArrayList<FieldDef>();
        for (FieldDef fd : this.fields) {
            if (fd.getType().equals("option") || !fd.getRequired()) continue;
            formEls.add(fd);
        }
        return formEls;
    }

    public List<FieldDef> getOptions() {
        ArrayList<FieldDef> options = new ArrayList<FieldDef>();
        if (this.lastFieldDef == null) {
            return options;
        }
        for (FieldDef fd : this.fields) {
            if (!fd.getType().equals("option") || !fd.getGroup().equals(this.lastFieldDef.getName())) continue;
            options.add(fd);
        }
        Collections.sort(options, orderComparator);
        return options;
    }

    @Override
    public boolean hasNext() {
        return this.formElsIt.hasNext();
    }

    @Override
    public FieldDef next() {
        this.lastFieldDef = (FieldDef)this.formElsIt.next();
        return this.lastFieldDef;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Iterator<FieldDef> iterator() {
        return this;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

